/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.util.classpath;

import com.gradleware.tooling.toolingmodel.OmniAccessRule;
import com.gradleware.tooling.toolingmodel.OmniClasspathAttribute;
import com.gradleware.tooling.toolingmodel.OmniClasspathEntry;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.JavaCore;

public final class ClasspathUtils {
    private ClasspathUtils() {
    }

    public static IAccessRule[] createAccessRules(OmniClasspathEntry entry) {
        List rules = entry.getAccessRules().isPresent() ? (List)entry.getAccessRules().get() : Collections.emptyList();
        IAccessRule[] accessRules = new IAccessRule[rules.size()];
        for (int i = 0; i < rules.size(); ++i) {
            OmniAccessRule rule = (OmniAccessRule)rules.get(i);
            accessRules[i] = JavaCore.newAccessRule((IPath)new Path(rule.getPattern()), (int)rule.getKind());
        }
        return accessRules;
    }

    public static IClasspathAttribute[] createClasspathAttributes(OmniClasspathEntry entry) {
        List attributes = entry.getClasspathAttributes().isPresent() ? (List)entry.getClasspathAttributes().get() : Collections.emptyList();
        IClasspathAttribute[] classpathAttributes = new IClasspathAttribute[attributes.size()];
        for (int i = 0; i < attributes.size(); ++i) {
            OmniClasspathAttribute attribute = (OmniClasspathAttribute)attributes.get(i);
            classpathAttributes[i] = JavaCore.newClasspathAttribute((String)attribute.getName(), (String)attribute.getValue());
        }
        return classpathAttributes;
    }
}

