/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.mass.services;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.core.data.capellacore.Feature;
import org.polarsys.capella.core.data.capellacore.Type;
import org.polarsys.capella.core.data.cs.AbstractDeploymentLink;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.DeployableElement;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.model.handler.helpers.CapellaProjectHelper;
import org.polarsys.capella.vp.mass.generic.IMassVisitor;
import org.polarsys.capella.vp.mass.helpers.MassHelper;
import org.polarsys.capella.vp.mass.mass.Mass;

public class CapellaMassVisitor
implements IMassVisitor {
    public static CapellaMassVisitor INSTANCE = new CapellaMassVisitor();

    protected Part getCorrectPartObject(EObject container) {
        PhysicalComponent pc;
        if (!(container instanceof Part) && !(container instanceof PhysicalComponent)) {
            return null;
        }
        if (container instanceof Part) {
            return (Part)container;
        }
        if (container instanceof PhysicalComponent && (MassHelper.isPhysicalSystem((EObject)(pc = (PhysicalComponent)container)) || CapellaProjectHelper.isReusableComponentsDriven((EObject)pc) == CapellaProjectHelper.TriStateBoolean.False)) {
            return (Part)pc.getAbstractTypedElements().get(0);
        }
        return null;
    }

    @Override
    public Mass getMassObject(EObject eObject) {
        if (eObject instanceof Mass) {
            return (Mass)eObject;
        }
        Part thePart = this.getCorrectPartObject(eObject);
        if (thePart != null) {
            for (EObject eO : thePart.eContents()) {
                if (!(eO instanceof Mass)) continue;
                return (Mass)eO;
            }
        }
        return null;
    }

    @Override
    public EList<Mass> getMassObjects(EObject container) {
        BasicEList wpCriteriaObjectList = new BasicEList();
        Part thePart = this.getCorrectPartObject(container);
        if (thePart != null) {
            for (EObject eO : thePart.eContents()) {
                if (!(eO instanceof Mass)) continue;
                wpCriteriaObjectList.add((Object)((Mass)eO));
            }
        }
        return wpCriteriaObjectList;
    }

    @Override
    public EList<EObject> getSubComponentsObjects(EObject eObject) {
        BasicEList list = new BasicEList();
        AbstractType type = null;
        EList deployedLinkList = null;
        if (eObject instanceof Part) {
            type = ((Part)eObject).getAbstractType();
            deployedLinkList = ((Part)eObject).getDeploymentLinks();
        } else if (eObject instanceof Component) {
            type = eObject;
        }
        if (type != null && type instanceof Component) {
            Component pc = (Component)type;
            for (Feature feature : pc.getOwnedFeatures()) {
                EList deploying;
                Part part;
                Type type2;
                if (!(feature instanceof Part) || !((type2 = (part = (Part)feature).getType()) instanceof PhysicalComponent) || (deploying = part.getDeployingParts()) != null && deploying.size() != 0) continue;
                list.add((Object)part);
            }
        }
        if (deployedLinkList != null && deployedLinkList.size() > 0) {
            for (AbstractDeploymentLink curDeploymentLink : deployedLinkList) {
                DeployableElement deployedComponent = curDeploymentLink.getDeployedElement();
                if (!(deployedComponent instanceof Part)) continue;
                list.add((Object)deployedComponent);
            }
        }
        return list;
    }
}

