/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.basic.requirement.transition.extension;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.polarsys.capella.basic.requirement.RequirementsPkg;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.ExecutionManagerRegistry;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.core.transition.common.handlers.activity.IActivityExtender;
import org.polarsys.kitalpha.ad.services.manager.ViewpointActivationException;
import org.polarsys.kitalpha.ad.services.manager.ViewpointManager;
import org.polarsys.kitalpha.ad.viewpoint.predicate.exceptions.EvaluationException;
import org.polarsys.kitalpha.cadence.core.api.parameter.ActivityParameters;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class EnableViewpoint
implements IActivityExtender {
    public IStatus init(IContext context) {
        return Status.OK_STATUS;
    }

    public IStatus dispose(IContext context) {
        return Status.OK_STATUS;
    }

    public IStatus preActivity(IContext context, String activityIdentifier, ActivityParameters activityParams) {
        return Status.OK_STATUS;
    }

    public IStatus postActivity(IContext context, String activityIdentifier, ActivityParameters activityParams) {
        Resource capellaResource;
        if (this.isSubsystemTransition(context) && this.containsRequirements(capellaResource = (Resource)context.get((Object)"_T_T_Res"))) {
            URI airdResource = capellaResource.getURI().trimFileExtension().appendFileExtension("aird");
            URI afmResource = capellaResource.getURI().trimFileExtension().appendFileExtension("afm");
            Path path = new Path(airdResource.toPlatformString(true));
            IFile airdFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
            if (airdFile.exists()) {
                Session session = SessionManager.INSTANCE.getExistingSession(airdResource);
                if (session != null) {
                    this.referenceAird(session);
                } else {
                    this.referenceAfm(afmResource);
                }
            } else {
                this.referenceAfm(afmResource);
            }
        }
        return Status.OK_STATUS;
    }

    private boolean containsRequirements(Resource capellaResource) {
        if (capellaResource == null) {
            return false;
        }
        TreeIterator obj = EcoreUtil.getAllContents((Collection)capellaResource.getContents());
        while (obj.hasNext()) {
            Object next = obj.next();
            if (!(next instanceof RequirementsPkg)) continue;
            return true;
        }
        return false;
    }

    protected boolean isSubsystemTransition(IContext context) {
        return Objects.toString(context.get((Object)"TRANSPOSER_MAPPING")).contains("subsystem");
    }

    protected void referenceAird(Session session) {
        ViewpointManager manager = ViewpointManager.getInstance((ResourceSet)session.getTransactionalEditingDomain().getResourceSet());
        try {
            if (!manager.isReferenced("org.polarsys.capella.basic.requirement")) {
                manager.activate("org.polarsys.capella.basic.requirement");
                session.save((IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (ViewpointActivationException | EvaluationException e) {
            e.printStackTrace();
        }
    }

    protected void referenceAfm(final URI afm) {
        final ExecutionManager em = ExecutionManagerRegistry.getInstance().addNewManager();
        em.execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                Resource res = em.getEditingDomain().getResourceSet().getResource(afm, true);
                ViewpointManager manager = ViewpointManager.getInstance((ResourceSet)em.getEditingDomain().getResourceSet());
                try {
                    if (!manager.isReferenced("org.polarsys.capella.basic.requirement")) {
                        manager.activate("org.polarsys.capella.basic.requirement");
                        res.save(new HashMap());
                        em.getEditingDomain().dispose();
                    }
                }
                catch (IOException | ViewpointActivationException | EvaluationException e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

