/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.model.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.polarsys.capella.common.lib.IdGenerator;
import org.polarsys.capella.cybersecurity.model.CybersecurityConfiguration;
import org.polarsys.capella.cybersecurity.model.CybersecurityFactory;
import org.polarsys.capella.cybersecurity.model.CybersecurityPackage;
import org.polarsys.capella.cybersecurity.model.CybersecurityPkg;
import org.polarsys.capella.cybersecurity.model.EnterprisePrimaryAsset;
import org.polarsys.capella.cybersecurity.model.FunctionStorage;
import org.polarsys.capella.cybersecurity.model.FunctionalPrimaryAsset;
import org.polarsys.capella.cybersecurity.model.InformationPrimaryAsset;
import org.polarsys.capella.cybersecurity.model.PrimaryAssetMember;
import org.polarsys.capella.cybersecurity.model.PrimaryAssetStorage;
import org.polarsys.capella.cybersecurity.model.SecurityNeeds;
import org.polarsys.capella.cybersecurity.model.Threat;
import org.polarsys.capella.cybersecurity.model.ThreatApplication;
import org.polarsys.capella.cybersecurity.model.ThreatInvolvement;
import org.polarsys.capella.cybersecurity.model.ThreatSourceUse;
import org.polarsys.capella.cybersecurity.model.TrustBoundaryStorage;
import org.polarsys.capella.cybersecurity.model.impl.CybersecurityConfigurationImpl;
import org.polarsys.capella.cybersecurity.model.impl.CybersecurityPkgImpl;
import org.polarsys.capella.cybersecurity.model.impl.EnterprisePrimaryAssetImpl;
import org.polarsys.capella.cybersecurity.model.impl.FunctionStorageImpl;
import org.polarsys.capella.cybersecurity.model.impl.FunctionalPrimaryAssetImpl;
import org.polarsys.capella.cybersecurity.model.impl.InformationPrimaryAssetImpl;
import org.polarsys.capella.cybersecurity.model.impl.PrimaryAssetMemberImpl;
import org.polarsys.capella.cybersecurity.model.impl.PrimaryAssetStorageImpl;
import org.polarsys.capella.cybersecurity.model.impl.SecurityNeedsImpl;
import org.polarsys.capella.cybersecurity.model.impl.ThreatApplicationImpl;
import org.polarsys.capella.cybersecurity.model.impl.ThreatImpl;
import org.polarsys.capella.cybersecurity.model.impl.ThreatInvolvementImpl;
import org.polarsys.capella.cybersecurity.model.impl.ThreatSourceUseImpl;
import org.polarsys.capella.cybersecurity.model.impl.TrustBoundaryStorageImpl;

public class CybersecurityFactoryImpl
extends EFactoryImpl
implements CybersecurityFactory {
    public static CybersecurityFactory init() {
        try {
            CybersecurityFactory theCybersecurityFactory = (CybersecurityFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.polarsys.org/capella/cybersecurity/1.0");
            if (theCybersecurityFactory != null) {
                return theCybersecurityFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new CybersecurityFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createCybersecurityPkg();
            }
            case 1: {
                return this.createThreat();
            }
            case 2: {
                return this.createThreatInvolvement();
            }
            case 3: {
                return this.createFunctionStorage();
            }
            case 4: {
                return this.createThreatApplication();
            }
            case 5: {
                return this.createPrimaryAssetStorage();
            }
            case 6: {
                return this.createSecurityNeeds();
            }
            case 7: {
                return this.createTrustBoundaryStorage();
            }
            case 9: {
                return this.createFunctionalPrimaryAsset();
            }
            case 10: {
                return this.createInformationPrimaryAsset();
            }
            case 11: {
                return this.createPrimaryAssetMember();
            }
            case 12: {
                return this.createCybersecurityConfiguration();
            }
            case 13: {
                return this.createEnterprisePrimaryAsset();
            }
            case 14: {
                return this.createThreatSourceUse();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    @Override
    public CybersecurityPkg createCybersecurityPkg() {
        CybersecurityPkgImpl cybersecurityPkg = new CybersecurityPkgImpl();
        cybersecurityPkg.setId(IdGenerator.createId());
        return cybersecurityPkg;
    }

    @Override
    public Threat createThreat() {
        ThreatImpl threat = new ThreatImpl();
        threat.setId(IdGenerator.createId());
        return threat;
    }

    @Override
    public ThreatInvolvement createThreatInvolvement() {
        ThreatInvolvementImpl threatInvolvement = new ThreatInvolvementImpl();
        threatInvolvement.setId(IdGenerator.createId());
        return threatInvolvement;
    }

    @Override
    public FunctionStorage createFunctionStorage() {
        FunctionStorageImpl functionStorage = new FunctionStorageImpl();
        functionStorage.setId(IdGenerator.createId());
        return functionStorage;
    }

    @Override
    public ThreatApplication createThreatApplication() {
        ThreatApplicationImpl threatApplication = new ThreatApplicationImpl();
        threatApplication.setId(IdGenerator.createId());
        return threatApplication;
    }

    @Override
    public PrimaryAssetStorage createPrimaryAssetStorage() {
        PrimaryAssetStorageImpl primaryAssetStorage = new PrimaryAssetStorageImpl();
        primaryAssetStorage.setId(IdGenerator.createId());
        return primaryAssetStorage;
    }

    @Override
    public SecurityNeeds createSecurityNeeds() {
        SecurityNeedsImpl securityNeeds = new SecurityNeedsImpl();
        securityNeeds.setId(IdGenerator.createId());
        return securityNeeds;
    }

    @Override
    public TrustBoundaryStorage createTrustBoundaryStorage() {
        TrustBoundaryStorageImpl trustBoundaryStorage = new TrustBoundaryStorageImpl();
        trustBoundaryStorage.setId(IdGenerator.createId());
        return trustBoundaryStorage;
    }

    @Override
    public FunctionalPrimaryAsset createFunctionalPrimaryAsset() {
        FunctionalPrimaryAssetImpl functionalPrimaryAsset = new FunctionalPrimaryAssetImpl();
        functionalPrimaryAsset.setId(IdGenerator.createId());
        return functionalPrimaryAsset;
    }

    @Override
    public InformationPrimaryAsset createInformationPrimaryAsset() {
        InformationPrimaryAssetImpl informationPrimaryAsset = new InformationPrimaryAssetImpl();
        informationPrimaryAsset.setId(IdGenerator.createId());
        return informationPrimaryAsset;
    }

    @Override
    public PrimaryAssetMember createPrimaryAssetMember() {
        PrimaryAssetMemberImpl primaryAssetMember = new PrimaryAssetMemberImpl();
        primaryAssetMember.setId(IdGenerator.createId());
        return primaryAssetMember;
    }

    @Override
    public CybersecurityConfiguration createCybersecurityConfiguration() {
        CybersecurityConfigurationImpl cybersecurityConfiguration = new CybersecurityConfigurationImpl();
        cybersecurityConfiguration.setId(IdGenerator.createId());
        return cybersecurityConfiguration;
    }

    @Override
    public EnterprisePrimaryAsset createEnterprisePrimaryAsset() {
        EnterprisePrimaryAssetImpl enterprisePrimaryAsset = new EnterprisePrimaryAssetImpl();
        enterprisePrimaryAsset.setId(IdGenerator.createId());
        return enterprisePrimaryAsset;
    }

    @Override
    public ThreatSourceUse createThreatSourceUse() {
        ThreatSourceUseImpl threatSourceUse = new ThreatSourceUseImpl();
        threatSourceUse.setId(IdGenerator.createId());
        return threatSourceUse;
    }

    @Override
    public CybersecurityPackage getCybersecurityPackage() {
        return (CybersecurityPackage)this.getEPackage();
    }

    @Deprecated
    public static CybersecurityPackage getPackage() {
        return CybersecurityPackage.eINSTANCE;
    }

    public CybersecurityPkg createCybersecurityPkg(String name_p) {
        CybersecurityPkg cybersecurityPkg = this.createCybersecurityPkg();
        cybersecurityPkg.setName(name_p);
        return cybersecurityPkg;
    }

    public Threat createThreat(String name_p) {
        Threat threat = this.createThreat();
        threat.setName(name_p);
        return threat;
    }

    public FunctionStorage createFunctionStorage(String name_p) {
        FunctionStorage functionStorage = this.createFunctionStorage();
        functionStorage.setName(name_p);
        return functionStorage;
    }

    public PrimaryAssetStorage createPrimaryAssetStorage(String name_p) {
        PrimaryAssetStorage primaryAssetStorage = this.createPrimaryAssetStorage();
        primaryAssetStorage.setName(name_p);
        return primaryAssetStorage;
    }

    public SecurityNeeds createSecurityNeeds(String name_p) {
        SecurityNeeds securityNeeds = this.createSecurityNeeds();
        securityNeeds.setName(name_p);
        return securityNeeds;
    }

    public TrustBoundaryStorage createTrustBoundaryStorage(String name_p) {
        TrustBoundaryStorage trustBoundaryStorage = this.createTrustBoundaryStorage();
        trustBoundaryStorage.setName(name_p);
        return trustBoundaryStorage;
    }

    public FunctionalPrimaryAsset createFunctionalPrimaryAsset(String name_p) {
        FunctionalPrimaryAsset functionalPrimaryAsset = this.createFunctionalPrimaryAsset();
        functionalPrimaryAsset.setName(name_p);
        return functionalPrimaryAsset;
    }

    public InformationPrimaryAsset createInformationPrimaryAsset(String name_p) {
        InformationPrimaryAsset informationPrimaryAsset = this.createInformationPrimaryAsset();
        informationPrimaryAsset.setName(name_p);
        return informationPrimaryAsset;
    }

    public CybersecurityConfiguration createCybersecurityConfiguration(String name_p) {
        CybersecurityConfiguration cybersecurityConfiguration = this.createCybersecurityConfiguration();
        cybersecurityConfiguration.setName(name_p);
        return cybersecurityConfiguration;
    }

    public EnterprisePrimaryAsset createEnterprisePrimaryAsset(String name_p) {
        EnterprisePrimaryAsset enterprisePrimaryAsset = this.createEnterprisePrimaryAsset();
        enterprisePrimaryAsset.setName(name_p);
        return enterprisePrimaryAsset;
    }
}

