/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.sirius.analysis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.PrimitiveIterator;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.BorderedStyle;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.EdgeStyle;
import org.eclipse.sirius.diagram.Ellipse;
import org.eclipse.sirius.diagram.business.api.query.DDiagramQuery;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.DStylizable;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.eclipse.sirius.viewpoint.Style;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.swt.graphics.Font;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.menu.dynamic.util.INamePrefixService;
import org.polarsys.capella.common.platform.sirius.ted.SemanticEditingDomainFactory;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.EnumerationPropertyLiteral;
import org.polarsys.capella.core.data.capellacore.EnumerationPropertyType;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.information.AbstractEventOperation;
import org.polarsys.capella.core.data.information.AbstractInstance;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.data.interaction.StateFragment;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.data.oa.EntityPkg;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentNature;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.FunctionalChainExt;
import org.polarsys.capella.core.sirius.analysis.CapellaServices;
import org.polarsys.capella.core.sirius.analysis.CsServices;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.core.sirius.analysis.ShapeUtil;
import org.polarsys.capella.core.sirius.ui.helper.SessionHelper;
import org.polarsys.capella.cybersecurity.model.CybersecurityFactory;
import org.polarsys.capella.cybersecurity.model.CybersecurityPackage;
import org.polarsys.capella.cybersecurity.model.CybersecurityPkg;
import org.polarsys.capella.cybersecurity.model.CybersecurityQueries;
import org.polarsys.capella.cybersecurity.model.EnterprisePrimaryAsset;
import org.polarsys.capella.cybersecurity.model.FunctionStorage;
import org.polarsys.capella.cybersecurity.model.FunctionalPrimaryAsset;
import org.polarsys.capella.cybersecurity.model.InformationPrimaryAsset;
import org.polarsys.capella.cybersecurity.model.PrimaryAsset;
import org.polarsys.capella.cybersecurity.model.PrimaryAssetMember;
import org.polarsys.capella.cybersecurity.model.SecurityNeeds;
import org.polarsys.capella.cybersecurity.model.Threat;
import org.polarsys.capella.cybersecurity.model.ThreatApplication;
import org.polarsys.capella.cybersecurity.model.ThreatInvolvement;
import org.polarsys.capella.cybersecurity.model.ThreatSourceUse;
import org.polarsys.capella.cybersecurity.model.TrustBoundaryStorage;
import org.polarsys.capella.cybersecurity.sirius.analysis.ExtensibleElementExt;
import org.polarsys.capella.cybersecurity.sirius.analysis.Messages;
import org.polarsys.kitalpha.emde.model.ExtensibleElement;

public class CybersecurityServices {
    private static final String TRUSTED_COMPONENT_DECORATION = "/org.polarsys.capella.cybersecurity.model.edit/icons/full/ovr16/Trusted.png";
    private static final String UNTRUSTED_COMPONENT_DECORATION = "/org.polarsys.capella.cybersecurity.model.edit/icons/full/ovr16/NotTrusted.png";
    private static final String DATASTORAGE_DECORATION = "/org.polarsys.capella.cybersecurity.model.edit/icons/full/ovr16/DataStorage.png";
    private static final String REMANENT_DECORATION = "/org.polarsys.capella.cybersecurity.model.edit/icons/full/ovr16/RemanentData.png";
    private static final String THREATSOURCE_DECORATION = "/org.polarsys.capella.cybersecurity.model.edit/icons/full/ovr16/ThreatSource.png";
    private static final String PRIMARY_ASSET_DECORATION = "/org.polarsys.capella.cybersecurity.model.edit/icons/full/ovr16/PrimaryAsset.png";
    private static final String FLAME_DECORATION = "/org.polarsys.capella.cybersecurity.model.edit/icons/full/ovr16/TrustLimit.png";
    final INamePrefixService prefixService = (INamePrefixService)PlatformUI.getWorkbench().getService(INamePrefixService.class);
    final PrimitiveIterator.OfInt colorRands = new Random().ints(0, 255).iterator();

    public CybersecurityPkg getDefaultCyberSecurityPackage(EObject any, boolean create) {
        BlockArchitecture ba;
        BlockArchitecture blockArchitecture = ba = any instanceof BlockArchitecture ? (BlockArchitecture)any : (BlockArchitecture)EcoreUtil2.getFirstContainer((EObject)any, (EClass)CsPackage.Literals.BLOCK_ARCHITECTURE);
        if (ba == null) {
            return null;
        }
        CybersecurityPkg pkg = this.getRootCibersecurityPkg(ba);
        if (pkg != null) {
            return pkg;
        }
        if (create) {
            pkg = CybersecurityFactory.eINSTANCE.createCybersecurityPkg();
            pkg.setName(Messages.CybersecurityServices_0);
            ba.getOwnedExtensions().add((Object)pkg);
            return pkg;
        }
        return null;
    }

    public CybersecurityPkg getRootCibersecurityPkg(BlockArchitecture ba) {
        return ba.getOwnedExtensions().stream().filter(CybersecurityPkg.class::isInstance).findFirst().orElse(null);
    }

    public Threat createThreat(EObject any) {
        Session session = SessionManager.INSTANCE.getSession(any);
        if (session != null) {
            Project project = SessionHelper.getCapellaProject((Session)session);
            return this.createThreat(any, project);
        }
        return null;
    }

    public Threat createThreat(EObject any, Project project) {
        CybersecurityPkg pkg = this.getDefaultCyberSecurityPackage(any, true);
        if (pkg != null) {
            Threat threat = this.createThreatInPkg(pkg);
            CybersecurityQueries.setThreatKindFromIndex((Threat)threat, (int)0, (EnumerationPropertyType)CybersecurityQueries.getThreatKindPropertyType((Project)project));
            return threat;
        }
        return null;
    }

    public Threat createThreatInPkg(CybersecurityPkg pkg) {
        Threat threat = CybersecurityFactory.eINSTANCE.createThreat();
        pkg.getOwnedThreats().add((Object)threat);
        String elementPrefix = this.prefixService.getPrefix((EObject)threat);
        String uniqueName = CapellaServices.getService().getUniqueName((AbstractNamedElement)threat, elementPrefix);
        threat.setName(uniqueName);
        return threat;
    }

    public String getThreatLabel(Threat threat) {
        String defaultLabel = EObjectLabelProviderHelper.getText((Object)threat);
        if (threat.getKind() != null) {
            String kind = threat.getKind().getName().toUpperCase();
            return String.valueOf(defaultLabel) + "\n(" + kind + ")";
        }
        return String.valueOf(defaultLabel) + "\n(UNDEFINED)";
    }

    public String getPrimaryAssetLabel(EObject asset) {
        return EObjectLabelProviderHelper.getText((Object)asset);
    }

    public String getActorLabel(EObject actor) {
        return EObjectLabelProviderHelper.getText((Object)actor);
    }

    public Collection<EObject> getABPrimaryAssetScope(DSemanticDecorator view) {
        EObject object = view.getTarget();
        CybersecurityPkg cspkg = this.getDefaultCyberSecurityPackage(object, false);
        if (cspkg != null) {
            return new ArrayList<EObject>(EObjectExt.getAll((EObject)cspkg, (EClass)CybersecurityPackage.Literals.PRIMARY_ASSET));
        }
        return Collections.emptyList();
    }

    public Collection<EObject> getABThreatScope(DSemanticDecorator view) {
        EObject object = view.getTarget();
        CybersecurityPkg cspkg = this.getDefaultCyberSecurityPackage(object, false);
        if (cspkg != null) {
            return new ArrayList<EObject>(EObjectExt.getAll((EObject)cspkg, (EClass)CybersecurityPackage.Literals.THREAT));
        }
        return Collections.emptyList();
    }

    public int getAssetColor1Red(DSemanticDecorator view) {
        EObject e = view.getTarget();
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)view);
        if (e instanceof Part && ((Part)e).getAbstractType() instanceof Component && !this.isSupportingAssetHighlightedComponent(view)) {
            return 0;
        }
        if (e instanceof Entity && !this.isSupportingAssetHighlightedComponent(view)) {
            return 0;
        }
        if (diagram != null) {
            DDiagramElement element;
            int nbOfElements = 0;
            int color = 0;
            for (PrimaryAsset asset : this.getRelatedAssets(e)) {
                element = DiagramServices.getDiagramServices().getDiagramElement(diagram, (EObject)asset);
                if (element == null || !(element instanceof DNode)) continue;
                ++nbOfElements;
                color = ((Ellipse)element.getStyle()).getColor().getRed();
            }
            for (Threat threat : this.getRelatedThreats(e)) {
                element = DiagramServices.getDiagramServices().getDiagramElement(diagram, (EObject)threat);
                if (element == null || !(element instanceof DNode)) continue;
                ++nbOfElements;
                color = ((Ellipse)element.getStyle()).getColor().getRed();
            }
            return nbOfElements > 1 ? 0 : color;
        }
        return 0;
    }

    public int getAssetColor1Blue(DSemanticDecorator view) {
        EObject e = view.getTarget();
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)view);
        if (e instanceof Part && ((Part)e).getAbstractType() instanceof Component && !this.isSupportingAssetHighlightedComponent(view)) {
            return 0;
        }
        if (e instanceof Entity && !this.isSupportingAssetHighlightedComponent(view)) {
            return 0;
        }
        if (diagram != null) {
            DDiagramElement element;
            int nbOfElements = 0;
            int color = 0;
            for (PrimaryAsset asset : this.getRelatedAssets(e)) {
                element = DiagramServices.getDiagramServices().getDiagramElement(diagram, (EObject)asset);
                if (element == null || !(element instanceof DNode)) continue;
                ++nbOfElements;
                color = ((Ellipse)element.getStyle()).getColor().getBlue();
            }
            for (Threat threat : this.getRelatedThreats(e)) {
                element = DiagramServices.getDiagramServices().getDiagramElement(diagram, (EObject)threat);
                if (element == null || !(element instanceof DNode)) continue;
                ++nbOfElements;
                color = ((Ellipse)element.getStyle()).getColor().getBlue();
            }
            return nbOfElements > 1 ? 0 : color;
        }
        return 0;
    }

    public int getAssetColor1Green(DSemanticDecorator view) {
        EObject e = view.getTarget();
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)view);
        if (e instanceof Part && ((Part)e).getAbstractType() instanceof Component && !this.isSupportingAssetHighlightedComponent(view)) {
            return 0;
        }
        if (e instanceof Entity && !this.isSupportingAssetHighlightedComponent(view)) {
            return 0;
        }
        if (diagram != null) {
            DDiagramElement element;
            int nbOfElements = 0;
            int color = 0;
            for (PrimaryAsset asset : this.getRelatedAssets(e)) {
                element = DiagramServices.getDiagramServices().getDiagramElement(diagram, (EObject)asset);
                if (element == null || !(element instanceof DNode)) continue;
                ++nbOfElements;
                color = ((Ellipse)element.getStyle()).getColor().getGreen();
            }
            for (Threat threat : this.getRelatedThreats(e)) {
                element = DiagramServices.getDiagramServices().getDiagramElement(diagram, (EObject)threat);
                if (element == null || !(element instanceof DNode)) continue;
                ++nbOfElements;
                color = ((Ellipse)element.getStyle()).getColor().getGreen();
            }
            return nbOfElements > 1 ? 0 : color;
        }
        return 0;
    }

    private int computeColorByLiteral(int literalValue, int literalSize, int colorMin, int colorMax) {
        if (literalValue == literalSize - 1) {
            return colorMax;
        }
        if (literalValue == 1) {
            return colorMin;
        }
        return (literalSize - literalValue - 1) * (colorMin - colorMax) / (literalSize - 2) + colorMax;
    }

    public int getSecurityNeedsGreen(DSemanticDecorator view) {
        int color;
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)view);
        int colorMinVal = 210;
        int colorMaxVal = 20;
        int colorGreenMin = colorMinVal;
        if (diagram == null) {
            return colorGreenMin;
        }
        ModelElement element = (ModelElement)view.getTarget();
        Set activatedLayerNames = new DDiagramQuery(diagram).getAllActivatedLayers().stream().map(IdentifiedElement::getName).collect(Collectors.toSet());
        Session session = SessionManager.INSTANCE.getSession((EObject)view);
        Project project = SessionHelper.getCapellaProject((Session)session);
        if (activatedLayerNames.contains("Cybersecurity Security Needs Confidentiality")) {
            int confidentialitySize;
            int confidentiality = this.getConfidentiality(element);
            color = this.computeColorByLiteral(confidentiality, confidentialitySize = CybersecurityQueries.getConfidentialitySize((Project)project), colorMinVal, colorMaxVal);
            int n = colorGreenMin = color < colorGreenMin ? color : colorGreenMin;
        }
        if (activatedLayerNames.contains("Cybersecurity Security Needs Integrity")) {
            int integritySize;
            int integrity = this.getIntegrity(element);
            color = this.computeColorByLiteral(integrity, integritySize = CybersecurityQueries.getIntegritySize((Project)project), colorMinVal, colorMaxVal);
            int n = colorGreenMin = color < colorGreenMin ? color : colorGreenMin;
        }
        if (activatedLayerNames.contains("Cybersecurity Security Needs Availability")) {
            int availabilitySize;
            int availability = this.getAvailability(element);
            color = this.computeColorByLiteral(availability, availabilitySize = CybersecurityQueries.getAvailabilitySize((Project)project), colorMinVal, colorMaxVal);
            int n = colorGreenMin = color < colorGreenMin ? color : colorGreenMin;
        }
        if (activatedLayerNames.contains("Cybersecurity Security Needs Traceability")) {
            int traceabilitySize;
            int traceability = this.getTraceability(element);
            color = this.computeColorByLiteral(traceability, traceabilitySize = CybersecurityQueries.getTraceabilitySize((Project)project), colorMinVal, colorMaxVal);
            colorGreenMin = color < colorGreenMin ? color : colorGreenMin;
        }
        return colorGreenMin;
    }

    public FunctionalPrimaryAsset createFunctionalPrimaryAsset(EObject any) {
        return this.createFunctionalPrimaryAssetInPkg(this.getDefaultCyberSecurityPackage(any, true));
    }

    public FunctionalPrimaryAsset createFunctionalPrimaryAssetInPkg(CybersecurityPkg pkg) {
        FunctionalPrimaryAsset asset = (FunctionalPrimaryAsset)this.attachToDefaultCybersecurityPkg((EObject)CybersecurityFactory.eINSTANCE.createFunctionalPrimaryAsset(), pkg);
        if (asset != null) {
            String elementPrefix = BlockArchitectureExt.getRootBlockArchitecture((EObject)asset) instanceof OperationalAnalysis ? "OperationalActivityPrimaryAsset" : this.prefixService.getPrefix((EObject)asset);
            String uniqueName = CapellaServices.getService().getUniqueName((AbstractNamedElement)asset, elementPrefix);
            asset.setName(uniqueName);
        }
        return asset;
    }

    public InformationPrimaryAsset createInformationPrimaryAsset(EObject any) {
        return this.createInformationPrimaryAssetInPkg(this.getDefaultCyberSecurityPackage(any, true));
    }

    public InformationPrimaryAsset createInformationPrimaryAssetInPkg(CybersecurityPkg pkg) {
        InformationPrimaryAsset asset = (InformationPrimaryAsset)this.attachToDefaultCybersecurityPkg((EObject)CybersecurityFactory.eINSTANCE.createInformationPrimaryAsset(), pkg);
        if (asset != null) {
            String elementPrefix = this.prefixService.getPrefix((EObject)asset);
            String uniqueName = CapellaServices.getService().getUniqueName((AbstractNamedElement)asset, elementPrefix);
            asset.setName(uniqueName);
        }
        return asset;
    }

    public EnterprisePrimaryAsset createEnterprisePrimaryAsset(EObject any) {
        return this.createEnterprisePrimaryAssetInPkg(this.getDefaultCyberSecurityPackage(any, true));
    }

    public EnterprisePrimaryAsset createEnterprisePrimaryAssetInPkg(CybersecurityPkg pkg) {
        EnterprisePrimaryAsset asset = (EnterprisePrimaryAsset)this.attachToDefaultCybersecurityPkg((EObject)CybersecurityFactory.eINSTANCE.createEnterprisePrimaryAsset(), pkg);
        if (asset != null) {
            String elementPrefix = this.prefixService.getPrefix((EObject)asset);
            String uniqueName = CapellaServices.getService().getUniqueName((AbstractNamedElement)asset, elementPrefix);
            asset.setName(uniqueName);
        }
        return asset;
    }

    private EObject attachToDefaultCybersecurityPkg(EObject cyberObject, CybersecurityPkg pkg) {
        Command cmd = AddCommand.create((EditingDomain)TransactionUtil.getEditingDomain((EObject)pkg), (Object)pkg, null, Collections.singleton(cyberObject));
        if (cmd.canExecute()) {
            cmd.execute();
            return cyberObject;
        }
        return null;
    }

    public Component createActor(EObject any) {
        return CsServices.getService().createActor((CapellaElement)BlockArchitectureExt.getRootBlockArchitecture((EObject)any));
    }

    public ThreatInvolvement createThreatInvolvement(Threat threat, Component actor) {
        ThreatInvolvement iv = CybersecurityFactory.eINSTANCE.createThreatInvolvement();
        iv.setComponent(actor);
        threat.getOwnedThreatInvolvements().add((Object)iv);
        return iv;
    }

    public ThreatApplication createThreatApplication(Threat threat, PrimaryAsset asset) {
        ThreatApplication ap = CybersecurityFactory.eINSTANCE.createThreatApplication();
        ap.setAsset(asset);
        threat.getOwnedThreatApplications().add((Object)ap);
        return ap;
    }

    public ThreatSourceUse createThreatSourceUse(Component threatSource, Component actor) {
        ThreatSourceUse tu = CybersecurityFactory.eINSTANCE.createThreatSourceUse();
        tu.setUsed(actor);
        threatSource.getOwnedExtensions().add((Object)tu);
        return tu;
    }

    public boolean isThreatSource(EObject element) {
        if (element != null) {
            boolean isThreatSource = ((CapellaElement)element).getOwnedExtensions().stream().filter(ext -> ext instanceof TrustBoundaryStorage).findAny().map(trb -> ((TrustBoundaryStorage)trb).isThreatSource()).orElse(false);
            return isThreatSource;
        }
        return false;
    }

    public boolean hasDifferentSourceAndTarget(EObject source, EObject target) {
        return !source.equals(target);
    }

    public String getTrustDecoration(ModelElement element) {
        return TRUSTED_COMPONENT_DECORATION;
    }

    public String getNoTrustDecoration(ModelElement element) {
        return UNTRUSTED_COMPONENT_DECORATION;
    }

    public String getDatastorageDecoration(ModelElement element) {
        return DATASTORAGE_DECORATION;
    }

    public String getRemanentDataDecoration(ModelElement element) {
        return REMANENT_DECORATION;
    }

    public String getThreatSourceDecoration(ModelElement element) {
        return THREATSOURCE_DECORATION;
    }

    public String getPrimaryAssetDecoration(ModelElement element) {
        return PRIMARY_ASSET_DECORATION;
    }

    protected AbstractFunction getRepresentedFunction(ModelElement element) {
        AbstractFunction af = null;
        if (element instanceof AbstractFunction) {
            af = (AbstractFunction)element;
        } else if (element instanceof StateFragment) {
            af = ((StateFragment)element).getRelatedAbstractFunction();
        }
        return af;
    }

    public String getFlameDecoration(EObject object) {
        return FLAME_DECORATION;
    }

    protected FunctionalExchange getRepresentedFunctionalExchange(ModelElement element) {
        AbstractEventOperation invokedOperation;
        FunctionalExchange fe = null;
        if (element instanceof FunctionalExchange) {
            fe = (FunctionalExchange)element;
        } else if (element instanceof SequenceMessage && (invokedOperation = ((SequenceMessage)element).getInvokedOperation()) instanceof FunctionalExchange) {
            fe = (FunctionalExchange)invokedOperation;
        }
        return fe;
    }

    protected ComponentExchange getRepresentedComponentExchange(ModelElement element) {
        AbstractEventOperation invokedOperation;
        ComponentExchange ce = null;
        if (element instanceof ComponentExchange) {
            ce = (ComponentExchange)element;
        } else if (element instanceof SequenceMessage && (invokedOperation = ((SequenceMessage)element).getInvokedOperation()) instanceof ComponentExchange) {
            ce = (ComponentExchange)invokedOperation;
        }
        return ce;
    }

    protected PhysicalLink getRepresentedPhysicalLink(ModelElement element) {
        PhysicalLink pl = null;
        if (element instanceof PhysicalLink) {
            pl = (PhysicalLink)element;
        }
        return pl;
    }

    public boolean hasDatastorageDecoration(ModelElement element) {
        AbstractFunction af = this.getRepresentedFunction(element);
        if (af != null) {
            FunctionStorage storage = this.getFunctionStorage((ExtensibleElement)af);
            return storage != null && storage.isDataStorage();
        }
        return false;
    }

    public boolean hasRemanentDataDecoration(ModelElement element) {
        AbstractFunction af = this.getRepresentedFunction(element);
        if (af != null) {
            FunctionStorage storage = this.getFunctionStorage((ExtensibleElement)af);
            return storage != null && storage.isRemanentData();
        }
        return false;
    }

    protected Component getRepresentedComponent(ModelElement element) {
        AbstractInstance representedInstance;
        Component component = null;
        if (element instanceof Component) {
            component = (Component)element;
        } else if (element instanceof Part) {
            component = (Component)((Part)element).getAbstractType();
        } else if (element instanceof InstanceRole && (representedInstance = ((InstanceRole)element).getRepresentedInstance()) instanceof Part) {
            component = (Component)((Part)representedInstance).getAbstractType();
        }
        return component;
    }

    public boolean hasTrustDecoration(ModelElement element) {
        Component component = this.getRepresentedComponent(element);
        if (component != null) {
            return CybersecurityQueries.isTrusted((Component)component);
        }
        return false;
    }

    public boolean hasNoTrustDecoration(ModelElement element) {
        Component component = this.getRepresentedComponent(element);
        if (component != null) {
            TrustBoundaryStorage storage = CybersecurityQueries.getTrustBoundaryStorage((ExtensibleElement)component);
            return storage != null && !storage.isTrusted() && !storage.isThreatSource();
        }
        return false;
    }

    public boolean hasThreatSourceDecoration(ModelElement element) {
        Component component = this.getRepresentedComponent(element);
        if (component != null) {
            TrustBoundaryStorage storage = CybersecurityQueries.getTrustBoundaryStorage((ExtensibleElement)component);
            return storage != null && storage.isThreatSource();
        }
        return false;
    }

    private FunctionStorage getFunctionStorage(ExtensibleElement element) {
        return ExtensibleElementExt.getExtension(element, FunctionStorage.class);
    }

    private SecurityNeeds getSecurityNeeds(ExtensibleElement element, boolean create) {
        SecurityNeeds sn = ExtensibleElementExt.getExtension(element, SecurityNeeds.class);
        if (sn == null && create) {
            if (!ExtensibleElementExt.canBeExtendedBy((EObject)element, CybersecurityPackage.Literals.SECURITY_NEEDS)) {
                throw new IllegalArgumentException();
            }
            sn = CybersecurityFactory.eINSTANCE.createSecurityNeeds();
            element.getOwnedExtensions().add((Object)sn);
        }
        return sn;
    }

    private SecurityNeeds getSecurityNeeds(ExtensibleElement element) {
        return this.getSecurityNeeds(element, false);
    }

    public Collection<Component> getAllThreatActors(EObject element) {
        BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)element);
        return BlockArchitectureExt.getAllComponents((BlockArchitecture)architecture).stream().filter(c -> c.isActor()).collect(Collectors.toList());
    }

    public List<Component> getAllThreatEntities(EObject element) {
        BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)element);
        return BlockArchitectureExt.getAllComponents((BlockArchitecture)architecture).stream().filter(c -> !c.isActor() && c instanceof Entity).collect(Collectors.toList());
    }

    public Collection<Threat> getAllCurrentLevelThreats(EObject element) {
        return this.getThreats(this.getDefaultCyberSecurityPackage(element, false));
    }

    public Collection<Threat> getThreats(CybersecurityPkg pkg) {
        ArrayList<Threat> threats = new ArrayList<Threat>();
        if (pkg == null) {
            return threats;
        }
        for (CybersecurityPkg subPkg : pkg.getOwnedCybersecurityPkgs()) {
            threats.addAll(this.getThreats(subPkg));
        }
        threats.addAll((Collection<Threat>)pkg.getOwnedThreats());
        return threats;
    }

    public Collection<PrimaryAsset> getAllCurrentLevelFunctionalPrimaryAssets(EObject element) {
        CybersecurityPkg pkg = this.getDefaultCyberSecurityPackage(element, false);
        return this.getPrimaryAssets(pkg).stream().filter(FunctionalPrimaryAsset.class::isInstance).collect(Collectors.toList());
    }

    public Collection<PrimaryAsset> getAllCurrentLevelInformationPrimaryAssets(EObject element) {
        CybersecurityPkg pkg = this.getDefaultCyberSecurityPackage(element, false);
        return this.getPrimaryAssets(pkg).stream().filter(InformationPrimaryAsset.class::isInstance).collect(Collectors.toList());
    }

    public Collection<PrimaryAsset> getAllCurrentLevelEnterprisePrimaryAssets(EObject element) {
        CybersecurityPkg pkg = this.getDefaultCyberSecurityPackage(element, false);
        return this.getPrimaryAssets(pkg).stream().filter(EnterprisePrimaryAsset.class::isInstance).collect(Collectors.toList());
    }

    public Collection<PrimaryAsset> getPrimaryAssets(CybersecurityPkg pkg) {
        ArrayList<PrimaryAsset> primaryAssets = new ArrayList<PrimaryAsset>();
        if (pkg == null) {
            return primaryAssets;
        }
        for (CybersecurityPkg subPkg : pkg.getOwnedCybersecurityPkgs()) {
            primaryAssets.addAll(this.getPrimaryAssets(subPkg));
        }
        primaryAssets.addAll((Collection<PrimaryAsset>)pkg.getOwnedPrimaryAssets());
        return primaryAssets;
    }

    public Collection<PrimaryAsset> getRelatedAssets(EObject element) {
        if (element instanceof Part && ((Part)element).getAbstractType() instanceof Component) {
            Component component = (Component)((Part)element).getAbstractType();
            return this.getRelatedAssetsForComponent(component);
        }
        if (element instanceof Component) {
            Component component = (Component)element;
            return this.getRelatedAssetsForComponent(component);
        }
        if (element instanceof ComponentExchange) {
            ComponentExchange componentExchange = (ComponentExchange)element;
            return this.getRelatedAssetsForComponentExchange(componentExchange);
        }
        if (element instanceof PhysicalLink) {
            PhysicalLink physicalLink = (PhysicalLink)element;
            return this.getRelatedAssetsForPhysicalLink(physicalLink);
        }
        ArrayList<Object> semantics = new ArrayList<Object>();
        BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)element);
        List functionalChains = FunctionalChainExt.getAllFunctionalChains((BlockArchitecture)architecture);
        if (element instanceof SequenceMessage) {
            element = this.getRepresentedFunctionalExchange((ModelElement)element);
        } else if (element instanceof StateFragment) {
            element = this.getRepresentedFunction((ModelElement)element);
        }
        semantics.add(element);
        if (element instanceof FunctionalExchange) {
            semantics.addAll((Collection<Object>)((FunctionalExchange)element).getExchangedItems());
            for (FunctionalChain fc : functionalChains) {
                if (!fc.getInvolvedFunctionalExchanges().contains((Object)element)) continue;
                semantics.add(fc);
            }
        }
        if (element instanceof AbstractFunction) {
            FunctionStorage fs = this.getFunctionStorage((ExtensibleElement)element);
            if (fs != null) {
                semantics.addAll((Collection<Object>)fs.getExchangedItems());
            }
            for (FunctionalChain functionalChain : functionalChains) {
                if (!functionalChain.getInvolvedFunctions().contains((Object)element)) continue;
                semantics.add(functionalChain);
            }
        }
        ArrayList<PrimaryAsset> assets = new ArrayList<PrimaryAsset>();
        for (EObject eObject : semantics) {
            for (EObject member : EObjectExt.getReferencers((EObject)eObject, (EReference)CybersecurityPackage.Literals.PRIMARY_ASSET_MEMBER__MEMBER)) {
                PrimaryAsset asset = ((PrimaryAssetMember)member).getAsset();
                assets.add(asset);
                assets.addAll(EObjectExt.getReferencers((EObject)asset, (EReference)CybersecurityPackage.Literals.PRIMARY_ASSET_MEMBER__MEMBER).stream().map(x -> ((PrimaryAssetMember)x).getAsset()).collect(Collectors.toList()));
            }
        }
        return assets.stream().distinct().collect(Collectors.toList());
    }

    private Collection<PrimaryAsset> getRelatedAssetsForPhysicalLink(PhysicalLink physicalLink) {
        EList allocatedComponentExchanges = physicalLink.getAllocatedComponentExchanges();
        List<PrimaryAsset> relatedAssets = allocatedComponentExchanges.stream().map(exchange -> this.getRelatedAssets((EObject)exchange)).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        return relatedAssets;
    }

    private Collection<PrimaryAsset> getRelatedAssetsForComponentExchange(ComponentExchange componentExchange) {
        EList allocatedFunctionalExchanges = componentExchange.getAllocatedFunctionalExchanges();
        Collection relatedAssets = allocatedFunctionalExchanges.stream().map(exchange -> this.getRelatedAssets((EObject)exchange)).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        return relatedAssets;
    }

    public Collection<Threat> getRelatedThreats(EObject element) {
        Collection<PrimaryAsset> relatedAssets = element instanceof PrimaryAsset ? Arrays.asList((PrimaryAsset)element) : this.getRelatedAssets(element);
        Collection threats = relatedAssets.stream().map(asset -> CybersecurityQueries.getThreatsOf((PrimaryAsset)asset).collect(Collectors.toList())).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        return threats;
    }

    public boolean hasAssetsOrThreatsDisplayed(DSemanticDecorator view) {
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)view);
        if (diagram != null) {
            long nbr = diagram.getOwnedDiagramElements().stream().filter(elem -> elem.getTarget() instanceof PrimaryAsset || elem.getTarget() instanceof Threat).count();
            return nbr > 0L;
        }
        return false;
    }

    public boolean hasAssetStyleCustomization(EObject element) {
        TransactionalEditingDomain domain = TransactionHelper.getEditingDomain((EObject)element);
        BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)element);
        List functionalChains = FunctionalChainExt.getAllFunctionalChains((BlockArchitecture)architecture);
        if (element instanceof ComponentExchange || element instanceof Component) {
            return false;
        }
        if (domain instanceof SemanticEditingDomainFactory.SemanticEditingDomain) {
            if (element instanceof SequenceMessage) {
                element = this.getRepresentedFunctionalExchange((ModelElement)element);
            } else if (element instanceof StateFragment) {
                element = this.getRepresentedFunction((ModelElement)element);
            }
            Collection refs = ((SemanticEditingDomainFactory.SemanticEditingDomain)domain).getCrossReferencer().getInverseReferences(element, CybersecurityPackage.Literals.PRIMARY_ASSET_MEMBER__MEMBER, true);
            if (!refs.isEmpty()) {
                return true;
            }
            if (element instanceof FunctionalExchange) {
                for (FunctionalChain fc : functionalChains) {
                    if (!fc.getInvolvedFunctionalExchanges().contains((Object)element) || !this.hasAssetStyleCustomization((EObject)fc)) continue;
                    return true;
                }
                for (ExchangeItem ei : ((FunctionalExchange)element).getExchangedItems()) {
                    if (!this.hasAssetStyleCustomization((EObject)ei)) continue;
                    return true;
                }
            }
            if (element instanceof AbstractFunction) {
                FunctionStorage fs = this.getFunctionStorage((ExtensibleElement)element);
                if (fs != null) {
                    for (ExchangeItem ei : fs.getExchangedItems()) {
                        if (!this.hasAssetStyleCustomization((EObject)ei)) continue;
                        return true;
                    }
                }
                for (FunctionalChain fc : functionalChains) {
                    if (!fc.getInvolvedFunctions().contains((Object)element) || !this.hasAssetStyleCustomization((EObject)fc)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean hasSupportingAssetStyleCustomization(EObject element, DSemanticDecorator view) {
        if (element instanceof AbstractFunction || element instanceof FunctionalExchange) {
            return false;
        }
        TransactionalEditingDomain domain = TransactionHelper.getEditingDomain((EObject)element);
        if (domain instanceof SemanticEditingDomainFactory.SemanticEditingDomain) {
            DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)view);
            return this.hasDisplayedAssetsOrThreats(diagram, element);
        }
        return false;
    }

    private boolean hasDisplayedAssetsOrThreats(DDiagram diagram, EObject element) {
        Collection<Object> relatedAssets = new ArrayList();
        relatedAssets = this.getRelatedAssets(element);
        List<PrimaryAsset> displayedRelatedAssets = this.getDisplayedAssets(diagram, relatedAssets);
        if (displayedRelatedAssets.size() > 0) {
            return true;
        }
        List<Threat> relatedThreats = relatedAssets.stream().map(asset -> this.getRelatedThreats((EObject)asset)).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        List<Threat> displayedRelatedThreats = this.getDisplayedRelatedThreats(diagram, relatedThreats);
        return displayedRelatedThreats.size() > 0;
    }

    private List<Threat> getDisplayedRelatedThreats(DDiagram diagram, List<Threat> relatedThreats) {
        ArrayList<Threat> displayedRelatedThreats = new ArrayList<Threat>();
        for (Threat threat : relatedThreats) {
            DDiagramElement elem = DiagramServices.getDiagramServices().getDiagramElement(diagram, (EObject)threat);
            if (!(elem instanceof DNode)) continue;
            displayedRelatedThreats.add(threat);
        }
        return displayedRelatedThreats;
    }

    private boolean hasStyleColorBlack(DSemanticDecorator view) {
        if (!(view instanceof DStylizable)) {
            return false;
        }
        Style style = ((DStylizable)view).getStyle();
        RGBValues color = null;
        if (style instanceof BorderedStyle) {
            color = ((BorderedStyle)style).getBorderColor();
        }
        if (style instanceof EdgeStyle) {
            color = ((EdgeStyle)style).getStrokeColor();
        }
        return color != null && color.equals((Object)RGBValues.create((int)0, (int)0, (int)0));
    }

    public boolean removeCustomization(DSemanticDecorator view) {
        EObject target = view.getTarget();
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)view);
        if (diagram != null) {
            EList functionalChains = null;
            if (target instanceof AbstractFunction && this.hasStyleColorBlack(view)) {
                functionalChains = ((AbstractFunction)target).getInvolvingFunctionalChains();
            }
            if (target instanceof FunctionalExchange && this.hasStyleColorBlack(view)) {
                functionalChains = ((FunctionalExchange)target).getInvolvingFunctionalChains();
            }
            if (functionalChains != null && functionalChains.size() > 1) {
                int fcs = 0;
                for (FunctionalChain fc : functionalChains) {
                    DDiagramElement elem = DiagramServices.getDiagramServices().getDiagramElement(diagram, (EObject)fc);
                    if (elem == null) continue;
                    ++fcs;
                }
                if (fcs < 2) {
                    if (target instanceof AbstractFunction) {
                        ShapeUtil.removeCustomisation((Style)ShapeUtil.getCurrentStyle((DDiagramElement)((DDiagramElement)view)), (EStructuralFeature[])new EStructuralFeature[]{DiagramPackage.Literals.BORDERED_STYLE__BORDER_COLOR});
                    }
                    if (target instanceof FunctionalExchange) {
                        ShapeUtil.removeCustomisation((Style)ShapeUtil.getCurrentStyle((DDiagramElement)((DDiagramElement)view)), (EStructuralFeature[])new EStructuralFeature[]{DiagramPackage.Literals.EDGE_STYLE__STROKE_COLOR});
                    }
                }
            }
        }
        return true;
    }

    private List<PrimaryAsset> getDisplayedAssets(DDiagram diagram, Collection<PrimaryAsset> relatedAssets) {
        ArrayList<PrimaryAsset> displayedRelatedAssets = new ArrayList<PrimaryAsset>();
        for (PrimaryAsset asset : relatedAssets) {
            DDiagramElement elem = DiagramServices.getDiagramServices().getDiagramElement(diagram, (EObject)asset);
            if (!(elem instanceof DNode)) continue;
            displayedRelatedAssets.add(asset);
        }
        return displayedRelatedAssets;
    }

    private Collection<PrimaryAsset> getRelatedAssetsForComponent(Component component) {
        List allSubUsedComponents = ComponentExt.getAllSubUsedAndDeployedComponents((Component)component);
        List allocatedFunctions = allSubUsedComponents.stream().map(comp -> comp.getAllocatedFunctions()).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        List<PrimaryAsset> relatedAssets = allocatedFunctions.stream().map(func -> this.getRelatedAssets((EObject)func)).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        return relatedAssets;
    }

    public String getAssetDecorationBorderSize(DSemanticDecorator view) {
        if (view instanceof AbstractDNode) {
            EObject e = view.getTarget();
            DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)view);
            if (diagram != null) {
                DDiagramElement element;
                for (PrimaryAsset asset : this.getRelatedAssets(e)) {
                    element = DiagramServices.getDiagramServices().getDiagramElement(diagram, (EObject)asset);
                    if (!(element instanceof DNode)) continue;
                    return "5";
                }
                for (Threat threat : this.getRelatedThreats(e)) {
                    element = DiagramServices.getDiagramServices().getDiagramElement(diagram, (EObject)threat);
                    if (!(element instanceof DNode)) continue;
                    return "5";
                }
            }
            return "1";
        }
        return null;
    }

    public String getSupportingAssetsDecorationBorderSize(DSemanticDecorator view) {
        if (view instanceof AbstractDNode) {
            EObject e = view.getTarget();
            if (!this.isSupportingAssetHighlightedComponent(view)) {
                return "1";
            }
            DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)view);
            if (diagram != null) {
                DDiagramElement element;
                for (PrimaryAsset asset : this.getRelatedAssets(e)) {
                    element = DiagramServices.getDiagramServices().getDiagramElement(diagram, (EObject)asset);
                    if (!(element instanceof DNode)) continue;
                    return "5";
                }
                for (Threat threat : this.getRelatedThreats(e)) {
                    element = DiagramServices.getDiagramServices().getDiagramElement(diagram, (EObject)threat);
                    if (!(element instanceof DNode)) continue;
                    return "5";
                }
            }
            return "1";
        }
        return null;
    }

    private boolean isSupportingAssetHighlightedComponent(DSemanticDecorator view) {
        EObject element = view.getTarget();
        if (!(element instanceof Part) && !(element instanceof Entity)) {
            return false;
        }
        if (element instanceof Entity) {
            DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)view);
            return this.isSupportingAssetHighlightedComponent(diagram, (Component)((Entity)element));
        }
        if (((Part)element).getAbstractType() instanceof PhysicalComponent) {
            PhysicalComponent comp = (PhysicalComponent)((Part)element).getAbstractType();
            DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)view);
            if (comp.getNature() == PhysicalComponentNature.NODE) {
                return this.isSupportingAssetHighlightedNPCComponent(diagram, comp);
            }
            if (comp.getNature() == PhysicalComponentNature.BEHAVIOR) {
                if (this.hasAllocatedFunctions((Component)comp)) {
                    return true;
                }
                return this.isSupportingAssetHighlightedBPCComponent(diagram, comp);
            }
        } else if (((Part)element).getAbstractType() instanceof Component) {
            Component comp = (Component)((Part)element).getAbstractType();
            DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)view);
            return this.isSupportingAssetHighlightedComponent(diagram, comp);
        }
        return false;
    }

    private boolean hasAllocatedFunctions(Component comp) {
        EList allocatedFunctions = comp.getAllocatedFunctions();
        return allocatedFunctions.size() > 0;
    }

    private boolean isSupportingAssetHighlightedComponent(DDiagram diagram, Component comp) {
        if (this.hasAllocatedFunctions(comp)) {
            return true;
        }
        List componentChildren = ComponentExt.getSubUsedComponents((Component)comp);
        for (Component component : componentChildren) {
            if (!this.isSupportingAssetHighlightedComponent(diagram, component) || this.isDisplayedInDiagram(diagram, component)) continue;
            return true;
        }
        return false;
    }

    private boolean isSupportingAssetHighlightedBPCComponent(DDiagram diagram, PhysicalComponent comp) {
        if (this.hasAllocatedFunctions((Component)comp)) {
            return true;
        }
        List<PhysicalComponent> bpcChildren = this.getBPCChildrenOfComponent(comp);
        if (bpcChildren.size() > 0) {
            for (PhysicalComponent bpcComponent : bpcChildren) {
                if (!this.isSupportingAssetHighlightedBPCComponent(diagram, bpcComponent) || this.isDisplayedInDiagram(diagram, (Component)bpcComponent)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isSupportingAssetHighlightedNPCComponent(DDiagram diagram, PhysicalComponent comp) {
        List relatedAssets;
        if (this.hasDirectBPCWithSupportingAssetCustomization(comp)) {
            return true;
        }
        List<PhysicalComponent> npcChildren = this.getNPCChildrenOfComponent(comp);
        if (npcChildren.size() > 0) {
            EList allocatedFunctions;
            List relatedAssets2;
            for (PhysicalComponent npcComponent : npcChildren) {
                if (!this.isSupportingAssetHighlightedNPCComponent(diagram, npcComponent) || this.isDisplayedInDiagram(diagram, (Component)npcComponent)) continue;
                return true;
            }
            if (comp.isActor() && (relatedAssets2 = (allocatedFunctions = comp.getAllocatedFunctions()).stream().map(func -> this.getRelatedAssets((EObject)func)).flatMap(Collection::stream).distinct().collect(Collectors.toList())).size() > 0) {
                return true;
            }
        }
        return (relatedAssets = comp.getAllocatedFunctions().stream().map(func -> this.getRelatedAssets((EObject)func)).flatMap(Collection::stream).distinct().collect(Collectors.toList())).size() > 0;
    }

    private boolean isDisplayedInDiagram(DDiagram diagram, Component component) {
        List diagramElements = diagram.getRepresentationElements().stream().filter(element -> element instanceof DNodeContainer && element.getSemanticElements().contains((Object)component)).collect(Collectors.toList());
        return !diagramElements.isEmpty();
    }

    private List<PhysicalComponent> getBPCChildrenOfComponent(PhysicalComponent comp) {
        List<PhysicalComponent> children = this.getDirectChildrenOfComponent(comp);
        List<PhysicalComponent> bpcChildren = this.getBPCComponentsFromList(children);
        return bpcChildren;
    }

    private List<PhysicalComponent> getNPCChildrenOfComponent(PhysicalComponent comp) {
        List<PhysicalComponent> children = this.getDirectChildrenOfComponent(comp);
        List<PhysicalComponent> npcChildren = this.getNPCComponentsFromList(children);
        return npcChildren;
    }

    private List<PhysicalComponent> getNPCComponentsFromList(List<PhysicalComponent> components) {
        return components.stream().distinct().filter(c -> c.getNature().equals((Object)PhysicalComponentNature.NODE)).collect(Collectors.toList());
    }

    private List<PhysicalComponent> getBPCComponentsFromList(List<PhysicalComponent> components) {
        return components.stream().distinct().filter(c -> c.getNature().equals((Object)PhysicalComponentNature.BEHAVIOR)).collect(Collectors.toList());
    }

    private boolean hasDirectBPCWithSupportingAssetCustomization(PhysicalComponent comp) {
        List<PhysicalComponent> children = this.getDirectChildrenOfComponent(comp);
        List<PhysicalComponent> bpcChildren = this.getBPCComponentsFromList(children);
        return bpcChildren.size() > 0;
    }

    private List<PhysicalComponent> getDirectChildrenOfComponent(PhysicalComponent comp) {
        Stream stream1 = comp.getSubPhysicalComponents().stream();
        Stream stream2 = comp.getDeployedPhysicalComponents().stream();
        return Stream.concat(stream1, stream2).collect(Collectors.toList());
    }

    private boolean isSupportingAssetHighlightedExchange(EObject element) {
        return !(element instanceof FunctionalExchange);
    }

    public boolean isElementAtOperationalLevel(EObject element) {
        return BlockArchitectureExt.getRootBlockArchitecture((EObject)element) instanceof OperationalAnalysis;
    }

    public boolean isToolAtOperationalLevel(EObject context) {
        return context.eCrossReferences().stream().anyMatch(o -> o instanceof Entity || o instanceof EntityPkg);
    }

    public String getAssetDecorationSize(DSemanticDecorator view) {
        if (view instanceof DEdge) {
            EObject e = view.getTarget();
            DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)view);
            if (diagram != null) {
                DDiagramElement element;
                for (PrimaryAsset asset : this.getRelatedAssets(e)) {
                    element = DiagramServices.getDiagramServices().getDiagramElement(diagram, (EObject)asset);
                    if (element == null || !(element instanceof DNode)) continue;
                    return "5";
                }
                for (Threat threat : this.getRelatedThreats(e)) {
                    element = DiagramServices.getDiagramServices().getDiagramElement(diagram, (EObject)threat);
                    if (element == null || !(element instanceof DNode)) continue;
                    return "5";
                }
            }
            return "1";
        }
        return null;
    }

    public String getSupportingAssetsDecorationSize(DSemanticDecorator view) {
        if (view instanceof DEdge) {
            EObject e = view.getTarget();
            if (!this.isSupportingAssetHighlightedExchange(e)) {
                return "1";
            }
            DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)view);
            if (diagram != null) {
                DDiagramElement element;
                for (PrimaryAsset asset : this.getRelatedAssets(e)) {
                    element = DiagramServices.getDiagramServices().getDiagramElement(diagram, (EObject)asset);
                    if (!(element instanceof DNode)) continue;
                    return "5";
                }
                for (Threat threat : this.getRelatedThreats(e)) {
                    element = DiagramServices.getDiagramServices().getDiagramElement(diagram, (EObject)threat);
                    if (element == null || !(element instanceof DNode)) continue;
                    return "5";
                }
            }
            return "1";
        }
        return null;
    }

    public boolean hasTrustedColor(Part part) {
        return CybersecurityQueries.isTrusted((ExtensibleElement)part);
    }

    public boolean hasTrustedColor(Entity entity) {
        return CybersecurityQueries.isTrusted((Component)entity);
    }

    public boolean hasTrustedColor(InstanceRole element) {
        Component component = this.getRepresentedComponent((ModelElement)element);
        if (component != null) {
            return CybersecurityQueries.isTrusted((Component)component);
        }
        return true;
    }

    public boolean hasFlameDecoration(ModelElement element) {
        ComponentExchange representedComponentExchange = this.getRepresentedComponentExchange(element);
        if (representedComponentExchange != null) {
            return CybersecurityQueries.isTrustBoundary((ComponentExchange)representedComponentExchange);
        }
        FunctionalExchange representedFunctionalExchange = this.getRepresentedFunctionalExchange(element);
        if (representedFunctionalExchange != null) {
            return CybersecurityQueries.isTrustBoundary((FunctionalExchange)representedFunctionalExchange);
        }
        PhysicalLink representedPhysicalLink = this.getRepresentedPhysicalLink(element);
        if (representedPhysicalLink != null) {
            return CybersecurityQueries.isTrustBoundary((PhysicalLink)representedPhysicalLink);
        }
        return false;
    }

    public int getConfidentiality(ModelElement modelElement) {
        SecurityNeeds needs;
        AbstractFunction representedFunction = this.getRepresentedFunction(modelElement);
        if (representedFunction != null) {
            modelElement = representedFunction;
        }
        if ((needs = this.getSecurityNeeds((ExtensibleElement)modelElement)) != null) {
            return CybersecurityQueries.getConfidentialityIndex((SecurityNeeds)needs);
        }
        return 0;
    }

    public int getIntegrity(ModelElement modelElement) {
        SecurityNeeds needs;
        AbstractFunction representedFunction = this.getRepresentedFunction(modelElement);
        if (representedFunction != null) {
            modelElement = representedFunction;
        }
        if ((needs = this.getSecurityNeeds((ExtensibleElement)modelElement)) != null) {
            return CybersecurityQueries.getIntegrityIndex((SecurityNeeds)needs);
        }
        return 0;
    }

    public int getAvailability(ModelElement modelElement) {
        SecurityNeeds needs;
        AbstractFunction representedFunction = this.getRepresentedFunction(modelElement);
        if (representedFunction != null) {
            modelElement = representedFunction;
        }
        if ((needs = this.getSecurityNeeds((ExtensibleElement)modelElement)) != null) {
            return CybersecurityQueries.getAvailabilityIndex((SecurityNeeds)needs);
        }
        return 0;
    }

    public int getTraceability(ModelElement modelElement) {
        SecurityNeeds needs;
        AbstractFunction representedFunction = this.getRepresentedFunction(modelElement);
        if (representedFunction != null) {
            modelElement = representedFunction;
        }
        if ((needs = this.getSecurityNeeds((ExtensibleElement)modelElement)) != null) {
            return CybersecurityQueries.getTraceabilityIndex((SecurityNeeds)needs);
        }
        return 0;
    }

    public int getMaxSecurityNeedValue(DSemanticDecorator decorator) {
        int maxSecurityNeedValue = 0;
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)decorator);
        if (diagram == null) {
            return maxSecurityNeedValue;
        }
        ModelElement element = (ModelElement)decorator.getTarget();
        Set activatedLayerNames = new DDiagramQuery(diagram).getAllActivatedLayers().stream().map(IdentifiedElement::getName).collect(Collectors.toSet());
        if (activatedLayerNames.contains("Cybersecurity Security Needs Confidentiality")) {
            int confidentiality = this.getConfidentiality(element);
            int n = maxSecurityNeedValue = confidentiality > maxSecurityNeedValue ? confidentiality : maxSecurityNeedValue;
        }
        if (activatedLayerNames.contains("Cybersecurity Security Needs Integrity")) {
            int integrity = this.getIntegrity(element);
            int n = maxSecurityNeedValue = integrity > maxSecurityNeedValue ? integrity : maxSecurityNeedValue;
        }
        if (activatedLayerNames.contains("Cybersecurity Security Needs Availability")) {
            int availability = this.getAvailability(element);
            int n = maxSecurityNeedValue = availability > maxSecurityNeedValue ? availability : maxSecurityNeedValue;
        }
        if (activatedLayerNames.contains("Cybersecurity Security Needs Traceability")) {
            int traceability = this.getTraceability(element);
            maxSecurityNeedValue = traceability > maxSecurityNeedValue ? traceability : maxSecurityNeedValue;
        }
        return maxSecurityNeedValue;
    }

    public EObject setNewRandomColor(DNode assetView) {
        ((Ellipse)assetView.getOwnedStyle()).setColor(RGBValues.create((int)this.colorRands.nextInt(), (int)this.colorRands.nextInt(), (int)this.colorRands.nextInt()));
        ((Ellipse)assetView.getOwnedStyle()).getCustomFeatures().add((Object)"color");
        return assetView;
    }

    public IFigure getThreatLevelDecorator(EObject context, DSemanticDiagram diagram) {
        ThreatLevelDecorator decorator = (ThreatLevelDecorator)EcoreUtil.getExistingAdapter((Notifier)context, ThreatLevelDecorator.class);
        if (decorator != null) {
            return decorator.getLabel();
        }
        decorator = new ThreatLevelDecorator((Threat)context);
        context.eAdapters().add((Object)decorator);
        return decorator.getLabel();
    }

    public boolean hasThreatLevelDecorator(ModelElement context) {
        return context instanceof Threat;
    }

    public void setConfidentiality(ExtensibleElement element, EnumerationPropertyLiteral value) {
        SecurityNeeds sn = this.getSecurityNeeds(element, true);
        sn.setConfidentialityValue(value);
    }

    public void setIntegrity(ExtensibleElement element, EnumerationPropertyLiteral value) {
        SecurityNeeds sn = this.getSecurityNeeds(element, true);
        sn.setIntegrityValue(value);
    }

    public void setTraceability(ExtensibleElement element, EnumerationPropertyLiteral value) {
        SecurityNeeds sn = this.getSecurityNeeds(element, true);
        sn.setTraceabilityValue(value);
    }

    public void setAvailability(ExtensibleElement element, EnumerationPropertyLiteral value) {
        SecurityNeeds sn = this.getSecurityNeeds(element, true);
        sn.setAvailabilityValue(value);
    }

    public void setConfidentiality(ExtensibleElement element, int index, EnumerationPropertyType type) {
        SecurityNeeds sn = this.getSecurityNeeds(element, true);
        CybersecurityQueries.setConfidentialityFromIndex((SecurityNeeds)sn, (int)index, (EnumerationPropertyType)type);
    }

    public void setIntegrity(ExtensibleElement element, int index, EnumerationPropertyType type) {
        SecurityNeeds sn = this.getSecurityNeeds(element, true);
        CybersecurityQueries.setIntegrityFromIndex((SecurityNeeds)sn, (int)index, (EnumerationPropertyType)type);
    }

    public void setTraceability(ExtensibleElement element, int index, EnumerationPropertyType type) {
        SecurityNeeds sn = this.getSecurityNeeds(element, true);
        CybersecurityQueries.setTraceabilityFromIndex((SecurityNeeds)sn, (int)index, (EnumerationPropertyType)type);
    }

    public void setAvailability(ExtensibleElement element, int index, EnumerationPropertyType type) {
        SecurityNeeds sn = this.getSecurityNeeds(element, true);
        CybersecurityQueries.setAvailabilityFromIndex((SecurityNeeds)sn, (int)index, (EnumerationPropertyType)type);
    }

    private static class ThreatLevelDecorator
    extends AdapterImpl {
        private static final String FONT = "CybersecurityServices.ThreatLevelDecoratorFont";
        private final Label label;

        private ThreatLevelDecorator(Threat threat) {
            this.label = new Label(this.getLabelText(threat)){

                public void removeNotify() {
                    this.removeDecorator();
                }

                public void addNotify() {
                }
            };
            this.label.setFont(this.getThreatLevelDecoratorFont());
            Rectangle bounds = this.label.getTextBounds();
            this.label.setBounds(bounds);
        }

        private void removeDecorator() {
            Notifier notifier = this.getTarget();
            if (notifier != null) {
                notifier.eAdapters().remove((Object)this);
            }
        }

        private String getLabelText(Threat threat) {
            return "(" + String.valueOf(threat.getLevel()) + ")";
        }

        private Label getLabel() {
            return this.label;
        }

        public boolean isAdapterForType(Object type) {
            return type == ThreatLevelDecorator.class;
        }

        private void updateLabel(Threat t) {
            this.label.setText(this.getLabelText(t));
        }

        public void notifyChanged(Notification msg) {
            if (msg.getFeature() == CybersecurityPackage.Literals.THREAT__LEVEL) {
                this.updateLabel((Threat)msg.getNotifier());
            }
        }

        private Font getThreatLevelDecoratorFont() {
            return JFaceResources.getFontRegistry().defaultFont();
        }
    }
}

