/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.test.queries;

import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.session.Session;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.InformationFactory;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.sirius.ui.helper.SessionHelper;
import org.polarsys.capella.test.framework.api.NonDirtyTestCase;

public abstract class CybersecurityQueriesTest
extends NonDirtyTestCase {
    Session session;
    Project project;
    BlockArchitecture oaArch;
    BlockArchitecture saArch;
    BlockArchitecture laArch;
    BlockArchitecture paArch;
    ExchangeItem eiOA;
    ExchangeItem eiSA;
    ExchangeItem eiLA;

    protected void init() {
        this.session = this.getSession(this.getRequiredTestModels().get(0));
        this.project = SessionHelper.getCapellaProject((Session)this.session);
        this.oaArch = BlockArchitectureExt.getBlockArchitecture((BlockArchitectureExt.Type)BlockArchitectureExt.Type.OA, (Project)this.project);
        this.saArch = BlockArchitectureExt.getBlockArchitecture((BlockArchitectureExt.Type)BlockArchitectureExt.Type.SA, (Project)this.project);
        this.laArch = BlockArchitectureExt.getBlockArchitecture((BlockArchitectureExt.Type)BlockArchitectureExt.Type.LA, (Project)this.project);
        this.paArch = BlockArchitectureExt.getBlockArchitecture((BlockArchitectureExt.Type)BlockArchitectureExt.Type.PA, (Project)this.project);
        this.eiOA = InformationFactory.eINSTANCE.createExchangeItem();
        this.eiSA = InformationFactory.eINSTANCE.createExchangeItem();
        this.eiLA = InformationFactory.eINSTANCE.createExchangeItem();
        AbstractReadWriteCommand cmd = new AbstractReadWriteCommand(){

            public void run() {
                BlockArchitectureExt.getInterfacePkg((BlockArchitecture)CybersecurityQueriesTest.this.oaArch, (boolean)false).getOwnedExchangeItems().add((Object)CybersecurityQueriesTest.this.eiOA);
                BlockArchitectureExt.getInterfacePkg((BlockArchitecture)CybersecurityQueriesTest.this.saArch, (boolean)false).getOwnedExchangeItems().add((Object)CybersecurityQueriesTest.this.eiSA);
                BlockArchitectureExt.getInterfacePkg((BlockArchitecture)CybersecurityQueriesTest.this.laArch, (boolean)false).getOwnedExchangeItems().add((Object)CybersecurityQueriesTest.this.eiLA);
            }
        };
        TransactionHelper.getExecutionManager((EObject)this.project).execute((ICommand)cmd);
    }

    protected abstract void doTest();

    public void test() throws Exception {
        this.init();
        this.doTest();
    }

    public List<String> getRequiredTestModels() {
        return Arrays.asList("CyberEmptyModel");
    }
}

