/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.diffmerge.defer.ui.resources;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.polarsys.capella.diffmerge.defer.ui.resources.IResourceChangeHandler;

public class ResourceDeltaVisitor
implements IResourceDeltaVisitor {
    protected int eventType;
    protected IResourceChangeHandler resourceChangeHandler;

    public ResourceDeltaVisitor(int eventType, IResourceChangeHandler resourceChangeHandler) {
        this.eventType = eventType;
        this.resourceChangeHandler = resourceChangeHandler;
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        switch (delta.getKind()) {
            case 4: {
                return true;
            }
            case 2: {
                if (resource instanceof IFile) {
                    this.resourceChangeHandler.handleFileRemoved(this.eventType, (IFile)resource);
                    break;
                }
                if (!(resource instanceof IContainer)) break;
                return true;
            }
        }
        return false;
    }
}

