/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.filtering.sirius.ui.diagram.actions;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.ui.business.api.provider.AbstractDDiagramElementLabelItemProvider;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDDiagramEditPart;
import org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorUtil;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.polarsys.capella.filtering.sirius.ui.FilteringSiriusUtils;
import org.polarsys.capella.filtering.sirius.ui.diagram.actions.FilteringDiagramAction;
import org.polarsys.capella.filtering.sirius.ui.dialogs.DiagramElementsSelectionDialogWithExtraCheckbox;

public class SelectCriteriaAction
extends FilteringDiagramAction {
    private static final String TITLE = "Diagram Filtering Features selector";
    private static final String MESSAGE = "Selected diagram Filtering Features are selected.";
    private static final String CHECKBOX_MESSAGE = "Common elements";
    List<EObject> objectsToSelect = new ArrayList<EObject>();
    private final Function<Object, Void> selectElements = new Function<Object, Void>(){

        public Void apply(Object from) {
            if (from instanceof DDiagramElement) {
                if (!SelectCriteriaAction.this.objectsToSelect.contains(SelectCriteriaAction.this.objectsToSelect)) {
                    SelectCriteriaAction.this.objectsToSelect.add((EObject)from);
                }
            } else if (from instanceof AbstractDDiagramElementLabelItemProvider && !SelectCriteriaAction.this.objectsToSelect.contains(SelectCriteriaAction.this.objectsToSelect)) {
                SelectCriteriaAction.this.objectsToSelect.add((EObject)from);
            }
            return null;
        }
    };

    public SelectCriteriaAction(IWorkbenchPage workbenchPage) {
        super(workbenchPage);
    }

    protected Request createTargetRequest() {
        return null;
    }

    protected boolean isSelectionListener() {
        return false;
    }

    private Shell getShell() {
        return this.getWorkbenchPart().getSite().getShell();
    }

    protected Command getCommand() {
        UnexecutableCommand result = UnexecutableCommand.INSTANCE;
        Iterable diagramEditParts = Iterables.filter((Iterable)this.getSelectedObjects(), IDDiagramEditPart.class);
        if (Iterables.size((Iterable)diagramEditParts) >= 1) {
            IDDiagramEditPart diagramEditPart = (IDDiagramEditPart)Iterables.get((Iterable)diagramEditParts, (int)0);
            result = this.getElementsSelectionCommand(diagramEditPart);
        }
        return result;
    }

    private Command getElementsSelectionCommand(IDDiagramEditPart diagramEditPart) {
        EObject semanticElement = diagramEditPart.resolveSemanticElement();
        if (semanticElement instanceof DDiagram) {
            DDiagram diagram = (DDiagram)semanticElement;
            return new ICommandProxy((ICommand)new FeaturesSelectionCommand(diagramEditPart.getEditingDomain(), "", diagram));
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected boolean calculateEnabled() {
        boolean canEditInstance = true;
        if (this.getWorkbenchPart() instanceof DDiagramEditor && ((DDiagramEditor)this.getWorkbenchPart()).getRepresentation() instanceof DDiagram) {
            DDiagramEditor editor = (DDiagramEditor)this.getWorkbenchPart();
            DDiagram editorDiagram = (DDiagram)editor.getRepresentation();
            IPermissionAuthority permissionAuthority = PermissionAuthorityRegistry.getDefault().getPermissionAuthority(editor.getSession().getSessionResource().getResourceSet());
            canEditInstance = permissionAuthority.canEditInstance((EObject)editorDiagram);
        }
        boolean result = canEditInstance && super.calculateEnabled();
        return result;
    }

    public EditPart findEditPart(EditPart editPart, EObject theElement) {
        EObject el;
        if (theElement == null) {
            return null;
        }
        View view = (View)editPart.getAdapter(View.class);
        if (view != null && (el = ViewUtil.resolveSemanticElement((View)view)) != null && el.equals(theElement)) {
            return editPart;
        }
        if (editPart instanceof GraphicalEditPart) {
            List sourceConnections = ((GraphicalEditPart)editPart).getSourceConnections();
            for (EditPart connectionEditPart : sourceConnections) {
                EditPart elementEP = this.findEditPart(connectionEditPart, theElement);
                if (elementEP == null) continue;
                return elementEP;
            }
        }
        ListIterator childLI = editPart.getChildren().listIterator();
        while (childLI.hasNext()) {
            EditPart epChild = (EditPart)childLI.next();
            EditPart elementEP = this.findEditPart(epChild, theElement);
            if (elementEP == null) continue;
            return elementEP;
        }
        return null;
    }

    public void setWorkbenchPart(IWorkbenchPart workbenchPart) {
        super.setWorkbenchPart(workbenchPart);
    }

    private final class FeaturesSelectionCommand
    extends AbstractTransactionalCommand {
        private final DDiagram diagram;
        private IEditorSite editorSite;

        private FeaturesSelectionCommand(TransactionalEditingDomain domain, String label, DDiagram diagram) {
            super(domain, label, null);
            this.diagram = diagram;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            IWorkbenchPart activePart = FilteringSiriusUtils.getActivePage().getActivePart();
            if (!(activePart instanceof IEditorPart)) {
                return CommandResult.newErrorCommandResult((String)"This action is available only for diagrams");
            }
            this.editorSite = ((IEditorPart)activePart).getEditorSite();
            DiagramElementsSelectionDialogWithExtraCheckbox dlg = new DiagramElementsSelectionDialogWithExtraCheckbox(SelectCriteriaAction.TITLE, SelectCriteriaAction.MESSAGE, SelectCriteriaAction.CHECKBOX_MESSAGE, false);
            dlg.setSelectionPredicate((Predicate<Object>)Predicates.alwaysFalse());
            dlg.setSelectedAction((Function<Object, Void>)SelectCriteriaAction.this.selectElements);
            dlg.setGrayedPredicate((Predicate<Object>)Predicates.alwaysFalse());
            boolean executed = dlg.open(SelectCriteriaAction.this.getShell(), this.diagram, true);
            if (executed) {
                boolean includeCommon = dlg.getCheckboxSelection();
                ArrayList<EditPart> editPartsToSelect = new ArrayList<EditPart>();
                StructuredSelection diagramSelected = (StructuredSelection)this.editorSite.getSelectionProvider().getSelection();
                IDDiagramEditPart diagramEditPart = (IDDiagramEditPart)diagramSelected.getFirstElement();
                for (EObject o : SelectCriteriaAction.this.objectsToSelect) {
                    EditPart foundEditPart;
                    if (!includeCommon && o instanceof DDiagramElement && FilteringSiriusUtils.getExplicitAssociatedCriteria((DDiagramElement)o).isEmpty() || (foundEditPart = SelectCriteriaAction.this.findEditPart((EditPart)diagramEditPart, o)) == null || editPartsToSelect.contains(foundEditPart)) continue;
                    editPartsToSelect.add(foundEditPart);
                }
                SelectCriteriaAction.this.objectsToSelect.clear();
                SiriusDiagramEditorUtil.selectWithoutRevealElementsInDiagram((IDiagramWorkbenchPart)SelectCriteriaAction.this.getDiagramWorkbenchPart(), editPartsToSelect);
                return CommandResult.newOKCommandResult();
            }
            return CommandResult.newCancelledCommandResult();
        }
    }
}

