/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.filtering.tools.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.model.handler.helpers.CapellaProjectHelper;
import org.polarsys.capella.core.platform.sirius.ui.project.internal.ProjectContentsLocationArea;
import org.polarsys.capella.core.platform.sirius.ui.project.internal.WizardNewProjectCreationPage;
import org.polarsys.capella.core.platform.sirius.ui.project.operations.ProjectSessionCreationHelper;
import org.polarsys.capella.filtering.AbstractFilteringResult;
import org.polarsys.capella.filtering.FilteringCriterion;
import org.polarsys.capella.filtering.FilteringCriterionSet;
import org.polarsys.capella.filtering.FilteringModel;
import org.polarsys.capella.filtering.tools.actions.FilteringProjectContentsLocationArea;
import org.polarsys.capella.filtering.tools.actions.IFilteringProjectWizard;
import org.polarsys.capella.filtering.tools.utils.FilteringUtils;

class FilteringProjectWizard
extends BasicNewResourceWizard
implements IFilteringProjectWizard {
    protected IProject currentProject;
    protected IProject clonedProject;
    protected AbstractFilteringResult filteringResult;
    protected List<FilteringCriterion> selectedFeatures;
    private CheckboxTableViewer viewer;
    private WizardNewProjectCreationPage localProjectDescriptionPage;
    private static final Logger logger = ReportManagerRegistry.getInstance().subscribe("User Interface");

    FilteringProjectWizard(IProject project, AbstractFilteringResult result) {
        this.currentProject = project;
        this.filteringResult = result;
    }

    @Override
    public IProject getResult() {
        return this.clonedProject;
    }

    @Override
    public List<FilteringCriterion> getSelectedFeatures() {
        return this.selectedFeatures;
    }

    public void addPages() {
        this.localProjectDescriptionPage = this.createLocalProjectDescriptionPage();
        this.addPage((IWizardPage)this.localProjectDescriptionPage);
    }

    protected WizardNewProjectCreationPage createLocalProjectDescriptionPage() {
        WizardNewProjectCreationPage mainPage = new WizardNewProjectCreationPage("MelodyProjNewPage"){

            protected ProjectContentsLocationArea handleDefaultProjectLocation(Composite parent) {
                return new FilteringProjectContentsLocationArea(this.getErrorReporter(), parent);
            }

            protected void createProjectApproachGroup(Composite parent) {
                Group featureSelectionGroup = new Group(parent, 0);
                featureSelectionGroup.setLayoutData((Object)new GridData(4, 4, true, true));
                featureSelectionGroup.setLayout((Layout)new GridLayout());
                featureSelectionGroup.setText("Filtering Criteria that are going to be used for derivation");
                FilteringProjectWizard.this.createCheckboxTableViewer(featureSelectionGroup);
            }

            protected boolean validatePage() {
                boolean validationResult = false;
                try {
                    validationResult = super.validatePage();
                }
                catch (Exception e) {
                    validationResult = false;
                }
                return validationResult;
            }
        };
        String newProjectName = this.filteringResult.getName();
        mainPage.setInitialProjectName(newProjectName);
        int i = 2;
        while (FilteringUtils.resourceExists((IResource)mainPage.getProjectHandle())) {
            newProjectName = String.valueOf(this.filteringResult.getName()) + "_" + i;
            mainPage.setInitialProjectName(newProjectName);
            ++i;
        }
        mainPage.setDescription("Derive a new Capella project.");
        mainPage.setTitle("Capella Project");
        return mainPage;
    }

    protected void createCheckboxTableViewer(Group featureSelectionGroup) {
        this.viewer = CheckboxTableViewer.newCheckList((Composite)featureSelectionGroup, (int)2816);
        this.viewer.getTable().setBackground(Display.getCurrent().getSystemColor(22));
        this.viewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.item instanceof TableItem) {
                    TableItem tableItem = (TableItem)e.item;
                    if (e.item.getData() != null && e.item.getData() instanceof FilteringCriterion) {
                        tableItem.setChecked(FilteringUtils.isCriterionInResult(FilteringProjectWizard.this.filteringResult, (FilteringCriterion)e.item.getData()));
                    }
                }
            }
        });
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof EObject) {
                    List<FilteringModel> filteringModels = FilteringUtils.getFilteringModels((EObject)inputElement, true);
                    return FilteringUtils.getOwnedFilteringCriteria(filteringModels).toArray();
                }
                return super.getElements(inputElement);
            }
        });
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof NamedElement) {
                    return FilteringUtils.formatFilteringItemName((NamedElement)element);
                }
                return super.getText(element);
            }
        });
        this.viewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return false;
            }

            public boolean isChecked(Object element) {
                if (FilteringProjectWizard.this.filteringResult == null) {
                    return false;
                }
                FilteringCriterionSet criterionSet = FilteringProjectWizard.this.filteringResult.computeFilteringCriterionSet();
                if (criterionSet != null && criterionSet.getFilteringCriteria() != null) {
                    return criterionSet.getFilteringCriteria().contains(element);
                }
                return false;
            }
        });
        this.viewer.setComparator(new ViewerComparator());
        this.viewer.setInput((Object)this.filteringResult);
        this.viewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
    }

    public boolean performFinish() {
        this.selectedFeatures = new ArrayList<FilteringCriterion>();
        Object[] objectArray = this.viewer.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj instanceof FilteringCriterion) {
                this.selectedFeatures.add((FilteringCriterion)obj);
            }
            ++n2;
        }
        try {
            this.getContainer().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    IPath newPath;
                    IPath defaultPath = Platform.getLocation();
                    if (defaultPath.equals((Object)(newPath = FilteringProjectWizard.this.localProjectDescriptionPage.getLocationPath()))) {
                        newPath = null;
                    }
                    List referencedProjects = Collections.emptyList();
                    ProjectSessionCreationHelper helper = new ProjectSessionCreationHelper(true, true, CapellaProjectHelper.ProjectApproach.SingletonComponents);
                    FilteringProjectWizard.this.clonedProject = helper.createNewEclipseProject(FilteringProjectWizard.this.localProjectDescriptionPage.getProjectName(), newPath, referencedProjects, monitor);
                }
            });
        }
        catch (InterruptedException | InvocationTargetException exception) {
            logger.error((Object)exception);
            return false;
        }
        if (!FilteringUtils.resourceExists((IResource)this.clonedProject)) {
            this.clonedProject = null;
            return false;
        }
        return true;
    }
}

