/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.filtering.properties.sections;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.epbs.ConfigurationItem;
import org.polarsys.capella.core.model.handler.helpers.CapellaAdapterHelper;
import org.polarsys.capella.core.model.handler.helpers.CapellaProjectHelper;
import org.polarsys.capella.core.ui.properties.controllers.IMultipleSemanticFieldController;
import org.polarsys.capella.core.ui.properties.fields.AbstractSemanticField;
import org.polarsys.capella.core.ui.properties.sections.AbstractSection;
import org.polarsys.capella.filtering.FilteringPackage;
import org.polarsys.capella.filtering.properties.CapellaElementCriteria;
import org.polarsys.capella.filtering.properties.CapellaElementImplicitCriteria;
import org.polarsys.capella.filtering.properties.fields.IndirectCapellaElementCriteriaMultipleSemanticField;
import org.polarsys.capella.filtering.properties.fields.ReadOnlyMultipleSemanticField;
import org.polarsys.capella.filtering.properties.sections.Messages;
import org.polarsys.capella.filtering.tools.helpers.ViewpointHelper;

public class CapellaFilteringPropertySection
extends AbstractSection
implements IFilter {
    private IndirectCapellaElementCriteriaMultipleSemanticField criteria;
    private ReadOnlyMultipleSemanticField implicitCriteria;

    public boolean select(Object toTest) {
        EObject eObj = CapellaAdapterHelper.resolveSemanticObject((Object)toTest);
        if (!(eObj instanceof CapellaElement)) {
            return false;
        }
        if (eObj != null && eObj.eClass() != null && FilteringPackage.eINSTANCE.equals(eObj.eClass().getEPackage())) {
            return false;
        }
        return ViewpointHelper.isViewpointActive((EObject)eObj);
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        parent.setLayout((Layout)new GridLayout());
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.criteria = new IndirectCapellaElementCriteriaMultipleSemanticField((Composite)this.getReferencesGroup(), Messages.PropertySection_filteringLabel, this.getWidgetFactory(), (IMultipleSemanticFieldController)new CapellaElementCriteria());
        this.criteria.setDisplayedInWizard(this.isDisplayedInWizard());
        this.implicitCriteria = new ReadOnlyMultipleSemanticField((Composite)this.getReferencesGroup(), Messages.PropertySection_implicitCriteriaLabel, this.getWidgetFactory(), (IMultipleSemanticFieldController)new CapellaElementImplicitCriteria());
        this.implicitCriteria.setEnabled(false);
        this.implicitCriteria.setDisplayedInWizard(this.isDisplayedInWizard());
    }

    public void loadData(EObject capellaElement) {
        super.loadData(capellaElement);
        this.criteria.loadData(capellaElement, null);
        this.implicitCriteria.loadData(capellaElement, null);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        EObject selected;
        if (selection instanceof StructuredSelection && (selected = CapellaAdapterHelper.resolveSemanticObject((Object)((StructuredSelection)selection).getFirstElement())) instanceof CapellaElement) {
            AbstractType type;
            boolean allowMultiplePart;
            if (selected.eClass().equals(CsPackage.eINSTANCE.getPart()) && !(allowMultiplePart = CapellaProjectHelper.TriStateBoolean.True.equals((Object)CapellaProjectHelper.isReusableComponentsDriven((EObject)selected))) && (type = ((Part)selected).getAbstractType()) != null && !(type instanceof ConfigurationItem)) {
                super.setInput(part, (ISelection)new StructuredSelection((Object)type));
                this.loadData((EObject)type);
                return;
            }
            this.loadData(selected);
        }
        super.setInput(part, selection);
    }

    public List<AbstractSemanticField> getSemanticFields() {
        ArrayList<AbstractSemanticField> fields = new ArrayList<AbstractSemanticField>();
        fields.add((AbstractSemanticField)this.criteria);
        fields.add((AbstractSemanticField)this.implicitCriteria);
        return fields;
    }
}

