/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.filtering.tools.dialogs;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.ui.providers.MDEAdapterFactoryLabelProvider;
import org.polarsys.capella.common.ui.toolkit.viewers.data.TreeData;
import org.polarsys.capella.core.model.utils.EObjectExt2;
import org.polarsys.capella.filtering.tools.utils.FilteringUtils;
import org.polarsys.kitalpha.emde.model.ExtensibleElement;

public class FilteringLabelProvider
extends MDEAdapterFactoryLabelProvider
implements IColorProvider {
    private int foregroundColor;
    private TreeViewer viewer;

    public FilteringLabelProvider(TreeViewer viewer, int foregroundColorForReferencingElements) {
        this.foregroundColor = foregroundColorForReferencingElements;
        this.viewer = viewer;
    }

    public Color getBackground(Object element) {
        return null;
    }

    public Color getForeground(Object element) {
        Object input = this.viewer.getInput();
        if (input instanceof TreeData && ((TreeData)input).isValid(element)) {
            Display display = PlatformUI.getWorkbench().getDisplay();
            return display.getSystemColor(this.foregroundColor);
        }
        return null;
    }

    public String getText(Object object) {
        String text = super.getText(object);
        return text.replace("%20", " ");
    }

    public String getColumnText(Object element, int columnIndex) {
        String text = null;
        if (columnIndex == 0) {
            text = this.getText(element);
        } else if (1 == columnIndex && element instanceof ExtensibleElement) {
            text = EObjectExt2.formatValues(FilteringUtils.getExplicitAssociatedCriteria((EObject)element), null, (String)"");
        }
        return text;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        Image image = null;
        if (columnIndex == 0) {
            image = this.getImage(element);
        }
        return image;
    }
}

