/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.filtering.sirius.ui.diagram.actions;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.business.api.helper.graphicalfilters.HideFilterHelper;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.ui.business.api.provider.AbstractDDiagramElementLabelItemProvider;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDDiagramEditPart;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.polarsys.capella.filtering.sirius.ui.Activator;
import org.polarsys.capella.filtering.sirius.ui.FilteringSiriusUtils;
import org.polarsys.capella.filtering.sirius.ui.diagram.actions.FilteringDiagramAction;
import org.polarsys.capella.filtering.sirius.ui.dialogs.DiagramElementsSelectionDialog;

public class SelectHiddenCriteriaAction
extends FilteringDiagramAction {
    private static final String TITLE = "Diagram Filtering Features visibility";
    private static final String MESSAGE = "Visible diagram Filtering Features are checked.";
    private static final String TOOLTIP = "Show/Hide features";
    private static final String ICON_PATH = "icons/showHideCriteria.png";
    private static final ImageDescriptor DESC_HIDE = Activator.getBundledImageDescriptor("icons/showHideCriteria.png");
    private final Predicate<Object> isVisibleAndOptional = new Predicate<Object>(){

        public boolean apply(Object input) {
            Option optionTarget;
            boolean result = false;
            if (input instanceof DDiagramElement) {
                boolean bl = result = !new DDiagramElementQuery((DDiagramElement)input).isHidden();
                if (result) {
                    result = FilteringSiriusUtils.hasAssociatedCriteria((DDiagramElement)input);
                }
            } else if (input instanceof AbstractDDiagramElementLabelItemProvider && (optionTarget = ((AbstractDDiagramElementLabelItemProvider)input).getDiagramElementTarget()).some()) {
                result = !new DDiagramElementQuery((DDiagramElement)optionTarget.get()).isLabelHidden();
            }
            return result;
        }
    };
    private final Function<Object, Void> hideElement = new Function<Object, Void>(){

        public Void apply(Object from) {
            Option optionTarget;
            if (from instanceof DDiagramElement) {
                HideFilterHelper.INSTANCE.hide((DDiagramElement)from);
            } else if (from instanceof AbstractDDiagramElementLabelItemProvider && (optionTarget = ((AbstractDDiagramElementLabelItemProvider)from).getDiagramElementTarget()).some()) {
                HideFilterHelper.INSTANCE.hideLabel((DDiagramElement)optionTarget.get());
            }
            return null;
        }
    };
    private final Function<Object, Void> revealElement = new Function<Object, Void>(){

        public Void apply(Object from) {
            if (from instanceof DDiagramElement) {
                HideFilterHelper.INSTANCE.reveal((DDiagramElement)from);
            } else if (from instanceof AbstractDDiagramElementLabelItemProvider) {
                HideFilterHelper.INSTANCE.revealLabel((DDiagramElement)((AbstractDDiagramElementLabelItemProvider)from).getTarget());
            }
            return null;
        }
    };

    public SelectHiddenCriteriaAction(IWorkbenchPage workbenchPage) {
        super(workbenchPage);
        this.setImageDescriptor(DESC_HIDE);
    }

    public SelectHiddenCriteriaAction(IWorkbenchPage workbenchPage, IDiagramWorkbenchPart part) {
        super(workbenchPage);
        this.setWorkbenchPart((IWorkbenchPart)part);
        this.setImageDescriptor(this.getImage());
    }

    public ImageDescriptor getImage() {
        EObject diagram;
        Diagram gmfDiagram;
        if (this.getWorkbenchPart() instanceof DiagramEditor && (gmfDiagram = ((DiagramEditor)this.getWorkbenchPart()).getDiagram()) != null && (diagram = gmfDiagram.getElement()) instanceof DDiagram && !this.getHiddenAndOptionalElements((DDiagram)diagram).isEmpty()) {
            return DESC_HIDE;
        }
        return DESC_HIDE;
    }

    private List<DDiagramElement> getHiddenAndOptionalElements(DDiagram diagram) {
        ArrayList<DDiagramElement> hiddenAndOptional = new ArrayList<DDiagramElement>();
        for (DDiagramElement element : diagram.getHiddenElements()) {
            if (!FilteringSiriusUtils.hasAssociatedCriteria(element)) continue;
            hiddenAndOptional.add(element);
        }
        return hiddenAndOptional;
    }

    protected Request createTargetRequest() {
        return null;
    }

    protected boolean isSelectionListener() {
        return false;
    }

    protected Command getCommand() {
        UnexecutableCommand result = UnexecutableCommand.INSTANCE;
        Iterable diagramEditParts = Iterables.filter((Iterable)this.getSelectedObjects(), IDDiagramEditPart.class);
        if (Iterables.size((Iterable)diagramEditParts) >= 1) {
            IDDiagramEditPart diagramEditPart = (IDDiagramEditPart)Iterables.get((Iterable)diagramEditParts, (int)0);
            result = this.getElementsSelectionCommand(diagramEditPart);
        }
        return result;
    }

    private Command getElementsSelectionCommand(IDDiagramEditPart diagramEditPart) {
        EObject semanticElement = diagramEditPart.resolveSemanticElement();
        if (semanticElement instanceof DDiagram) {
            DDiagram diagram = (DDiagram)semanticElement;
            return new ICommandProxy((ICommand)new HiddenFeaturesSelectionCommand(diagramEditPart.getEditingDomain(), TOOLTIP, diagram));
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected boolean calculateEnabled() {
        boolean canEditInstance = true;
        if (this.getWorkbenchPart() instanceof DDiagramEditor && ((DDiagramEditor)this.getWorkbenchPart()).getRepresentation() instanceof DDiagram) {
            DDiagramEditor editor = (DDiagramEditor)this.getWorkbenchPart();
            DDiagram editorDiagram = (DDiagram)editor.getRepresentation();
            IPermissionAuthority permissionAuthority = PermissionAuthorityRegistry.getDefault().getPermissionAuthority(editor.getSession().getSessionResource().getResourceSet());
            canEditInstance = permissionAuthority.canEditInstance((EObject)editorDiagram);
        }
        boolean result = canEditInstance && super.calculateEnabled();
        return result;
    }

    public void setWorkbenchPart(IWorkbenchPart workbenchPart) {
        super.setWorkbenchPart(workbenchPart);
    }

    private final class HiddenFeaturesSelectionCommand
    extends AbstractTransactionalCommand {
        private final DDiagram diagram;

        private HiddenFeaturesSelectionCommand(TransactionalEditingDomain domain, String label, DDiagram diagram) {
            super(domain, label, null);
            this.diagram = diagram;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            DiagramElementsSelectionDialog dlg = new DiagramElementsSelectionDialog(SelectHiddenCriteriaAction.TITLE, SelectHiddenCriteriaAction.MESSAGE);
            dlg.setSelectionPredicate((Predicate<Object>)SelectHiddenCriteriaAction.this.isVisibleAndOptional);
            dlg.setSelectedAction((Function<Object, Void>)SelectHiddenCriteriaAction.this.revealElement);
            dlg.setDeselectedAction((Function<Object, Void>)SelectHiddenCriteriaAction.this.hideElement);
            dlg.setGrayedPredicate(this.getNonSelectablePredicate());
            Shell shell = SelectHiddenCriteriaAction.this.getWorkbenchPart().getSite().getShell();
            boolean executed = dlg.open(shell, this.diagram, true);
            if (executed) {
                return CommandResult.newOKCommandResult();
            }
            return CommandResult.newCancelledCommandResult();
        }

        private Predicate<Object> getNonSelectablePredicate() {
            final Predicate<DDiagramElement> allowsHideReveal = FilteringSiriusUtils.allowsHideReveal(this.diagram);
            if (Predicates.alwaysTrue().equals(allowsHideReveal)) {
                return Predicates.alwaysFalse();
            }
            return new Predicate<Object>(){

                public boolean apply(Object input) {
                    if (input instanceof DDiagramElement) {
                        return !allowsHideReveal.apply((Object)((DDiagramElement)input));
                    }
                    return false;
                }
            };
        }
    }
}

