/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.filtering.tools.utils.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.data.capellamodeller.CapellamodellerPackage;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.model.handler.helpers.CapellaProjectHelper;
import org.polarsys.capella.filtering.FilteringCriterion;
import org.polarsys.capella.filtering.FilteringCriterionPkg;
import org.polarsys.capella.filtering.FilteringModel;
import org.polarsys.capella.filtering.tools.utils.FilteringUtils;

public class CriteriaContentProvider
implements ITreeContentProvider {
    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object[] getChildren(Object parentElement) {
        ArrayList<Object> children = new ArrayList<Object>();
        if (parentElement instanceof Collection) {
            children.addAll((Collection)parentElement);
        } else if (parentElement instanceof Project) {
            FilteringModel filteringModel = FilteringUtils.getFilteringModel((EObject)((Project)parentElement));
            if (filteringModel != null) {
                children.addAll(this.doGetElements(filteringModel));
            }
        } else if (parentElement instanceof FilteringCriterionPkg) {
            children.addAll(FilteringUtils.getOwnedFilteringCriteriaAndPkgs((FilteringCriterionPkg)parentElement));
        } else {
            if (parentElement instanceof DSemanticDiagram) {
                return this.getChildren(((DSemanticDiagram)parentElement).getTarget());
            }
            if (parentElement instanceof SystemEngineering) {
                children.addAll(FilteringUtils.getMainAndReferencedVariantProjects((EObject)parentElement));
            } else if (parentElement instanceof EObject) {
                return this.getChildren(EcoreUtil2.getFirstContainer((EObject)((EObject)parentElement), (EClass)CapellamodellerPackage.Literals.SYSTEM_ENGINEERING));
            }
        }
        return children.toArray();
    }

    private List<EObject> doGetElements(FilteringModel filteringModel) {
        return FilteringUtils.getOwnedFilteringCriteriaAndPkgs(Arrays.asList(filteringModel));
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object getParent(Object element) {
        if (element instanceof FilteringCriterion) {
            return CapellaProjectHelper.getProject((EObject)((FilteringCriterion)element));
        }
        return null;
    }

    public boolean hasChildren(Object obj) {
        boolean hasChildren = obj instanceof Project || obj instanceof FilteringCriterionPkg;
        return hasChildren;
    }
}

