/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.filtering.tools.utils.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.model.handler.helpers.CapellaProjectHelper;
import org.polarsys.capella.filtering.AbstractFilteringResult;
import org.polarsys.capella.filtering.ComposedFilteringResult;
import org.polarsys.capella.filtering.FilteringCriterion;
import org.polarsys.capella.filtering.FilteringResultSet;
import org.polarsys.capella.filtering.FilteringResults;
import org.polarsys.capella.filtering.tools.utils.FilteringUtils;

public class FilteringResultsContentProvider
implements ITreeContentProvider {
    private FilteringResults filteringResults;

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object[] getChildren(Object parentElement) {
        ArrayList<Object> children = new ArrayList<Object>();
        if (parentElement instanceof Collection) {
            children.addAll((Collection)parentElement);
        } else if (parentElement instanceof Project) {
            FilteringResults filteringResults = FilteringUtils.getFilteringResults((EObject)((Project)parentElement));
            if (filteringResults != null) {
                children.addAll(this.doGetElements(filteringResults));
            }
        } else if (parentElement instanceof ComposedFilteringResult) {
            children.addAll(FilteringUtils.getComposedResultChildren((ComposedFilteringResult)parentElement));
        } else if (parentElement instanceof FilteringResultSet) {
            children.addAll((Collection<Object>)((FilteringResultSet)parentElement).getFilteringResults());
        } else {
            if (parentElement instanceof DSemanticDiagram) {
                return this.getChildren(((DSemanticDiagram)parentElement).getTarget());
            }
            if (parentElement instanceof SystemEngineering) {
                children.addAll(FilteringUtils.getMainAndReferencedVariantProjects((EObject)parentElement));
            }
        }
        return children.toArray();
    }

    private List<AbstractFilteringResult> doGetElements(FilteringResults filteringResults) {
        return FilteringUtils.getAllFilteringResults(filteringResults);
    }

    public Set<Object> getAllContents() {
        HashSet<Object> contents = new HashSet<Object>();
        if (this.filteringResults != null && this.filteringResults.getFilteringResults() != null) {
            for (Object content : this.filteringResults.getFilteringResults()) {
                contents.add(content);
            }
        }
        return contents;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object getParent(Object element) {
        if (element instanceof FilteringCriterion) {
            return CapellaProjectHelper.getProject((EObject)((FilteringCriterion)element));
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        boolean hasChildren = element instanceof Project || element instanceof ComposedFilteringResult || element instanceof FilteringResultSet;
        return hasChildren;
    }
}

