/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.filtering.migration.contribution;

import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.core.data.migration.context.MigrationContext;
import org.polarsys.capella.core.data.migration.contribution.AbstractMigrationContribution;
import org.polarsys.capella.filtering.tools.helpers.ViewpointHelper;
import org.polarsys.kitalpha.ad.metadata.metadata.Metadata;

public class ActivatedFilterMigrationContribution
extends AbstractMigrationContribution {
    private static final String FILTER_TO_REMOVE_NAME = "VisibleDiagramFilteringCriteria";
    private boolean shouldCleanMetadata = false;

    public void unaryMigrationExecute(EObject currentElement, MigrationContext context) {
        super.unaryMigrationExecute(currentElement, context);
        if (currentElement instanceof DSemanticDiagram && !ViewpointHelper.isViewpointActive((EObject)currentElement)) {
            DSemanticDiagram diagram = (DSemanticDiagram)currentElement;
            this.shouldCleanMetadata = true;
            diagram.getActivatedFilters().removeIf(filter -> FILTER_TO_REMOVE_NAME.equals(filter.getName()));
        }
    }

    public void postMigrationExecute(ExecutionManager executionManager, ResourceSet resourceSet, MigrationContext context) {
        super.postMigrationExecute(executionManager, resourceSet, context);
        if (this.shouldCleanMetadata) {
            this.cleanMetadata(resourceSet);
            this.shouldCleanMetadata = false;
        }
    }

    public void dispose(MigrationContext context) {
        super.dispose(context);
        this.shouldCleanMetadata = false;
    }

    private void cleanMetadata(ResourceSet resourceSet) {
        Metadata metadata = this.getMetadata(resourceSet);
        if (metadata != null) {
            metadata.getViewpointReferences().removeIf(viewpoint -> "org.polarsys.capella.filtering".equals(viewpoint.getVpId()));
        }
    }

    private Metadata getMetadata(ResourceSet resourceSet) {
        EObject root;
        Resource resource;
        Optional<Resource> afmResource = resourceSet.getResources().stream().filter(r -> r.getURI().toString().endsWith("afm")).findFirst();
        if (afmResource.isPresent() && !(resource = afmResource.get()).getContents().isEmpty() && (root = (EObject)resource.getContents().get(0)) instanceof Metadata) {
            return (Metadata)root;
        }
        return null;
    }
}

