/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.transition.system2subsystem.tests.util;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.Arrays;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.polarsys.capella.common.data.activity.InputPin;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.capellacore.Feature;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.transition.system2subsystem.tests.System2SubsystemTestActivator;

public class ModelNormalizer
extends AbstractHandler {
    public static final Predicate<EStructuralFeature> DEFAULT_SORT_PREDICATE = Predicates.not((Predicate)Predicates.in(Arrays.asList(CapellacorePackage.Literals.ABSTRACT_MODELLING_STRUCTURE__OWNED_ARCHITECTURES, InteractionPackage.Literals.SCENARIO__OWNED_MESSAGES)));

    public Object execute(ExecutionEvent event) throws ExecutionException {
        CompoundCommand cc = new CompoundCommand("Normalize Model");
        Resource res = ((EObject)((IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event)).getFirstElement()).eResource();
        EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((Object)res.getResourceSet());
        if (domain == null) {
            Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
            ErrorDialog.openError((Shell)shell, (String)"Cannot Execute Command", (String)"Could not aquire editing domain", (IStatus)new Status(4, System2SubsystemTestActivator.getDefault().getBundle().getSymbolicName(), "Could not find editing domain"));
            return null;
        }
        TreeIterator it = res.getAllContents();
        while (it.hasNext()) {
            EObject next = (EObject)it.next();
            EditingDomain ed = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)next);
            if (next instanceof FunctionalExchange) {
                AbstractFunction sf = (AbstractFunction)((FunctionalExchange)next).getSourceFunctionOutputPort().eContainer();
                AbstractFunction tf = (AbstractFunction)((FunctionalExchange)next).getTargetFunctionInputPort().eContainer();
                cc.append(SetCommand.create((EditingDomain)ed, (Object)next, (Object)ModellingcorePackage.Literals.ABSTRACT_NAMED_ELEMENT__NAME, (Object)(String.valueOf(sf.getName()) + "_" + tf.getName())));
            }
            if (next instanceof AbstractFunction) {
                int index = 1;
                for (InputPin p : ((AbstractFunction)next).getInputs()) {
                    cc.append(SetCommand.create((EditingDomain)ed, (Object)p, (Object)ModellingcorePackage.Literals.ABSTRACT_NAMED_ELEMENT__NAME, (Object)(String.valueOf(((AbstractFunction)next).getName()) + "_" + "FIP" + index++)));
                }
                index = 1;
                for (InputPin p : ((AbstractFunction)next).getOutputs()) {
                    cc.append(SetCommand.create((EditingDomain)ed, (Object)p, (Object)ModellingcorePackage.Literals.ABSTRACT_NAMED_ELEMENT__NAME, (Object)(String.valueOf(((AbstractFunction)next).getName()) + "_" + "FOP" + index++)));
                }
            }
            if (!(next instanceof Component)) continue;
            int index = 1;
            for (Feature f : ((Component)next).getOwnedFeatures()) {
                if (!(f instanceof ComponentPort)) continue;
                cc.append(SetCommand.create((EditingDomain)ed, (Object)f, (Object)ModellingcorePackage.Literals.ABSTRACT_NAMED_ELEMENT__NAME, (Object)(String.valueOf(((Component)next).getName()) + "_C" + index++)));
            }
        }
        domain.getCommandStack().execute((Command)cc);
        return null;
    }
}

