/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.transition.system2subsystem.tests.mixed;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvementLink;
import org.polarsys.capella.core.data.fa.SequenceLink;
import org.polarsys.capella.transition.system2subsystem.tests.System2SubsystemTest;
import org.polarsys.capella.transition.system2subsystem.tests.util.ChainHelper;

public class FakeExchangeChain {
    public static final String FUNCTIONALCHAIN_1 = "bfec6f2e-1b98-4d2e-baae-2b19bb7c86df";
    public static final String FUNCTIONALCHAIN_2 = "4fae1c9d-e0ff-4ad4-8f88-90fa17d6ef93";
    public static final String FUNCTIONALCHAIN_3 = "288283c5-ebe8-43c7-ac56-a8e01032af5e";
    public static final String FUNCTIONALCHAIN_4 = "5fd43e8a-4507-4f9f-9741-97d52219f984";
    public static final String FUNCTIONALCHAIN_5 = "7c366a6a-8a73-43d4-976a-384be6fe40fe";
    public static final String FUNCTIONALCHAIN_6 = "0cf7e508-f578-4f36-b557-aad49d3bc3cb";
    public static final String FUNCTIONALCHAIN_7 = "f2d48136-0afe-449e-bb49-2f646708ab6f";
    public static final String LC_1 = "4e1113c6-2eec-4861-b9c1-1e5da7645fa1";
    public static final String LOGICALFUNCTION_1 = "55a8311e-5670-4260-b8d1-c2264214c7a9";
    public static final String LOGICALFUNCTION_2 = "261bddac-a1d3-4a4c-a412-c2b9fa501c8d";
    public static final String LOGICALFUNCTION_3 = "b7172cd5-dfaa-4ce1-9d62-68b4cc9972c9";
    public static final String LOGICALFUNCTION_4 = "8f5ea4b1-ae0b-481c-9c29-31a13181dd3c";
    public static final String LOGICALFUNCTION_5 = "cc5fd15e-353f-4a3a-b53e-c64a7e89c7ba";
    public static final String LOGICALFUNCTION_6 = "fd3892e7-c2ba-41a9-b11b-63a8e6555317";
    public static final String SEQUENCE_LINK_FC4_1 = "d1a4d963-20bf-4a0f-a519-b2ad4dcfb42e";
    public static final String SEQUENCE_LINK_FC4_2 = "8c9ce71b-0fcd-411e-b181-4ac0899a1c79";

    public static class Always
    extends System2SubsystemTest
    implements System2SubsystemTest.Crossphase {
        @Override
        protected Collection<?> getProjectionElements() {
            return this.getObjects(new String[]{FakeExchangeChain.LC_1});
        }

        @Override
        protected void verify() {
            FunctionalChain chain1 = (FunctionalChain)this.mustBeTransitioned(FakeExchangeChain.FUNCTIONALCHAIN_1);
            FunctionalChain chain2 = (FunctionalChain)this.mustBeTransitioned(FakeExchangeChain.FUNCTIONALCHAIN_2);
            FunctionalChain chain3 = (FunctionalChain)this.mustBeTransitioned(FakeExchangeChain.FUNCTIONALCHAIN_3);
            FunctionalChain chain4 = (FunctionalChain)this.mustBeTransitioned(FakeExchangeChain.FUNCTIONALCHAIN_4);
            FunctionalChain chain5 = (FunctionalChain)this.mustBeTransitioned(FakeExchangeChain.FUNCTIONALCHAIN_5);
            FunctionalChain chain6 = (FunctionalChain)this.mustBeTransitioned(FakeExchangeChain.FUNCTIONALCHAIN_6);
            FunctionalChain chain7 = (FunctionalChain)this.mustBeTransitioned(FakeExchangeChain.FUNCTIONALCHAIN_7);
            AbstractFunction LF1 = (AbstractFunction)this.mustBeTransitioned(FakeExchangeChain.LOGICALFUNCTION_1);
            AbstractFunction LF2 = (AbstractFunction)this.mustBeTransitioned(FakeExchangeChain.LOGICALFUNCTION_2);
            AbstractFunction LF5 = (AbstractFunction)this.mustBeTransitioned(FakeExchangeChain.LOGICALFUNCTION_5);
            Always.assertTrue((ChainHelper.referencingFakeExchanges(chain1).size() == 1 ? 1 : 0) != 0);
            FunctionalChainInvolvementLink link = ChainHelper.referencingFakeExchange(chain1);
            Always.assertTrue((link.getSource().getInvolved() == LF2 ? 1 : 0) != 0);
            Always.assertTrue((link.getTarget().getInvolved() == LF5 ? 1 : 0) != 0);
            Always.assertTrue((ChainHelper.referencingFakeExchanges(chain2).size() == 1 ? 1 : 0) != 0);
            FunctionalChainInvolvementLink link2 = ChainHelper.referencingFakeExchange(chain2);
            Always.assertTrue((link2.getSource().getInvolved() == LF2 ? 1 : 0) != 0);
            Always.assertTrue((link2.getTarget().getInvolved() == LF5 ? 1 : 0) != 0);
            Always.assertTrue((((SequenceLink)this.mustBeTransitioned(FakeExchangeChain.SEQUENCE_LINK_FC4_1)).getTarget() == ((SequenceLink)this.mustBeTransitioned(FakeExchangeChain.SEQUENCE_LINK_FC4_2)).getTarget() ? 1 : 0) != 0);
            Always.assertTrue((ChainHelper.referencingFunctionalChains(chain4, chain5).size() == 1 ? 1 : 0) != 0);
            Always.assertTrue((ChainHelper.referencingFunctionalChains(chain4, chain6).size() == 1 ? 1 : 0) != 0);
            Always.assertTrue((ChainHelper.referencingFunctionalChains(chain4, chain7).size() == 1 ? 1 : 0) != 0);
            List<FunctionalChainInvolvementLink> links = ChainHelper.referencingFakeExchanges(chain4);
            Always.assertTrue((links.size() == 2 ? 1 : 0) != 0);
            Always.assertTrue((links.get(0).getSource().getInvolved() == LF2 ? 1 : 0) != 0);
            Always.assertTrue((links.get(0).getTarget().getInvolved() == LF5 ? 1 : 0) != 0);
            Always.assertTrue((links.get(1).getSource().getInvolved() == LF2 ? 1 : 0) != 0);
            Always.assertTrue((links.get(1).getTarget().getInvolved() == LF5 ? 1 : 0) != 0);
            Always.assertTrue((ChainHelper.fcilReferencingFunctions(chain4, LF2).size() == 1 ? 1 : 0) != 0);
            Always.assertTrue((ChainHelper.fcifReferencingFunctions(chain5, LF2).size() == 2 ? 1 : 0) != 0);
            Always.assertTrue((chain6.getOwnedFunctionalChainInvolvements().size() == 1 ? 1 : 0) != 0);
            Always.assertTrue((ChainHelper.fcifReferencingFunctions(chain6, LF2).size() == 1 ? 1 : 0) != 0);
            Always.assertTrue((chain7.getOwnedFunctionalChainInvolvements().size() == 3 ? 1 : 0) != 0);
        }

        @Override
        public List<String> getRequiredTestModels() {
            return Arrays.asList("FakeExchangeChain", "output");
        }
    }
}

