/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server;

import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public class Document {
    private final Integer version;
    private final String contents;
    private final boolean printSourceOnError;

    public Document(Integer version, String contents) {
        this(version, contents, true);
    }

    public Document(Integer version, String contents, boolean printSourceOnError) {
        this.version = version;
        this.contents = contents;
        this.printSourceOnError = printSourceOnError;
    }

    public int getOffSet(Position position) throws IndexOutOfBoundsException {
        int l = this.contents.length();
        char NL = '\n';
        int line = 0;
        int column = 0;
        for (int i = 0; i < l; ++i) {
            char ch = this.contents.charAt(i);
            if (position.getLine() == line && position.getCharacter() == column) {
                return i;
            }
            if (ch == NL) {
                ++line;
                column = 0;
                continue;
            }
            ++column;
        }
        if (position.getLine() == line && position.getCharacter() == column) {
            return l;
        }
        throw new IndexOutOfBoundsException(position.toString() + this.getSourceOnError());
    }

    public Position getPosition(int offset) throws IndexOutOfBoundsException {
        int l = this.contents.length();
        if (offset < 0 || offset > l) {
            throw new IndexOutOfBoundsException(offset + this.getSourceOnError());
        }
        char NL = '\n';
        int line = 0;
        int column = 0;
        for (int i = 0; i < l; ++i) {
            char ch = this.contents.charAt(i);
            if (i == offset) {
                return new Position(line, column);
            }
            if (ch == NL) {
                ++line;
                column = 0;
                continue;
            }
            ++column;
        }
        return new Position(line, column);
    }

    public String getLineContent(int lineNumber) throws IndexOutOfBoundsException {
        if (lineNumber < 0) {
            throw new IndexOutOfBoundsException(lineNumber + this.getSourceOnError());
        }
        char NL = '\n';
        char LF = '\r';
        int l = this.contents.length();
        StringBuilder lineContent = new StringBuilder();
        int line = 0;
        for (int i = 0; i < l; ++i) {
            if (line > lineNumber) {
                return lineContent.toString();
            }
            char ch = this.contents.charAt(i);
            if (line == lineNumber && ch != NL && ch != LF) {
                lineContent.append(ch);
            }
            if (ch != NL) continue;
            ++line;
        }
        if (line < lineNumber) {
            throw new IndexOutOfBoundsException(lineNumber + this.getSourceOnError());
        }
        return lineContent.toString();
    }

    protected String getSourceOnError() {
        String source = "";
        if (this.isPrintSourceOnError()) {
            source = " text was : " + this.contents;
        }
        return source;
    }

    public int getLineCount() {
        return this.getPosition(this.contents.length()).getLine() + 1;
    }

    public String getSubstring(Range range) {
        int start = this.getOffSet(range.getStart());
        int end = this.getOffSet(range.getEnd());
        return this.contents.substring(start, end);
    }

    public Document applyTextDocumentChanges(Iterable<? extends TextDocumentContentChangeEvent> changes) {
        Document currentDocument = this;
        Integer newVersion = null;
        if (currentDocument.version != null) {
            newVersion = currentDocument.version + 1;
        }
        for (TextDocumentContentChangeEvent textDocumentContentChangeEvent : changes) {
            String newContent;
            if (textDocumentContentChangeEvent.getRange() == null) {
                newContent = textDocumentContentChangeEvent.getText();
            } else {
                int start = currentDocument.getOffSet(textDocumentContentChangeEvent.getRange().getStart());
                int end = currentDocument.getOffSet(textDocumentContentChangeEvent.getRange().getEnd());
                newContent = currentDocument.contents.substring(0, start) + textDocumentContentChangeEvent.getText() + currentDocument.contents.substring(end);
            }
            currentDocument = new Document(newVersion, newContent, this.printSourceOnError);
        }
        return currentDocument;
    }

    public Document applyChanges(Iterable<? extends TextEdit> changes) {
        String newContent = this.contents;
        for (TextEdit textEdit : changes) {
            if (textEdit.getRange() == null) {
                newContent = textEdit.getNewText();
                continue;
            }
            int start = this.getOffSet(textEdit.getRange().getStart());
            int end = this.getOffSet(textEdit.getRange().getEnd());
            newContent = newContent.substring(0, start) + textEdit.getNewText() + newContent.substring(end);
        }
        Integer newVersion = null;
        if (this.version != null) {
            newVersion = this.version + 1;
        }
        return new Document(newVersion, newContent);
    }

    public boolean isPrintSourceOnError() {
        return this.printSourceOnError;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.contents == null ? 0 : this.contents.hashCode());
        result = 31 * result + (this.printSourceOnError ? 1231 : 1237);
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Document other = (Document)obj;
        if (this.contents == null ? other.contents != null : !this.contents.equals(other.contents)) {
            return false;
        }
        if (this.printSourceOnError != other.printSourceOnError) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this);
        b.add("version", (Object)this.version);
        b.add("contents", (Object)this.contents);
        b.add("printSourceOnError", (Object)this.printSourceOnError);
        return b.toString();
    }

    public Integer getVersion() {
        return this.version;
    }

    public String getContents() {
        return this.contents;
    }
}

