/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.scenario.editor.embeddededitor.commands;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.resource.XtextResource;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.core.data.capellacommon.AbstractState;
import org.polarsys.capella.core.data.capellacommon.Mode;
import org.polarsys.capella.core.data.capellacommon.State;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.helpers.interaction.services.ExecutionEndExt;
import org.polarsys.capella.core.data.helpers.interaction.services.SequenceMessageExt;
import org.polarsys.capella.core.data.interaction.AbstractFragment;
import org.polarsys.capella.core.data.interaction.CombinedFragment;
import org.polarsys.capella.core.data.interaction.ExecutionEnd;
import org.polarsys.capella.core.data.interaction.FragmentEnd;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.InteractionFragment;
import org.polarsys.capella.core.data.interaction.InteractionOperand;
import org.polarsys.capella.core.data.interaction.InteractionOperatorKind;
import org.polarsys.capella.core.data.interaction.InteractionState;
import org.polarsys.capella.core.data.interaction.InteractionUse;
import org.polarsys.capella.core.data.interaction.MessageEnd;
import org.polarsys.capella.core.data.interaction.MessageKind;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.TimeLapse;
import org.polarsys.capella.core.data.oa.OperationalActivity;
import org.polarsys.capella.core.model.helpers.AbstractFragmentExt;
import org.polarsys.capella.core.model.helpers.ScenarioExt;
import org.polarsys.capella.core.sirius.analysis.SequenceDiagramServices;
import org.polarsys.capella.scenario.editor.dsl.provider.TextualScenarioProvider;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.Activity;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.Actor;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.ArmTimerMessage;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.Block;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.Component;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.ConfigurationItem;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.CreateMessage;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.Element;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.Entity;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.FoundMessage;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.Function;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.LostFoundMessage;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.LostMessage;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.Message;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.Model;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.Operand;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.Participant;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.ParticipantDeactivation;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.Reference;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.Role;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.SequenceMessage;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.StateFragment;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.TextualScenarioFactory;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.impl.TextualScenarioFactoryImpl;
import org.polarsys.capella.scenario.editor.embeddededitor.commands.HelperCommands;
import org.polarsys.capella.scenario.editor.embeddededitor.views.EmbeddedEditorView;
import org.polarsys.capella.scenario.editor.helper.EmbeddedEditorInstanceHelper;

public class DiagramToXtextCommands {
    public static void process(Scenario scenario, EmbeddedEditorView embeddedEditorViewPart) {
        if (scenario != null && embeddedEditorViewPart != null) {
            TextualScenarioProvider textualScenarioProvider = embeddedEditorViewPart.getProvider();
            if (textualScenarioProvider != null) {
                XtextResource resource = textualScenarioProvider.getResource();
                EList content = resource.getContents();
                TextualScenarioFactoryImpl factory = new TextualScenarioFactoryImpl();
                Model domainModel = HelperCommands.getModel(embeddedEditorViewPart);
                if (domainModel != null) {
                    DiagramToXtextCommands.generateParticipants(domainModel, scenario, (TextualScenarioFactory)factory);
                    DiagramToXtextCommands.generateElements(domainModel, scenario, (TextualScenarioFactory)factory);
                    content.add((Object)domainModel);
                    try {
                        String serialized = ((XtextResource)domainModel.eResource()).getSerializer().serialize((EObject)domainModel);
                        EmbeddedEditorInstanceHelper.updateModel((String)serialized);
                    }
                    catch (Exception e) {
                        HelperCommands.showDialogTextualEditor("Unable to refresh", "Error on refreshing data to Textual Editor!");
                    }
                } else {
                    HelperCommands.showDialogTextualEditor("Unable to refresh", "Error on refreshing data to Textual Editor!");
                }
            }
        } else {
            HelperCommands.showDialogTextualEditor("Unable to refresh", "Error on refreshing data to Textual Editor! Unknown associated scenario!");
        }
    }

    private static void generateParticipants(Model domainModel, Scenario scenario, TextualScenarioFactory factory) {
        EList instanceRoleList = scenario.getOwnedInstanceRoles();
        EList participants = domainModel.getParticipants();
        participants.clear();
        for (InstanceRole instanceRole : instanceRoleList) {
            AbstractType irType = instanceRole.getRepresentedInstance().getAbstractType();
            if (irType != null) {
                DiagramToXtextCommands.createParticipantComponent(irType, instanceRole, (EList<Participant>)participants, factory);
                continue;
            }
            DiagramToXtextCommands.createParticipantFunction(instanceRole, (EList<Participant>)participants, factory);
        }
    }

    private static void createParticipantComponent(AbstractType irType, InstanceRole instanceRole, EList<Participant> participants, TextualScenarioFactory factory) {
        if (irType instanceof org.polarsys.capella.core.data.oa.Entity) {
            if (((org.polarsys.capella.core.data.oa.Entity)irType).isActor()) {
                DiagramToXtextCommands.addActor(instanceRole.getName(), participants, factory);
            } else {
                DiagramToXtextCommands.addEntity(instanceRole.getName(), participants, factory);
            }
        } else if (irType instanceof org.polarsys.capella.core.data.epbs.ConfigurationItem) {
            DiagramToXtextCommands.addConfigItem(instanceRole.getName(), participants, factory);
        } else if (irType instanceof org.polarsys.capella.core.data.cs.Component) {
            if (((org.polarsys.capella.core.data.cs.Component)irType).isActor()) {
                DiagramToXtextCommands.addActor(instanceRole.getName(), participants, factory);
            } else {
                DiagramToXtextCommands.addComponent(instanceRole.getName(), participants, factory);
            }
        }
    }

    private static void createParticipantFunction(InstanceRole instanceRole, EList<Participant> participants, TextualScenarioFactory factory) {
        if (instanceRole.getRepresentedInstance() instanceof OperationalActivity) {
            DiagramToXtextCommands.addActivity(instanceRole.getName(), participants, factory);
        } else if (instanceRole.getRepresentedInstance() instanceof org.polarsys.capella.core.data.oa.Role) {
            DiagramToXtextCommands.addRole(instanceRole.getName(), participants, factory);
        } else if (instanceRole.getRepresentedInstance() instanceof AbstractFunction) {
            DiagramToXtextCommands.addFunction(instanceRole.getName(), participants, factory);
        }
    }

    private static void addActor(String name, EList<Participant> participants, TextualScenarioFactory factory) {
        Actor actor = factory.createActor();
        actor.setName(name);
        actor.setKeyword("actor");
        participants.add((Object)actor);
    }

    private static void addActivity(String name, EList<Participant> participants, TextualScenarioFactory factory) {
        Activity activity = factory.createActivity();
        activity.setName(name);
        activity.setKeyword("activity");
        participants.add((Object)activity);
    }

    private static void addComponent(String name, EList<Participant> participants, TextualScenarioFactory factory) {
        Component component = factory.createComponent();
        component.setName(name);
        component.setKeyword("component");
        participants.add((Object)component);
    }

    private static void addEntity(String name, EList<Participant> participants, TextualScenarioFactory factory) {
        Entity entity = factory.createEntity();
        entity.setName(name);
        entity.setKeyword("entity");
        participants.add((Object)entity);
    }

    private static void addConfigItem(String name, EList<Participant> participants, TextualScenarioFactory factory) {
        ConfigurationItem configItem = factory.createConfigurationItem();
        configItem.setName(name);
        configItem.setKeyword("configuration_item");
        participants.add((Object)configItem);
    }

    private static void addFunction(String name, EList<Participant> participants, TextualScenarioFactory factory) {
        Function function = factory.createFunction();
        function.setName(name);
        function.setKeyword("function");
        participants.add((Object)function);
    }

    private static void addRole(String name, EList<Participant> participants, TextualScenarioFactory factory) {
        Role role = factory.createRole();
        role.setName(name);
        role.setKeyword("role");
        participants.add((Object)role);
    }

    private static void generateElements(Model domainModel, Scenario scenario, TextualScenarioFactory factory) {
        EList elements = domainModel.getElements();
        List fragments = SequenceDiagramServices.getOrderedInteractionFragments((Scenario)scenario);
        Object[] ends = fragments.toArray();
        EList timeLapses = scenario.getOwnedTimeLapses();
        ArrayDeque<Message> messagesToDeactivate = new ArrayDeque<Message>();
        ArrayDeque<org.polarsys.capella.scenario.editor.dsl.textualScenario.CombinedFragment> combinedFragments = new ArrayDeque<org.polarsys.capella.scenario.editor.dsl.textualScenario.CombinedFragment>();
        ArrayDeque<Block> blockOperands = new ArrayDeque<Block>();
        int i = 0;
        while (i < ends.length) {
            if (ends[i] instanceof MessageEnd) {
                if (DiagramToXtextCommands.isTimerReceivingEnd((MessageEnd)ends[i])) {
                    ++i;
                    continue;
                }
                i = DiagramToXtextCommands.generateMessages(ends, i, messagesToDeactivate, combinedFragments, blockOperands, (EList<Element>)elements, factory);
                continue;
            }
            if (ends[i] instanceof ExecutionEnd) {
                DiagramToXtextCommands.generateDeactivatioOnMessages((ExecutionEnd)ends[i], messagesToDeactivate, blockOperands, (EList<Element>)elements, factory);
                ++i;
                continue;
            }
            if (ends[i] instanceof FragmentEnd) {
                AbstractFragment abstractFragment = ((FragmentEnd)ends[i]).getAbstractFragment();
                if (abstractFragment instanceof CombinedFragment) {
                    i = DiagramToXtextCommands.processCombinedFragments(ends, i, combinedFragments, blockOperands, (EList<Element>)elements, scenario, factory);
                    continue;
                }
                if (!(abstractFragment instanceof InteractionUse)) continue;
                if (((FragmentEnd)ends[i]).getName().equals("start")) {
                    DiagramToXtextCommands.generateReference((InteractionUse)abstractFragment, factory, (EList<Element>)elements, blockOperands);
                }
                ++i;
                continue;
            }
            if (ends[i] instanceof InteractionOperand) {
                DiagramToXtextCommands.generateOperandsOnCombinedFragment((InteractionOperand)ends[i], combinedFragments, blockOperands, factory);
                ++i;
                continue;
            }
            if (ends[i] instanceof InteractionState) {
                DiagramToXtextCommands.generateStateFragment((InteractionState)ends[i], (EList<TimeLapse>)timeLapses, blockOperands, (EList<Element>)elements, factory);
                ++i;
                continue;
            }
            ++i;
        }
    }

    private static boolean isTimerReceivingEnd(MessageEnd messageEnd) {
        org.polarsys.capella.core.data.interaction.SequenceMessage currentSequenceMessage = messageEnd.getMessage();
        return currentSequenceMessage != null && currentSequenceMessage.getKind() == MessageKind.TIMER && currentSequenceMessage.getReceivingEnd().equals(messageEnd);
    }

    private static int processCombinedFragments(Object[] ends, int index, Deque<org.polarsys.capella.scenario.editor.dsl.textualScenario.CombinedFragment> combinedFragments, Deque<Block> blockOperands, EList<Element> elements, Scenario scenario, TextualScenarioFactory factory) {
        if (((FragmentEnd)ends[index]).getAbstractFragment() instanceof CombinedFragment) {
            CombinedFragment capellaCombinedFragment = (CombinedFragment)((FragmentEnd)ends[index]).getAbstractFragment();
            List operands = AbstractFragmentExt.getOwnedOperands((CombinedFragment)capellaCombinedFragment, (Scenario)scenario);
            if (ends.length > index + 1 && ends[index + 1] instanceof InteractionOperand && operands.contains(ends[index + 1])) {
                DiagramToXtextCommands.generateCombinedFragments((InteractionOperand)ends[index + 1], capellaCombinedFragment, combinedFragments, blockOperands, elements, factory);
                ++index;
            } else {
                if (!combinedFragments.isEmpty()) {
                    combinedFragments.pop();
                }
                if (!blockOperands.isEmpty()) {
                    blockOperands.pop();
                }
            }
        }
        return ++index;
    }

    private static void generateCombinedFragments(InteractionOperand interactionOperand, CombinedFragment capellaCombinedFragment, Deque<org.polarsys.capella.scenario.editor.dsl.textualScenario.CombinedFragment> combinedFragments, Deque<Block> blockOperands, EList<Element> elements, TextualScenarioFactory factory) {
        org.polarsys.capella.scenario.editor.dsl.textualScenario.CombinedFragment xtextCombinedFragment = DiagramToXtextCommands.createCombinedFragment(factory, interactionOperand, capellaCombinedFragment.getOperator());
        combinedFragments.push(xtextCombinedFragment);
        if (blockOperands.isEmpty()) {
            elements.add((Object)xtextCombinedFragment);
        } else {
            blockOperands.peek().getBlockElements().add((Object)xtextCombinedFragment);
        }
        Block block = DiagramToXtextCommands.createBlock(factory);
        blockOperands.push(block);
        xtextCombinedFragment.setBlock(block);
    }

    private static void generateOperandsOnCombinedFragment(InteractionOperand operand, Deque<org.polarsys.capella.scenario.editor.dsl.textualScenario.CombinedFragment> combinedFragments, Deque<Block> blockOperands, TextualScenarioFactory factory) {
        if (!blockOperands.isEmpty()) {
            blockOperands.pop();
        }
        if (!combinedFragments.isEmpty()) {
            Block block = DiagramToXtextCommands.addOperandBlock(factory, combinedFragments.peek(), operand);
            blockOperands.push(block);
        }
    }

    private static void generateDeactivatioOnMessages(ExecutionEnd executionEnd, Deque<Message> messagesToDeactivate, Deque<Block> blockOperands, EList<Element> elements, TextualScenarioFactory factory) {
        org.polarsys.capella.core.data.interaction.SequenceMessage capellaSequenceMessage = ExecutionEndExt.getMessage((ExecutionEnd)executionEnd);
        ParticipantDeactivation participantDeactivationMsg = DiagramToXtextCommands.createDeactivationMessage(factory, capellaSequenceMessage);
        if (blockOperands.isEmpty()) {
            elements.add((Object)participantDeactivationMsg);
        } else {
            blockOperands.peek().getBlockElements().add((Object)participantDeactivationMsg);
        }
        DiagramToXtextCommands.setWithExecutionOnMessageToDeactivate(messagesToDeactivate);
    }

    private static int generateMessages(Object[] ends, int index, Deque<Message> messagesToDeactivate, Deque<org.polarsys.capella.scenario.editor.dsl.textualScenario.CombinedFragment> combinedFragments, Deque<Block> blockOperands, EList<Element> elements, TextualScenarioFactory factory) {
        org.polarsys.capella.core.data.interaction.SequenceMessage currentSequenceMessage = ((MessageEnd)ends[index]).getMessage();
        if (currentSequenceMessage != null) {
            if (currentSequenceMessage.getKind() == MessageKind.REPLY) {
                EObject participantDeactivateMsg = DiagramToXtextCommands.getParticipantDeactivationMsgFromMessageEnd(ends[index], factory);
                if (blockOperands.isEmpty()) {
                    elements.add((Object)((Element)participantDeactivateMsg));
                } else {
                    blockOperands.peek().getBlockElements().add((Object)((Message)participantDeactivateMsg));
                }
                DiagramToXtextCommands.setWithExecutionOnMessageToDeactivate(messagesToDeactivate);
                index += 2;
            } else {
                EObject message = DiagramToXtextCommands.createMessage(ends[index], factory);
                currentSequenceMessage = ((MessageEnd)ends[index]).getMessage();
                if (message instanceof SequenceMessage && ScenarioExt.hasReply((org.polarsys.capella.core.data.interaction.SequenceMessage)currentSequenceMessage)) {
                    ((SequenceMessage)message).setReturn("withReturn");
                }
                if (blockOperands.isEmpty()) {
                    elements.add((Object)((Element)message));
                } else {
                    blockOperands.peek().getBlockElements().add((Object)((Message)message));
                }
                int step = 0;
                if (message instanceof LostFoundMessage) {
                    ++index;
                    step = 1;
                } else {
                    index += 2;
                    step = 2;
                }
                boolean isSimpleMessage = false;
                if (index < ends.length && ends[index] instanceof ExecutionEnd) {
                    org.polarsys.capella.core.data.interaction.SequenceMessage seqMessFromExecutionEnd;
                    org.polarsys.capella.core.data.interaction.SequenceMessage seqMessFromMessageEnd = ((MessageEnd)ends[index - step]).getMessage();
                    if (seqMessFromMessageEnd.equals(seqMessFromExecutionEnd = ExecutionEndExt.getMessage((ExecutionEnd)((ExecutionEnd)ends[index])))) {
                        ++index;
                        isSimpleMessage = true;
                    } else {
                        DiagramToXtextCommands.addMessageToDeactivate(messagesToDeactivate, message);
                    }
                } else if (index < ends.length && ends[index] instanceof MessageEnd) {
                    org.polarsys.capella.core.data.interaction.SequenceMessage replyMessage;
                    org.polarsys.capella.core.data.interaction.SequenceMessage seqMessFromMessageEnd = ((MessageEnd)ends[index - step]).getMessage();
                    org.polarsys.capella.core.data.interaction.SequenceMessage seqMessFromNextMessageEnd = ((MessageEnd)ends[index]).getMessage();
                    org.polarsys.capella.core.data.interaction.SequenceMessage sequenceMessage = replyMessage = seqMessFromNextMessageEnd != null && seqMessFromNextMessageEnd.getKind() == MessageKind.REPLY ? SequenceMessageExt.getOppositeSequenceMessage((org.polarsys.capella.core.data.interaction.SequenceMessage)seqMessFromMessageEnd) : null;
                    if (replyMessage != null && replyMessage.equals(seqMessFromNextMessageEnd)) {
                        index += 2;
                        isSimpleMessage = true;
                    } else {
                        DiagramToXtextCommands.addMessageToDeactivate(messagesToDeactivate, message);
                    }
                } else {
                    DiagramToXtextCommands.addMessageToDeactivate(messagesToDeactivate, message);
                }
                if (currentSequenceMessage.getKind() == MessageKind.TIMER && index < ends.length && !isSimpleMessage && DiagramToXtextCommands.doSkipNextFragment((InteractionFragment)ends[index], currentSequenceMessage)) {
                    --index;
                }
            }
            return index;
        }
        return index + 1;
    }

    private static boolean doSkipNextFragment(InteractionFragment fragment, org.polarsys.capella.core.data.interaction.SequenceMessage currentSequenceMessage) {
        if (fragment instanceof ExecutionEnd) {
            return !currentSequenceMessage.equals(ExecutionEndExt.getMessage((ExecutionEnd)((ExecutionEnd)fragment)));
        }
        if (fragment instanceof MessageEnd) {
            return !currentSequenceMessage.equals(((MessageEnd)fragment).getMessage());
        }
        return false;
    }

    private static void addMessageToDeactivate(Deque<Message> messagesToDeactivate, EObject message) {
        if (message instanceof SequenceMessage || message instanceof ArmTimerMessage || message instanceof FoundMessage) {
            messagesToDeactivate.push((Message)message);
        }
    }

    private static void setWithExecutionOnMessageToDeactivate(Deque<Message> messagesToDeactivate) {
        if (!messagesToDeactivate.isEmpty()) {
            Message currentSequenceMessage = messagesToDeactivate.pop();
            if (currentSequenceMessage instanceof SequenceMessage) {
                ((SequenceMessage)currentSequenceMessage).setExecution("withExecution");
            } else if (currentSequenceMessage instanceof FoundMessage) {
                ((FoundMessage)currentSequenceMessage).setExecution("withExecution");
            } else if (currentSequenceMessage instanceof ArmTimerMessage) {
                ((ArmTimerMessage)currentSequenceMessage).setExecution("withExecution");
            }
        }
    }

    private static EObject getParticipantDeactivationMsgFromMessageEnd(Object object, TextualScenarioFactory factory) {
        MessageEnd end = (MessageEnd)object;
        org.polarsys.capella.core.data.interaction.SequenceMessage seqMessage = end.getMessage();
        String timeLineToDeactivate = null;
        timeLineToDeactivate = seqMessage.getKind() == MessageKind.REPLY ? ((InstanceRole)seqMessage.getSendingEnd().getCoveredInstanceRoles().get(0)).getName() : ((InstanceRole)seqMessage.getReceivingEnd().getCoveredInstanceRoles().get(0)).getName();
        return DiagramToXtextCommands.createDeactivationMessage(factory, timeLineToDeactivate);
    }

    private static ParticipantDeactivation createDeactivationMessage(TextualScenarioFactory factory, org.polarsys.capella.core.data.interaction.SequenceMessage capellaSequenceMessage) {
        String timelineToDeactivate = ((InstanceRole)capellaSequenceMessage.getReceivingEnd().getCoveredInstanceRoles().get(0)).getName();
        return DiagramToXtextCommands.createDeactivationMessage(factory, timelineToDeactivate);
    }

    private static ParticipantDeactivation createDeactivationMessage(TextualScenarioFactory factory, String timelineToDeactivate) {
        ParticipantDeactivation participantDeactivationMsg = factory.createParticipantDeactivation();
        participantDeactivationMsg.setName(timelineToDeactivate);
        participantDeactivationMsg.setKeyword("deactivate");
        return participantDeactivationMsg;
    }

    private static EObject createMessage(Object object, TextualScenarioFactory factory) {
        CreateMessage xtextSequenceMessage = null;
        MessageEnd end = (MessageEnd)object;
        org.polarsys.capella.core.data.interaction.SequenceMessage capellaSequenceMessage = end.getMessage();
        switch (capellaSequenceMessage.getKind()) {
            case REPLY: {
                break;
            }
            case TIMER: {
                ArmTimerMessage xtextArmTimerMessage = factory.createArmTimerMessage();
                xtextArmTimerMessage.setArrow("->>");
                xtextArmTimerMessage.setName(capellaSequenceMessage.getName());
                xtextArmTimerMessage.setDoubleDot(":");
                if (capellaSequenceMessage.getSendingEnd() != null && !capellaSequenceMessage.getSendingEnd().getCoveredInstanceRoles().isEmpty()) {
                    xtextArmTimerMessage.setParticipant(((InstanceRole)capellaSequenceMessage.getSendingEnd().getCoveredInstanceRoles().get(0)).getName());
                }
                return xtextArmTimerMessage;
            }
            case CREATE: {
                xtextSequenceMessage = factory.createCreateMessage();
                xtextSequenceMessage.setArrow("->+");
                break;
            }
            case DELETE: {
                xtextSequenceMessage = factory.createDeleteMessage();
                xtextSequenceMessage.setArrow("->x");
                break;
            }
            default: {
                if (capellaSequenceMessage.getSendingEnd() != null && capellaSequenceMessage.getReceivingEnd() == null) {
                    LostMessage xtextLostMessage = factory.createLostMessage();
                    xtextLostMessage.setArrow("->o");
                    xtextLostMessage.setDoubleDot(":");
                    xtextLostMessage.setName(capellaSequenceMessage.getName());
                    if (!capellaSequenceMessage.getSendingEnd().getCoveredInstanceRoles().isEmpty()) {
                        xtextLostMessage.setSource(((InstanceRole)capellaSequenceMessage.getSendingEnd().getCoveredInstanceRoles().get(0)).getName());
                    }
                    return xtextLostMessage;
                }
                if (capellaSequenceMessage.getSendingEnd() == null && capellaSequenceMessage.getReceivingEnd() != null) {
                    FoundMessage xtextFoundMessage = factory.createFoundMessage();
                    xtextFoundMessage.setArrow("o->");
                    xtextFoundMessage.setDoubleDot(":");
                    xtextFoundMessage.setName(capellaSequenceMessage.getName());
                    if (!capellaSequenceMessage.getReceivingEnd().getCoveredInstanceRoles().isEmpty()) {
                        xtextFoundMessage.setTarget(((InstanceRole)capellaSequenceMessage.getReceivingEnd().getCoveredInstanceRoles().get(0)).getName());
                    }
                    return xtextFoundMessage;
                }
                xtextSequenceMessage = factory.createSequenceMessage();
                xtextSequenceMessage.setArrow("->");
            }
        }
        if (xtextSequenceMessage != null) {
            xtextSequenceMessage.setName(capellaSequenceMessage.getName());
            if (capellaSequenceMessage.getSendingEnd() != null && !capellaSequenceMessage.getSendingEnd().getCoveredInstanceRoles().isEmpty()) {
                xtextSequenceMessage.setSource(((InstanceRole)capellaSequenceMessage.getSendingEnd().getCoveredInstanceRoles().get(0)).getName());
            }
            if (capellaSequenceMessage.getReceivingEnd() != null && !capellaSequenceMessage.getReceivingEnd().getCoveredInstanceRoles().isEmpty()) {
                xtextSequenceMessage.setTarget(((InstanceRole)capellaSequenceMessage.getReceivingEnd().getCoveredInstanceRoles().get(0)).getName());
            }
            xtextSequenceMessage.setDoubleDot(":");
        }
        return xtextSequenceMessage;
    }

    private static org.polarsys.capella.scenario.editor.dsl.textualScenario.CombinedFragment createCombinedFragment(TextualScenarioFactory factory, InteractionOperand operand, InteractionOperatorKind operatorKind) {
        org.polarsys.capella.scenario.editor.dsl.textualScenario.CombinedFragment xtextCombinedFragment = factory.createCombinedFragment();
        xtextCombinedFragment.setKeyword(operatorKind.toString().toLowerCase());
        xtextCombinedFragment.setOver("over");
        EList coveredInstanceRoles = operand.getCoveredInstanceRoles();
        for (InstanceRole ir : coveredInstanceRoles) {
            xtextCombinedFragment.getTimelines().add((Object)ir.getName());
        }
        xtextCombinedFragment.setExpression(HelperCommands.getExpressionText(operand));
        return xtextCombinedFragment;
    }

    private static Block addOperandBlock(TextualScenarioFactory factory, org.polarsys.capella.scenario.editor.dsl.textualScenario.CombinedFragment xtextCombinedFragment, InteractionOperand operand) {
        Operand operandBlock = factory.createOperand();
        operandBlock.setExpression(HelperCommands.getExpressionText(operand));
        if (xtextCombinedFragment.getKeyword().equals("alt")) {
            operandBlock.setKeyword("else");
        }
        xtextCombinedFragment.getOperands().add((Object)operandBlock);
        Block block = DiagramToXtextCommands.createBlock(factory);
        operandBlock.setBlock(block);
        return block;
    }

    private static Block createBlock(TextualScenarioFactory factory) {
        Block block = factory.createBlock();
        block.setBegin("{");
        block.setEnd("}");
        return block;
    }

    private static void generateStateFragment(InteractionState interactionState, EList<TimeLapse> timeLapses, Deque<Block> blockOperands, EList<Element> elements, TextualScenarioFactory factory) {
        for (EObject timeLapse : timeLapses) {
            if (!(timeLapse instanceof org.polarsys.capella.core.data.interaction.StateFragment) || interactionState == null || !interactionState.equals(((org.polarsys.capella.core.data.interaction.StateFragment)timeLapse).getStart())) continue;
            String timelineName = interactionState.getCovered().getName();
            StateFragment xtextStateFragment = DiagramToXtextCommands.createStateFragment(factory, timeLapse, timelineName);
            if (blockOperands.isEmpty()) {
                elements.add((Object)xtextStateFragment);
                continue;
            }
            blockOperands.peek().getBlockElements().add((Object)xtextStateFragment);
        }
    }

    private static StateFragment createStateFragment(TextualScenarioFactory factory, Object fragment, String timelineName) {
        StateFragment xtextStateFragment = factory.createStateFragment();
        AbstractState stateMode = ((org.polarsys.capella.core.data.interaction.StateFragment)fragment).getRelatedAbstractState();
        if (stateMode != null) {
            if (stateMode instanceof Mode) {
                xtextStateFragment.setKeyword("mode");
            } else if (stateMode instanceof State) {
                xtextStateFragment.setKeyword("state");
            }
            xtextStateFragment.setName(stateMode.getName());
        } else {
            AbstractFunction function = ((org.polarsys.capella.core.data.interaction.StateFragment)fragment).getRelatedAbstractFunction();
            if (function != null) {
                xtextStateFragment.setKeyword("function");
                xtextStateFragment.setName(function.getName());
            }
        }
        xtextStateFragment.setOn("on");
        xtextStateFragment.setTimeline(timelineName);
        return xtextStateFragment;
    }

    private static void generateReference(InteractionUse abstractFragment, TextualScenarioFactory factory, EList<Element> elements, Deque<Block> blockOperands) {
        EList coveredInstanceRoles = abstractFragment.getStart().getCoveredInstanceRoles();
        List<String> timelines = coveredInstanceRoles.stream().map(x -> x.getName()).collect(Collectors.toList());
        String name = abstractFragment.getReferencedScenario().getName();
        Reference xtextReference = DiagramToXtextCommands.createXtextReference(name, timelines, factory);
        if (blockOperands.isEmpty()) {
            elements.add((Object)xtextReference);
        } else {
            blockOperands.peek().getBlockElements().add((Object)xtextReference);
        }
    }

    private static Reference createXtextReference(String name, List<String> timelinesNames, TextualScenarioFactory factory) {
        Reference xtextReference = factory.createReference();
        xtextReference.setKeyword("ref");
        xtextReference.setOver("over");
        xtextReference.getTimelines().addAll(timelinesNames);
        xtextReference.setName(name);
        return xtextReference;
    }
}

