/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.docgen.task;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.ftask.producer.context.ITaskProductionContext;
import org.eclipse.egf.ftask.producer.invocation.ITaskProduction;
import org.polarsys.kitalpha.doc.gen.business.core.branding.DocumentationBrandingData;
import org.polarsys.kitalpha.doc.gen.business.core.preference.helper.DocgenBrandingPreferencesHelper;

public class UpdateCapellaDocGenBrandingData
implements ITaskProduction {
    private static final String COPYRIGHT_CONTRACT = "copyright";
    private static final String LOGO_PATH_CONTRACT = "logo.path";
    private static final String LOGO_ALT_CONTRACT = "logo.alt";
    private static final String LOGO_PATH_CAPELLA_DEFAULT_VALUE = "platform:/plugin/org.polarsys.capella.docgen.ui/icons/intro-capella.png";
    private static final String LOGO_ALT_CAPELLA_DEFAULT_VALUE = "[Capella Logo]";

    public void doExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
        String copyright = (String)productionContext.getInputValue((Object)COPYRIGHT_CONTRACT, String.class);
        String logo_path = (String)productionContext.getInputValue((Object)LOGO_PATH_CONTRACT, String.class);
        String logo_alt = (String)productionContext.getInputValue((Object)LOGO_ALT_CONTRACT, String.class);
        DocumentationBrandingData.getInstance().removeAllData();
        if (copyright != null) {
            productionContext.setOutputValue((Object)COPYRIGHT_CONTRACT, (Object)copyright);
        }
        if (this.doChangeCapellaLogoPath(logo_path)) {
            productionContext.setOutputValue((Object)LOGO_PATH_CONTRACT, (Object)LOGO_PATH_CAPELLA_DEFAULT_VALUE);
        } else {
            productionContext.setOutputValue((Object)LOGO_PATH_CONTRACT, (Object)logo_path);
        }
        if (this.doChangeCapellaLogoAlt(logo_alt)) {
            productionContext.setOutputValue((Object)LOGO_ALT_CONTRACT, (Object)LOGO_ALT_CAPELLA_DEFAULT_VALUE);
        } else {
            productionContext.setOutputValue((Object)LOGO_ALT_CONTRACT, (Object)logo_alt);
        }
    }

    private boolean doChangeCapellaLogoPath(String currentLogoPath) {
        String defaultLogoPath = "Default";
        String preferenceLogoPath = DocgenBrandingPreferencesHelper.getLogoPath();
        if (currentLogoPath != null) {
            return currentLogoPath.equals(defaultLogoPath) && preferenceLogoPath.equals(defaultLogoPath);
        }
        return preferenceLogoPath.equals(defaultLogoPath);
    }

    private boolean doChangeCapellaLogoAlt(String currentLogoAlt) {
        String defaultLogoAlt = "[Default logo]";
        String preferenceLogoAlt = DocgenBrandingPreferencesHelper.getLogoAlternateText();
        if (currentLogoAlt != null) {
            return currentLogoAlt.equals(defaultLogoAlt) && preferenceLogoAlt.equals(defaultLogoAlt);
        }
        return preferenceLogoAlt.equals(defaultLogoAlt);
    }

    public void preExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
    }

    public void postExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
    }
}

