/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.doc.gen.business.core.visitor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternException;
import org.eclipse.egf.model.pattern.PatternParameter;
import org.eclipse.egf.pattern.l10n.EGFPatternMessages;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.osgi.util.NLS;
import org.polarsys.kitalpha.doc.gen.business.core.Activator;
import org.polarsys.kitalpha.doc.gen.business.core.helper.IConceptsHelper;
import org.polarsys.kitalpha.doc.gen.business.core.messages.Messages;
import org.polarsys.kitalpha.doc.gen.business.core.scope.SubClassEmfModelVisitorWithScoping;
import org.polarsys.kitalpha.doc.gen.business.core.services.ExtensionService;
import org.polarsys.kitalpha.doc.gen.business.core.services.IndexItem;
import org.polarsys.kitalpha.doc.gen.business.core.services.IndexerService;
import org.polarsys.kitalpha.doc.gen.business.core.util.DefaultFileNameService;
import org.polarsys.kitalpha.doc.gen.business.core.util.IFileNameService;

public class DocgenCommonSubClassEmfModelVisitor
extends SubClassEmfModelVisitorWithScoping {
    private List<Pattern> originePatterns;
    protected IFileNameService fileNameService = DefaultFileNameService.INSTANCE;

    public void setPatterns(List<Pattern> patterns) throws PatternException {
        for (Pattern p : patterns) {
            EList parameters = p.getAllParameters();
            if (parameters.size() != 1) {
                throw new PatternException(NLS.bind((String)EGFPatternMessages.strategy_error4, (Object)p.getName()));
            }
            this.registerPattern(p, (PatternParameter)parameters.get(0));
        }
        this.originePatterns = patterns;
    }

    private void registerPattern(Pattern p, PatternParameter patternParameter) {
        String type = patternParameter.getType();
        ArrayList<Pattern> patterns = (ArrayList<Pattern>)this.type2patterns.get(type);
        if (patterns == null) {
            patterns = new ArrayList<Pattern>();
            this.type2patterns.put(type, patterns);
        }
        patterns.add(p);
    }

    protected List<Pattern> findPatterns(Object model) {
        if (model instanceof EObject) {
            this.indexElement(model);
            ArrayList list = new ArrayList();
            List eAllSuperTypes = this.getSuperTypes(model);
            eAllSuperTypes.add(EcorePackage.eINSTANCE.getEObject());
            for (EClass superType : eAllSuperTypes) {
                String fullName = EcoreUtil.getURI((EObject)superType).toString();
                String instanceTypeName = superType.getInstanceTypeName();
                List patterns = (List)this.type2patterns.get(fullName);
                List instanceTypePatterns = (List)this.type2patterns.get(instanceTypeName);
                if (patterns != null) {
                    list.addAll(patterns);
                }
                if (instanceTypePatterns == null) continue;
                list.addAll(instanceTypePatterns);
            }
            ArrayList<Pattern> result = new ArrayList<Pattern>();
            for (Pattern pattern : this.originePatterns) {
                if (!list.contains(pattern)) continue;
                result.add(pattern);
            }
            return result;
        }
        return Collections.emptyList();
    }

    private void indexElement(Object model) {
        List<IConceptsHelper> conceptsHelperList = ExtensionService.INSTANCE.getConceptsHelpersList();
        if (conceptsHelperList != null && !conceptsHelperList.isEmpty()) {
            for (IConceptsHelper iConceptsHelper : conceptsHelperList) {
                if (!iConceptsHelper.accept(model)) continue;
                String fileName = this.fileNameService.getFileName((EObject)model);
                String conceptLabel = iConceptsHelper.getConceptLabel(model);
                if (conceptLabel == null) {
                    Activator.logWarning(NLS.bind((String)Messages.warning_ConceptNameReplacedWithNull, (Object)model));
                    conceptLabel = "null";
                }
                IndexItem item = new IndexItem(conceptLabel, model.getClass().getName(), null, null, fileName);
                IndexerService.INSTANCE.getElementsToIndexItems().put(fileName, item);
                break;
            }
        }
    }
}

