/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.doc.gen.business.core.services;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.polarsys.kitalpha.doc.gen.business.core.services.IndexItem;

public class IndexerService {
    public static final IndexerService INSTANCE = new IndexerService();
    private Map<String, IndexItem> elementToIndexItems = new HashMap<String, IndexItem>();

    private IndexerService() {
    }

    public List<String> getElements() {
        return this.getSortedElements();
    }

    public Map<String, IndexItem> getElementsToIndexItems() {
        return this.elementToIndexItems;
    }

    public IndexItem getElement(String concept) {
        if (this.getElementsToIndexItems().containsKey(concept)) {
            return this.getElementsToIndexItems().get(concept);
        }
        return null;
    }

    public List<String> getSortedElements() {
        List<String> elementsToIndex = this.getElementsToIndexItems().values().parallelStream().map(v -> v.getConceptName()).collect(Collectors.toList());
        Collections.sort(elementsToIndex, new IndexerComparator());
        return elementsToIndex;
    }

    public boolean checkConceptExistence(String concept) {
        return this.getElementsToIndexItems().containsKey(concept);
    }

    private class IndexerComparator
    implements Comparator<String> {
        private IndexerComparator() {
        }

        @Override
        public int compare(String arg0, String arg1) {
            return arg0.compareTo(arg1);
        }
    }
}

