/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.doc.gen.business.core.scope;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.polarsys.kitalpha.doc.gen.business.core.messages.Messages;
import org.polarsys.kitalpha.doc.gen.business.core.scope.ScopeCompute;
import org.polarsys.kitalpha.doc.gen.business.core.scope.ScopeElementStrategy;
import org.polarsys.kitalpha.doc.gen.business.core.scope.ScopeException;
import org.polarsys.kitalpha.doc.gen.business.core.scope.ScopeReferencesStrategy;
import org.polarsys.kitalpha.doc.gen.business.core.scope.ScopeStatus;

public class GenerationGlobalScope {
    private static GenerationGlobalScope instance;
    private Resource scopedResource = null;
    private boolean doComputeScopedResource = true;
    private List<EObject> generationScope = new ArrayList<EObject>();
    private ScopeStatus scopeStatus = ScopeStatus.NOT_LIMITED;
    private ScopeElementStrategy elementStrategy = ScopeElementStrategy.ALL;
    private ScopeReferencesStrategy referencesStrategy = ScopeReferencesStrategy.EXPORT;
    private EcoreUtil.Copier copier = null;
    private TransactionalEditingDomain domain = null;

    public static GenerationGlobalScope getInstance() {
        if (instance == null) {
            instance = new GenerationGlobalScope();
        }
        return instance;
    }

    public void cleanScope() {
        this.generationScope.clear();
        this.scopeStatus = ScopeStatus.NOT_LIMITED;
        this.elementStrategy = ScopeElementStrategy.ALL;
        if (this.copier != null) {
            this.copier.clear();
            this.copier = null;
        }
        if (this.referencesStrategy.equals((Object)ScopeReferencesStrategy.DONT_EXPORT)) {
            if (this.domain != null && this.scopedResource != null) {
                this.domain.getCommandStack().execute((Command)new RecordingCommand(this.domain){

                    protected void doExecute() {
                        GenerationGlobalScope.this.scopedResource.unload();
                    }
                });
                this.cleanCopiedData();
                this.domain = null;
                this.scopedResource = null;
                this.doComputeScopedResource = true;
            }
            this.referencesStrategy = ScopeReferencesStrategy.EXPORT;
        }
    }

    public final void cleanCopiedData() {
        ResourceSet resourceSet;
        if (this.domain != null && (resourceSet = this.domain.getResourceSet()) != null && this.scopedResource != null) {
            resourceSet.getResources().remove((Object)this.scopedResource);
        }
    }

    public ScopeStatus getScopeStatus() {
        return this.scopeStatus;
    }

    public ScopeReferencesStrategy getReferencesStrategy() {
        return this.referencesStrategy;
    }

    public void setReferencesStrategy(ScopeReferencesStrategy referencesStrategy) {
        this.referencesStrategy = referencesStrategy;
    }

    public final EObject getOriginalModelElement(EObject modelElement) {
        if (this.copier != null && this.referencesStrategy.equals((Object)ScopeReferencesStrategy.DONT_EXPORT)) {
            if (this.copier.containsKey((Object)modelElement)) {
                return modelElement;
            }
            if (this.copier.containsValue((Object)modelElement)) {
                for (Map.Entry entry : this.copier.entrySet()) {
                    EObject value = (EObject)entry.getValue();
                    if (value == null || !value.equals(modelElement)) continue;
                    return (EObject)entry.getKey();
                }
            }
        }
        return modelElement;
    }

    public final boolean isCopyInScope(EObject modelElement) {
        if (this.scopeStatus.equals((Object)ScopeStatus.NOT_LIMITED)) {
            return true;
        }
        if (this.copier != null) {
            EObject copyElement = (EObject)this.copier.get((Object)modelElement);
            return this.inScope(copyElement, true);
        }
        return this.inScope(modelElement, true);
    }

    public final Resource getScopedResource() throws ScopeException {
        if (this.referencesStrategy.equals((Object)ScopeReferencesStrategy.EXPORT)) {
            throw new ScopeException(Messages.Scope_No_Resource_For_Export_References_Strategy);
        }
        if (this.scopedResource == null || this.doComputeScopedResource) {
            this.scopedResource = this.computeScopedResource();
        }
        return this.scopedResource;
    }

    protected final Resource computeScopedResource() {
        if (this.referencesStrategy.equals((Object)ScopeReferencesStrategy.DONT_EXPORT)) {
            EObject copyModelRootElement = (EObject)this.scopedResource.getContents().get(0);
            EList<EObject> objectOutOfScope = this.getObjectOutOfScope(copyModelRootElement);
            for (final EObject eObject : objectOutOfScope) {
                this.domain.getCommandStack().execute((Command)new RecordingCommand(this.domain){

                    protected void doExecute() {
                        EcoreUtil.delete((EObject)eObject, (boolean)true);
                    }
                });
            }
            this.doComputeScopedResource = false;
        }
        return this.scopedResource;
    }

    protected final Resource copyResource(final EObject anySourceModelElement) {
        this.domain = TransactionUtil.getEditingDomain((EObject)anySourceModelElement);
        if (this.domain != null) {
            URI resourceURI = anySourceModelElement.eResource().getURI();
            URI copiedResourceURI = URI.createHierarchicalURI((String)"memory", (String)resourceURI.authority(), (String)resourceURI.device(), (String[])resourceURI.segments(), (String)resourceURI.query(), (String)resourceURI.fragment());
            final Resource resource = this.domain.createResource(copiedResourceURI.toString());
            this.domain.getResourceSet().getResources().add((Object)resource);
            this.copier = new EcoreUtil.Copier();
            this.domain.getCommandStack().execute((Command)new RecordingCommand(this.domain){

                protected void doExecute() {
                    resource.getContents().clear();
                    EObject rootContainer = EcoreUtil.getRootContainer((EObject)anySourceModelElement);
                    EObject copyModelRootElement = GenerationGlobalScope.this.copier.copy(rootContainer);
                    GenerationGlobalScope.this.copier.copyReferences();
                    resource.getContents().add((Object)copyModelRootElement);
                }
            });
            return resource;
        }
        this.copier = new EcoreUtil.Copier();
        ResourceImpl resource = new ResourceImpl();
        EObject rootContainer = EcoreUtil.getRootContainer((EObject)anySourceModelElement);
        EObject copyModelRootElement = this.copier.copy(rootContainer);
        this.copier.copyReferences();
        resource.getContents().add((Object)copyModelRootElement);
        return resource;
    }

    protected final EList<EObject> getObjectOutOfScope(EObject modelRootElement) {
        BasicEList result = new BasicEList();
        TreeIterator eAllContents = modelRootElement.eAllContents();
        while (eAllContents.hasNext()) {
            EObject eObject = (EObject)eAllContents.next();
            if (GenerationGlobalScope.getInstance().inScope(eObject, true)) continue;
            result.add((Object)eObject);
        }
        return result;
    }

    public final void addToScope(EObject modelElement) throws ScopeException {
        List<EObject> scope;
        if (this.referencesStrategy.equals((Object)ScopeReferencesStrategy.DONT_EXPORT)) {
            if (this.scopedResource == null) {
                this.scopedResource = this.copyResource((EObject)modelElement);
            }
            modelElement = modelElement instanceof DRepresentationDescriptor ? ((DRepresentationDescriptor)modelElement).getRepresentation() : (EObject)this.copier.get(modelElement);
        }
        if (!(scope = ScopeCompute.computeScope(modelElement, this.elementStrategy)).isEmpty()) {
            this.addToGenerationScope(scope);
        }
        this.scopeStatus = ScopeStatus.LIMITED;
    }

    private void addToGenerationScope(List<EObject> scope) {
        if (scope != null) {
            if (this.generationScope.isEmpty()) {
                this.generationScope = scope;
            } else {
                for (EObject eObject : scope) {
                    if (this.inScope(eObject, true)) continue;
                    this.generationScope.add(eObject);
                }
            }
        }
    }

    public boolean inScope(EObject eObject, boolean forceEqualCheck) {
        if (this.scopeStatus.equals((Object)ScopeStatus.NOT_LIMITED)) {
            return true;
        }
        if (!this.generationScope.isEmpty()) {
            boolean exists = this.generationScope.contains(eObject);
            if (exists) {
                return true;
            }
            if (forceEqualCheck) {
                for (EObject iEObject : this.generationScope) {
                    boolean equals = EcoreUtil.equals((EObject)eObject, (EObject)iEObject);
                    if (!equals) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

