/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.docgen.util;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.cs.ExchangeItemAllocation;
import org.polarsys.capella.core.data.information.AbstractEventOperation;
import org.polarsys.capella.core.data.interaction.Execution;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.InteractionState;
import org.polarsys.capella.core.data.interaction.InteractionUse;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.data.interaction.StateFragment;
import org.polarsys.capella.docgen.util.CapellaServices;
import org.polarsys.capella.docgen.util.StringUtil;
import org.polarsys.kitalpha.doc.gen.business.core.util.IDiagramHelper;

public class CapellaDiagramHelper
implements IDiagramHelper {
    public boolean select(EObject eObject) {
        AbstractEventOperation eventOperation;
        if (eObject instanceof NamedElement) {
            return CapellaServices.isLinkableWithoutScope(eObject) >= 0;
        }
        if (eObject instanceof SequenceMessage && (eventOperation = ((SequenceMessage)eObject).getInvokedOperation()) != null) {
            return CapellaServices.isLinkableWithoutScope((EObject)eventOperation) >= 0;
        }
        return false;
    }

    public EObject getSemanticElement(DDiagramElement element) {
        EObject target = element.getTarget();
        if (target instanceof SequenceMessage) {
            return ((SequenceMessage)target).getInvokedOperation();
        }
        if (target instanceof InstanceRole) {
            return ((InstanceRole)target).getRepresentedInstance();
        }
        if (target instanceof InteractionState) {
            if (((InteractionState)target).getRelatedAbstractFunction() != null) {
                return ((InteractionState)target).getRelatedAbstractFunction();
            }
            return ((InteractionState)target).getRelatedAbstractState();
        }
        if (target instanceof InteractionUse) {
            return ((InteractionUse)target).getReferencedScenario();
        }
        if (target instanceof Execution) {
            return null;
        }
        if (target instanceof StateFragment) {
            return ((StateFragment)target).getRelatedAbstractFunction();
        }
        return target;
    }

    public boolean isContainer(DDiagramElement element) {
        EObject semantic = element.getTarget();
        return !(semantic instanceof Execution) && !(semantic instanceof InstanceRole);
    }

    public String getElementId(EObject eObject) {
        EObject element = eObject;
        if (eObject instanceof ExchangeItemAllocation) {
            element = ((ExchangeItemAllocation)eObject).getAllocatedItem();
        }
        if (element != null) {
            return CapellaServices.getAnchorId(element);
        }
        return "";
    }

    public String diagramDocumentationPostTraitement(EObject eObject, String documentation, String projectName, String outputFolder) {
        return StringUtil.transformAREFString(eObject, documentation, projectName, outputFolder);
    }
}

