/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.doc.gen.business.core.task;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.ftask.producer.context.ITaskProductionContext;
import org.eclipse.egf.ftask.producer.invocation.ITaskProduction;
import org.polarsys.kitalpha.doc.gen.business.core.services.IndexItem;
import org.polarsys.kitalpha.doc.gen.business.core.services.IndexerService;

public class CollectConceptsTask
implements ITaskProduction {
    public void preExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
    }

    public void doExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
        List<String> concepts = IndexerService.INSTANCE.getSortedElements();
        Map<String, IndexItem> indexItems = IndexerService.INSTANCE.getElementsToIndexItems();
        LinkedList<Map.Entry<String, IndexItem>> entryList = new LinkedList<Map.Entry<String, IndexItem>>(indexItems.entrySet());
        Collections.sort(entryList, new Comparator<Map.Entry<String, IndexItem>>(){

            @Override
            public int compare(Map.Entry<String, IndexItem> a, Map.Entry<String, IndexItem> b) {
                return a.getValue().compareTo(b.getValue());
            }
        });
        LinkedHashMap<String, IndexItem> sortedMap = new LinkedHashMap<String, IndexItem>();
        for (Map.Entry entry : entryList) {
            sortedMap.put((String)entry.getKey(), (IndexItem)entry.getValue());
        }
        productionContext.setOutputValue((Object)"concepts", concepts);
        productionContext.setOutputValue((Object)"indexItems", sortedMap);
    }

    public void postExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
    }
}

