/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.internal.fcore;

import org.eclipse.core.internal.registry.Handle;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.egf.core.fcore.IPlatformFcore;
import org.eclipse.egf.core.internal.fcore.PlatformFcore;
import org.eclipse.egf.core.platform.pde.IPlatformBundle;
import org.eclipse.egf.core.platform.pde.IPlatformExtensionPointFactory;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;

public final class PlatformFcoreFactory
implements IPlatformExtensionPointFactory<IPlatformFcore> {
    public IPlatformFcore createExtensionPoint(IPlatformBundle platformBundle, Object object) {
        if (object instanceof IPluginElement) {
            return this.create(platformBundle, (IPluginElement)object);
        }
        if (object instanceof IConfigurationElement) {
            return this.create(platformBundle, (IConfigurationElement)object);
        }
        throw new UnsupportedOperationException();
    }

    private IPlatformFcore create(IPlatformBundle platformBundle, IPluginElement element) {
        if (element == null) {
            return null;
        }
        if (!"fcore".equals(element.getName())) {
            return null;
        }
        IPluginAttribute id = element.getAttribute("id");
        if (id == null || id.getValue() == null || id.getValue().trim().length() == 0) {
            return null;
        }
        return new PlatformFcore(platformBundle, id.getValue());
    }

    private IPlatformFcore create(IPlatformBundle platformBundle, IConfigurationElement element) {
        if (element == null) {
            return null;
        }
        IExtension declaringExtension = element.getDeclaringExtension();
        String uniqueIdentifier = declaringExtension.getUniqueIdentifier();
        int handleId = -1;
        if (declaringExtension instanceof Handle) {
            handleId = ((Handle)declaringExtension).getId();
        }
        if (!"fcore".equals(element.getName())) {
            return null;
        }
        String id = element.getAttribute("id");
        if (id == null || id.trim().length() == 0) {
            return null;
        }
        return new PlatformFcore(platformBundle, id, uniqueIdentifier, handleId);
    }
}

