/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.producer.internal.context;

import java.util.Collection;
import org.eclipse.egf.common.helper.ClassHelper;
import org.eclipse.egf.common.helper.EMFHelper;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.core.producer.context.IProductionContext;
import org.eclipse.egf.core.producer.context.ProductionContext;
import org.eclipse.egf.core.producer.l10n.CoreProducerMessages;
import org.eclipse.egf.core.session.ProjectBundleSession;
import org.eclipse.egf.model.fcore.Contract;
import org.eclipse.egf.model.fcore.Invocation;
import org.eclipse.egf.model.fcore.InvocationContract;
import org.eclipse.egf.model.fcore.Orchestration;
import org.eclipse.egf.model.fcore.OrchestrationParameter;
import org.eclipse.egf.producer.context.IInvocationProductionContext;
import org.eclipse.egf.producer.internal.context.ModelElementProductionContext;
import org.eclipse.osgi.util.NLS;

public abstract class InvocationProductionContext<P extends Invocation, T extends Orchestration>
extends ModelElementProductionContext<P, InvocationContract>
implements IInvocationProductionContext<P, T> {
    public InvocationProductionContext(ProjectBundleSession projectBundleSession, P element, String name) {
        super(projectBundleSession, element, name);
    }

    public InvocationProductionContext(IProductionContext<T, OrchestrationParameter> parent, ProjectBundleSession projectBundleSession, P element, String name) {
        super(parent, projectBundleSession, element, name);
    }

    public boolean isSetAtRuntime(Object key) throws InvocationException {
        InvocationContract invocationContract = InvocationProductionContext.getInvocationContract(key, this.getInputValueKeys(), this.getName(), "Input");
        if (invocationContract == null) {
            return false;
        }
        if (invocationContract.getSourceInvocationContract() != null) {
            return true;
        }
        if ((invocationContract.getOrchestrationParameter() != null || invocationContract.getFactoryComponentContract() != null) && this.getParent() != null) {
            return this.getParent().isSetAtRuntime((Object)invocationContract);
        }
        return false;
    }

    public Class<?> getInputValueType(Object key) throws InvocationException {
        ProductionContext.Data inputData;
        InvocationContract invocationContract = InvocationProductionContext.getInvocationContract(key, this.getInputValueKeys(), this.getName(), "Input");
        if (invocationContract == null) {
            return null;
        }
        Class valueType = null;
        if ((invocationContract.getOrchestrationParameter() != null || invocationContract.getFactoryComponentContract() != null) && this.getParent() != null) {
            valueType = this.getParent().getInputValueType((Object)invocationContract);
        }
        if (valueType == null && (inputData = (ProductionContext.Data)this._inputDatas.get(invocationContract)) != null) {
            valueType = inputData.getType();
        }
        return valueType;
    }

    public <R> R getInputValue(Object key, Class<R> clazz) throws InvocationException {
        ProductionContext.Data inputData;
        InvocationContract invocationContract = InvocationProductionContext.getInvocationContract(key, this.getInputValueKeys(), this.getName(), "Input");
        if (invocationContract == null) {
            return null;
        }
        Object value = null;
        if ((invocationContract.getOrchestrationParameter() != null || invocationContract.getFactoryComponentContract() != null) && this.getParent() != null) {
            value = this.getParent().getInputValue((Object)invocationContract, clazz);
        }
        if (value == null && (inputData = (ProductionContext.Data)this._inputDatas.get(invocationContract)) != null) {
            value = this.getValue(invocationContract, clazz, inputData, "Input");
        }
        return (R)value;
    }

    public Class<?> getOutputValueType(Object key) throws InvocationException {
        ProductionContext.Data outputData;
        InvocationContract invocationContract = InvocationProductionContext.getInvocationContract(key, this.getOutputValueKeys(), this.getName(), "Output");
        if (invocationContract == null) {
            return null;
        }
        Class valueType = null;
        if ((invocationContract.getOrchestrationParameter() != null || invocationContract.getFactoryComponentContract() != null) && this.getParent() != null) {
            valueType = this.getParent().getOutputValueType((Object)invocationContract);
        }
        if (valueType == null && (outputData = (ProductionContext.Data)this._outputDatas.get(invocationContract)) != null) {
            valueType = outputData.getType();
        }
        return valueType;
    }

    public <R> R getOutputValue(Object key, Class<R> clazz) throws InvocationException {
        ProductionContext.Data outputData;
        InvocationContract invocationContract = InvocationProductionContext.getInvocationContract(key, this.getOutputValueKeys(), this.getName(), "Output");
        if (invocationContract == null) {
            return null;
        }
        Object value = null;
        if ((invocationContract.getOrchestrationParameter() != null || invocationContract.getFactoryComponentContract() != null) && this.getParent() != null) {
            value = this.getParent().getOutputValue((Object)invocationContract, clazz);
        }
        if (value == null && (outputData = (ProductionContext.Data)this._outputDatas.get(invocationContract)) != null) {
            value = this.getValue(invocationContract, clazz, outputData, "Output");
        }
        return (R)value;
    }

    public void setOutputValue(Object key, Object value) throws InvocationException {
        ProductionContext.Data outputData;
        InvocationContract invocationContract = InvocationProductionContext.getInvocationContract(key, this.getOutputValueKeys(), this.getName(), "Output");
        if (invocationContract == null) {
            return;
        }
        if ((invocationContract.getOrchestrationParameter() != null || invocationContract.getFactoryComponentContract() != null) && this.getParent() != null) {
            this.getParent().setOutputValue((Object)invocationContract, value);
        }
        if ((outputData = (ProductionContext.Data)this._outputDatas.get(invocationContract)) == null) {
            return;
        }
        if (!(value == null || ClassHelper.isSubClass(value.getClass(), (Class)outputData.getType()) && outputData.getType().isInstance(value))) {
            throw new InvocationException(NLS.bind((String)CoreProducerMessages.ProductionContext_wrong_type, (Object[])new Object[]{outputData.getType().getName(), "Output", EMFHelper.getText((Object)key), value.getClass().getName(), this.getName()}));
        }
        outputData.setValue(value);
        ProductionContext.Data inputData = (ProductionContext.Data)this._inputDatas.get(key);
        if (inputData != null) {
            inputData.setValue(value);
        }
    }

    private static InvocationContract getInvocationContract(Object key, Collection<InvocationContract> keys, String name, String mode) throws InvocationException {
        if (key == null) {
            throw new InvocationException(NLS.bind((String)CoreProducerMessages.ProductionContext_null_key, (Object)mode, (Object)name));
        }
        if (!(key instanceof Contract)) {
            throw new InvocationException(NLS.bind((String)CoreProducerMessages.ProductionContext_wrong_type, (Object[])new Object[]{Contract.class.getName(), mode, EMFHelper.getText((Object)key), key.getClass().getName(), name}));
        }
        InvocationContract invocationContract = null;
        for (InvocationContract innerInvocationContract : keys) {
            if (key != innerInvocationContract.getInvokedContract()) continue;
            invocationContract = innerInvocationContract;
            break;
        }
        return invocationContract;
    }
}

