/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.docgen.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.capellacore.TypedElement;
import org.polarsys.capella.core.data.information.Class;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.ExchangeItemElement;
import org.polarsys.capella.core.data.information.InformationRealization;
import org.polarsys.capella.core.data.information.Operation;
import org.polarsys.capella.core.data.information.Parameter;
import org.polarsys.capella.core.data.information.Property;
import org.polarsys.capella.core.data.information.Union;
import org.polarsys.capella.core.data.information.datavalue.DataValue;
import org.polarsys.capella.docgen.util.CapellaDataValueServices;
import org.polarsys.capella.docgen.util.CapellaPropertyServices;
import org.polarsys.capella.docgen.util.CapellaServices;

public class CapellaClassServices {
    private CapellaClassServices() {
    }

    public static List<String> getClassFeatures(EObject eObject) {
        ArrayList<String> ret = new ArrayList<String>();
        if (eObject instanceof Class) {
            Class eClass = (Class)eObject;
            ret.add("<b>Is Abstract\t:\t</b>" + eClass.isAbstract());
            ret.add("<b>Is Primitive\t:\t</b>" + eClass.isIsPrimitive());
        }
        return ret;
    }

    public static List<String> getClassProperties(EObject eObject, String projectName, String outputFolder) {
        ArrayList<String> ret = new ArrayList<String>();
        ret.addAll(CapellaClassServices.getClassProperties(eObject, projectName, outputFolder, false));
        ret.addAll(CapellaClassServices.getClassProperties(eObject, projectName, outputFolder, true));
        return ret;
    }

    public static List<String> getClassProperties(EObject eObject, String projectName, String outputFolder, boolean associations) {
        List<String> ret = new ArrayList<String>();
        if (!(eObject instanceof Class)) {
            return ret;
        }
        EList<Property> properties = !associations ? CapellaClassServices.getClassProperties((Class)eObject) : CapellaClassServices.getClassAssociations((Class)eObject);
        ret = CapellaClassServices.getInformationFromProperties(properties, projectName, outputFolder);
        return ret;
    }

    private static List<String> getInformationFromProperties(EList<Property> properties, String projectName, String outputFolder) {
        ArrayList<String> ret = new ArrayList<String>();
        Property minProperty = null;
        Property maxProperty = null;
        if (properties != null) {
            for (Property prop : properties) {
                if (prop.getName().equals("min")) {
                    minProperty = prop;
                    continue;
                }
                if (prop.getName().equals("max")) {
                    maxProperty = prop;
                    continue;
                }
                String info = CapellaPropertyServices.getInformationFromProperty(prop, projectName, outputFolder);
                ret.add(info);
            }
        }
        if (maxProperty != null) {
            ret.add(0, CapellaPropertyServices.getInformationFromProperty(maxProperty, projectName, outputFolder));
        }
        if (minProperty != null) {
            ret.add(0, CapellaPropertyServices.getInformationFromProperty(minProperty, projectName, outputFolder));
        }
        return ret;
    }

    private static EList<Property> getClassProperties(Class clazz) {
        BasicEList properties = null;
        properties = clazz instanceof Union ? new BasicEList((Collection)((Union)clazz).getContainedUnionProperties().stream().filter(CapellaPropertyServices.isAssociationPropertyPredicate.negate()).collect(Collectors.toList())) : new BasicEList((Collection)clazz.getContainedProperties().stream().filter(CapellaPropertyServices.isAssociationPropertyPredicate.negate()).collect(Collectors.toList()));
        if (properties.isEmpty()) {
            return new BasicEList();
        }
        return properties;
    }

    private static EList<Property> getClassAssociations(Class clazz) {
        BasicEList properties = null;
        properties = clazz instanceof Union ? new BasicEList((Collection)((Union)clazz).getContainedUnionProperties().stream().filter(CapellaPropertyServices.isAssociationPropertyPredicate).collect(Collectors.toList())) : new BasicEList((Collection)clazz.getContainedProperties().stream().filter(CapellaPropertyServices.isAssociationPropertyPredicate).collect(Collectors.toList()));
        if (properties.isEmpty()) {
            return null;
        }
        return properties;
    }

    public static List<String> getClassDataValues(EObject eObject, String projectName, String outputFolder) {
        ArrayList<String> ret = new ArrayList<String>();
        if (eObject instanceof Class) {
            EList dataValueList = ((Class)eObject).getOwnedDataValues();
            for (DataValue dataValue : dataValueList) {
                ret.add(CapellaDataValueServices.getDataValueInformation(dataValue, projectName, outputFolder));
            }
        }
        return ret;
    }

    public static List<String> getClassRealizeInformation(EObject eObject) {
        ArrayList<String> ret = new ArrayList<String>();
        if (eObject instanceof Class) {
            EList listReal = ((Class)eObject).getOwnedInformationRealizations();
            for (InformationRealization realization : listReal) {
                if (realization.getTargetElement() == null) continue;
                ret.add(CapellaServices.getHyperlinkFromElement((EObject)realization.getTargetElement()));
            }
        }
        return ret;
    }

    public static List<String> getClassOperation(EObject eObject) {
        ArrayList<String> ret = new ArrayList<String>();
        if (eObject instanceof Class) {
            for (Operation ope : ((Class)eObject).getContainedOperations()) {
                ret.add(CapellaClassServices.getInformationFromOperation(ope));
            }
        }
        return ret;
    }

    private static String getInformationFromOperation(Operation ope) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<b>");
        if (ope.isIsAbstract()) {
            stringBuilder.append("abstract  ");
        }
        if (ope.isIsStatic()) {
            stringBuilder.append("static  ");
        }
        stringBuilder.append("</b>");
        stringBuilder.append(CapellaServices.getHyperlinkFromElement((EObject)ope));
        stringBuilder.append("(  ");
        for (Parameter param : ope.getOwnedParameters()) {
            if (param.getType() != null) {
                stringBuilder.append(CapellaServices.getHyperlinkFromElement((EObject)param.getType()));
            }
            if (param.getName().length() <= 0) continue;
            String paramStr = param.getName();
            if (param.getType() == null) {
                paramStr = String.valueOf(paramStr) + " : &lt;undefined&gt;";
            }
            stringBuilder.append(" " + paramStr);
        }
        stringBuilder.append(" )");
        return stringBuilder.toString();
    }

    public static List<String> getPartOf(Class theClass, String projectName, String outputFolder) {
        ArrayList<String> ret = new ArrayList<String>();
        EList typedElements = theClass.getTypedElements();
        for (TypedElement typedElement : typedElements) {
            String currentStringValue;
            if (!(typedElement instanceof Property) || ((Property)typedElement).getAggregationKind().getValue() != 3 || ret.contains(currentStringValue = String.valueOf(CapellaServices.getImageLinkFromElement(typedElement.eContainer(), projectName, outputFolder)) + " " + CapellaServices.getFullDataPkgHierarchyLink(typedElement.eContainer()))) continue;
            ret.add(currentStringValue);
        }
        return ret;
    }

    public static List<String> getReferencedBy(Class theClass, String projectName, String outputFolder) {
        ArrayList<String> ret = new ArrayList<String>();
        EList typedElements = theClass.getTypedElements();
        for (TypedElement typedElement : typedElements) {
            EObject container;
            if (!(typedElement instanceof Property) || !CapellaPropertyServices.isAssociationPropertyPredicate.test((Property)typedElement) || !((container = typedElement.eContainer()) instanceof Class)) continue;
            StringBuilder buffer = new StringBuilder();
            buffer.append(CapellaServices.getImageLinkFromElement(container, projectName, outputFolder));
            buffer.append(" ");
            buffer.append(CapellaServices.getFullDataPkgHierarchyLink(container));
            String currentStringValue = buffer.toString();
            if (ret.contains(currentStringValue)) continue;
            ret.add(currentStringValue);
        }
        return ret;
    }

    public static List<String> getParameterOf(Class theClass, String projectName, String outputFolder) {
        ArrayList<String> ret = new ArrayList<String>();
        EList typedElements = theClass.getTypedElements();
        for (TypedElement typedElement : typedElements) {
            String currentStringValue;
            EObject exchangeItem;
            if (!(typedElement instanceof ExchangeItemElement) || !((exchangeItem = typedElement.eContainer()) instanceof ExchangeItem) || ret.contains(currentStringValue = String.valueOf(CapellaServices.getImageLinkFromElement(exchangeItem, projectName, outputFolder)) + " " + CapellaServices.getHyperlinkFromElement(exchangeItem))) continue;
            ret.add(currentStringValue);
        }
        return ret;
    }
}

