/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.semantic.data.fa;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ComponentExchangeKind implements Enumerator
{
    UNSET(0, "UNSET", "UNSET"),
    DELEGATION(1, "DELEGATION", "DELEGATION"),
    ASSEMBLY(2, "ASSEMBLY", "ASSEMBLY"),
    FLOW(3, "FLOW", "FLOW");

    public static final int UNSET_VALUE = 0;
    public static final int DELEGATION_VALUE = 1;
    public static final int ASSEMBLY_VALUE = 2;
    public static final int FLOW_VALUE = 3;
    private static final ComponentExchangeKind[] VALUES_ARRAY;
    public static final List<ComponentExchangeKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ComponentExchangeKind[]{UNSET, DELEGATION, ASSEMBLY, FLOW};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ComponentExchangeKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ComponentExchangeKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ComponentExchangeKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ComponentExchangeKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ComponentExchangeKind get(int value) {
        switch (value) {
            case 0: {
                return UNSET;
            }
            case 1: {
                return DELEGATION;
            }
            case 2: {
                return ASSEMBLY;
            }
            case 3: {
                return FLOW;
            }
        }
        return null;
    }

    private ComponentExchangeKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

