/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.xmlpivot.ui;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.ui.dialogs.DiagnosticDialog;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.polarsys.capella.xmlpivot.ResourceLoader;
import org.polarsys.capella.xmlpivot.XMLPivotActivator;
import org.polarsys.capella.xmlpivot.XMLPivotResourceFactory;
import org.polarsys.capella.xmlpivot.importer.ImportRunner;

public class ImportHandler
extends AbstractHandler {
    static final String PARAM_DYNAMIC_IMPORT = "org.polarsys.capella.xmlpivot.ui.dynamicImport";

    public Object execute(final ExecutionEvent event) throws ExecutionException {
        final IFile sourceFile = (IFile)((IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event)).getFirstElement();
        try {
            final ProgressMonitorDialog dialog = new ProgressMonitorDialog(HandlerUtil.getActiveShell((ExecutionEvent)event));
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor_p) throws InvocationTargetException, InterruptedException {
                    try {
                        Resource resource;
                        ResourceLoader loader;
                        Diagnostic diagnostic;
                        boolean dynamic = "true".equals(event.getParameter(ImportHandler.PARAM_DYNAMIC_IMPORT));
                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor_p, (String)"XML Pivot Import", (int)100);
                        URI uri = URI.createPlatformResourceURI((String)sourceFile.getFullPath().toString(), (boolean)true);
                        ResourceSetImpl sourceRs = new ResourceSetImpl();
                        sourceRs.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xml", new XMLPivotResourceFactory());
                        if (dynamic) {
                            sourceRs.setPackageRegistry(XMLPivotActivator.getDefault().getDynamicPackageRegistry());
                        }
                        if ((diagnostic = (loader = new ResourceLoader()).getDiagostic(resource = loader.load((ResourceSet)sourceRs, uri))).getSeverity() != 0) {
                            dialog.getShell().getDisplay().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    DiagnosticDialog.open((Shell)dialog.getShell(), (String)"XML Pivot Import", (String)"Import continues with partially loaded model", (Diagnostic)diagnostic);
                                }
                            });
                        }
                        Collection result = new ImportRunner().run((Collection)resource.getContents(), dynamic, (IProgressMonitor)progress.newChild(90));
                        Resource targetResource = sourceRs.createResource(uri.appendFileExtension("melodymodeller"));
                        for (EObject e : result) {
                            targetResource.getContents().add((Object)e);
                        }
                        try {
                            targetResource.save(Collections.emptyMap());
                        }
                        catch (IOException exception_p) {
                            throw new InvocationTargetException(exception_p);
                        }
                    }
                    finally {
                        if (monitor_p != null) {
                            monitor_p.done();
                        }
                    }
                }
            };
            dialog.run(true, true, runnable);
        }
        catch (InvocationTargetException exception_p) {
            throw new ExecutionException(exception_p.getMessage(), (Throwable)exception_p);
        }
        catch (InterruptedException exception_p) {
            throw new ExecutionException(exception_p.getMessage(), (Throwable)exception_p);
        }
        return null;
    }
}

