/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.xmlpivot.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.statushandlers.StatusManager;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.ExecutionManagerRegistry;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.xmlpivot.ResourceLoader;
import org.polarsys.capella.xmlpivot.XMLPivotActivator;
import org.polarsys.capella.xmlpivot.XMLPivotResourceFactory;
import org.polarsys.capella.xmlpivot.importer.ImportAsNewProjectRunner;
import org.polarsys.capella.xmlpivot.merge.CompareEditorInputFactory;

public class MergeHandler
extends AbstractHandler {
    private static final String PARAM_DYNAMIC_MERGE = "org.polarsys.capella.xmlpivot.ui.dynamicMerge";
    ViewerFilter capellamodellerViewerFilter = new ViewerFilter(){

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean select(Viewer viewer_p, Object parentElement_p, Object element_p) {
            if (element_p instanceof IFile && ((IFile)element_p).getFileExtension().equals("melodymodeller")) {
                return true;
            }
            if (!(element_p instanceof IContainer)) return false;
            IContainer c = (IContainer)element_p;
            try {
                IResource[] iResourceArray = c.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        return false;
                    }
                    IResource member = iResourceArray[n2];
                    if (this.select(viewer_p, element_p, member)) {
                        return true;
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                StatusManager.getManager().handle(e, "org.polarsys.capella.xmlpivot.ui");
                return false;
            }
        }
    };

    private URI getTargetModelURI(ExecutionEvent event_p) {
        IFile[] targetFile = WorkspaceResourceDialog.openFileSelection((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event_p), (String)"XML Pivot Merge", (String)"Select existing .melodymodeller file", (boolean)false, (Object[])new Object[0], Collections.singletonList(this.capellamodellerViewerFilter));
        if (targetFile.length == 0) {
            return null;
        }
        return EcoreUtil2.getURI((IFile)targetFile[0]);
    }

    public Object execute(ExecutionEvent event_p) throws ExecutionException {
        final URI target = this.getTargetModelURI(event_p);
        if (target != null) {
            IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event_p);
            final URI source = URI.createPlatformResourceURI((String)((IFile)selection.getFirstElement()).getFullPath().toString(), (boolean)true);
            ProgressMonitorDialog loaderDialog = new ProgressMonitorDialog(HandlerUtil.getActiveShell((ExecutionEvent)event_p));
            final boolean dynamic = "true".equals(event_p.getParameter(PARAM_DYNAMIC_MERGE));
            ResourceSetImpl set = new ResourceSetImpl();
            set.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xml", new XMLPivotResourceFactory());
            if (dynamic) {
                set.setPackageRegistry(XMLPivotActivator.getDefault().getDynamicPackageRegistry());
            }
            ExecutionManager manager = ExecutionManagerRegistry.getInstance().addNewManager();
            final CompareEditorInputFactory factory = new CompareEditorInputFactory((EditingDomain)manager.getEditingDomain(), new ImportAsNewProjectRunner(), new ResourceLoader());
            final AtomicReference editorInput = new AtomicReference();
            try {
                try {
                    loaderDialog.run(true, true, new IRunnableWithProgress((ResourceSet)set){
                        private final /* synthetic */ ResourceSet val$set;
                        {
                            this.val$set = resourceSet;
                        }

                        public void run(IProgressMonitor monitor_p) throws InvocationTargetException, InterruptedException {
                            editorInput.set(factory.create(target, source, dynamic, this.val$set, monitor_p));
                        }
                    });
                }
                catch (InvocationTargetException exception_p) {
                    throw new ExecutionException(exception_p.getMessage(), (Throwable)exception_p);
                }
                catch (InterruptedException exception_p) {
                    throw new ExecutionException(exception_p.getMessage(), (Throwable)exception_p);
                }
            }
            finally {
                manager.getEditingDomain().dispose();
            }
            if (editorInput.get() != null) {
                CompareUI.openCompareEditor((CompareEditorInput)((CompareEditorInput)editorInput.get()));
            }
        }
        return null;
    }
}

