/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.semantic.data.capellacommon;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum TimeEventKind implements Enumerator
{
    AT(0, "AT", "AT"),
    AFTER(1, "AFTER", "AFTER");

    public static final int AT_VALUE = 0;
    public static final int AFTER_VALUE = 1;
    private static final TimeEventKind[] VALUES_ARRAY;
    public static final List<TimeEventKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TimeEventKind[]{AT, AFTER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TimeEventKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TimeEventKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TimeEventKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TimeEventKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TimeEventKind get(int value) {
        switch (value) {
            case 0: {
                return AT;
            }
            case 1: {
                return AFTER;
            }
        }
        return null;
    }

    private TimeEventKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

