/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.xmlpivot.common.skeleton;

import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.ctx.System;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.fa.AbstractFunctionalArchitecture;
import org.polarsys.capella.core.data.la.LaFactory;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.la.SystemAnalysisRealization;
import org.polarsys.capella.core.data.la.SystemRealization;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.capella.xmlpivot.common.skeleton.BlockArchitectureWalker;
import org.polarsys.capella.xmlpivot.common.skeleton.ModelWalkerHelper;

public class LogicalArchitectureWalker
extends BlockArchitectureWalker {
    @Override
    public void accept(EObject parent_p, ModelWalkerHelper helper) {
        super.accept(parent_p, helper);
        LogicalArchitecture la = (LogicalArchitecture)parent_p;
        if (la.getOwnedFunctionPkg() == null) {
            la.setOwnedFunctionPkg(helper.getFunctionPkg((AbstractFunctionalArchitecture)la));
        }
        if (la.getOwnedLogicalComponent() == null) {
            la.setOwnedLogicalComponent(helper.getLogicalComponent());
        }
        if (la.getOwnedLogicalContext() == null) {
            la.setOwnedLogicalContext(helper.getLogicalContext());
        }
        if (la.getOwnedLogicalActorPkg() == null) {
            la.setOwnedLogicalActorPkg(helper.getLogicalActorPkg());
        }
        this.createSystemAnalysisRealization(la);
        this.createSystemRealization(la);
    }

    private void createSystemRealization(LogicalArchitecture la) {
        SystemAnalysis sa;
        SystemEngineering eng = SystemEngineeringExt.getSystemEngineering((CapellaElement)la);
        if (eng != null && (sa = SystemEngineeringExt.getOwnedSystemAnalysis((SystemEngineering)eng)) != null) {
            LogicalComponent lc = la.getOwnedLogicalComponent();
            System sys = sa.getOwnedSystem();
            if (sys != null && lc != null) {
                SystemRealization sr2;
                for (SystemRealization sr2 : lc.getOwnedSystemRealizations()) {
                    if (sr2.getSourceElement() != lc || sr2.getTargetElement() != sys) continue;
                    return;
                }
                sr2 = LaFactory.eINSTANCE.createSystemRealization();
                lc.getOwnedSystemRealizations().add((Object)sr2);
                sr2.setSourceElement((TraceableElement)lc);
                sr2.setTargetElement((TraceableElement)sys);
            }
        }
    }

    private void createSystemAnalysisRealization(LogicalArchitecture la) {
        SystemAnalysis sa;
        SystemEngineering se = SystemEngineeringExt.getSystemEngineering((CapellaElement)la);
        if (se != null && (sa = SystemEngineeringExt.getOwnedSystemAnalysis((SystemEngineering)se)) != null) {
            SystemAnalysisRealization sar2;
            for (SystemAnalysisRealization sar2 : la.getOwnedSystemAnalysisRealizations()) {
                if (sar2.getSourceElement() != la || sar2.getTargetElement() != sa) continue;
                return;
            }
            sar2 = LaFactory.eINSTANCE.createSystemAnalysisRealization();
            la.getOwnedSystemAnalysisRealizations().add((Object)sar2);
            sar2.setSourceElement((TraceableElement)la);
            sar2.setTargetElement((TraceableElement)sa);
        }
    }
}

