/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.xmlpivot.common.skeleton;

import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.fa.AbstractFunctionalArchitecture;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.pa.LogicalArchitectureRealization;
import org.polarsys.capella.core.data.pa.LogicalComponentRealization;
import org.polarsys.capella.core.data.pa.PaFactory;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.capella.xmlpivot.common.skeleton.BlockArchitectureWalker;
import org.polarsys.capella.xmlpivot.common.skeleton.ModelWalkerHelper;

public class PhysicalArchitectureWalker
extends BlockArchitectureWalker {
    @Override
    public void accept(EObject eObject_p, ModelWalkerHelper helper) {
        super.accept(eObject_p, helper);
        PhysicalArchitecture pa = (PhysicalArchitecture)eObject_p;
        if (pa.getOwnedFunctionPkg() == null) {
            pa.setOwnedFunctionPkg(helper.getFunctionPkg((AbstractFunctionalArchitecture)pa));
        }
        if (pa.getOwnedPhysicalActorPkg() == null) {
            pa.setOwnedPhysicalActorPkg(helper.getPhysicalActorPkg());
        }
        if (pa.getOwnedPhysicalComponent() == null) {
            pa.setOwnedPhysicalComponent(helper.getPhysicalComponent());
        }
        if (pa.getOwnedPhysicalContext() == null) {
            pa.setOwnedPhysicalContext(helper.getPhysicalContext());
        }
        this.createLogicalArchitectureRealization(pa);
        this.createLogicalComponentRealization(pa);
    }

    private void createLogicalComponentRealization(PhysicalArchitecture pa) {
        LogicalArchitecture la;
        SystemEngineering eng = SystemEngineeringExt.getSystemEngineering((CapellaElement)pa);
        if (eng != null && (la = SystemEngineeringExt.getOwnedLogicalArchitecture((SystemEngineering)eng)) != null) {
            PhysicalComponent pc = pa.getOwnedPhysicalComponent();
            LogicalComponent lc = la.getOwnedLogicalComponent();
            if (pc != null && lc != null) {
                LogicalComponentRealization lcr2;
                for (LogicalComponentRealization lcr2 : pc.getOwnedLogicalComponentRealizations()) {
                    if (lcr2.getSourceElement() != pc || lcr2.getTargetElement() != lc) continue;
                    return;
                }
                lcr2 = PaFactory.eINSTANCE.createLogicalComponentRealization();
                pc.getOwnedLogicalComponentRealizations().add((Object)lcr2);
                lcr2.setSourceElement((TraceableElement)pc);
                lcr2.setTargetElement((TraceableElement)lc);
            }
        }
    }

    private void createLogicalArchitectureRealization(PhysicalArchitecture pa) {
        LogicalArchitecture la;
        SystemEngineering se = SystemEngineeringExt.getSystemEngineering((CapellaElement)pa);
        if (se != null && (la = SystemEngineeringExt.getOwnedLogicalArchitecture((SystemEngineering)se)) != null) {
            LogicalArchitectureRealization lar2;
            for (LogicalArchitectureRealization lar2 : pa.getOwnedLogicalArchitectureRealizations()) {
                if (lar2.getSourceElement() != pa || lar2.getTargetElement() != la) continue;
                return;
            }
            lar2 = PaFactory.eINSTANCE.createLogicalArchitectureRealization();
            pa.getOwnedLogicalArchitectureRealizations().add((Object)lar2);
            lar2.setSourceElement((TraceableElement)pa);
            lar2.setTargetElement((TraceableElement)la);
        }
    }
}

