/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.xmlpivot.exporter;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.xmlpivot.exporter.DefaultExporter;
import org.polarsys.capella.xmlpivot.exporter.ExportEngine;

public class AbstractIncrementalExporter
extends DefaultExporter {
    private final Function<Collection<? extends EObject>, Iterator<? extends EObject>> incrementor;

    public AbstractIncrementalExporter(ExportEngine engine, Function<Collection<? extends EObject>, Iterator<? extends EObject>> incrementor) {
        super(engine);
        this.incrementor = incrementor;
    }

    @Override
    protected final void doCopyObjects(Collection<? extends EObject> context, IProgressMonitor monitor_p) {
        UnmodifiableIterator toCopy = new ArrayList<EObject>(context).iterator();
        while (toCopy.hasNext()) {
            HashSet<EObject> lastIteration = new HashSet<EObject>();
            while (toCopy.hasNext()) {
                EObject next = toCopy.next();
                this.getExportEngine().copy(next);
                lastIteration.add(next);
            }
            Iterator more = (Iterator)this.incrementor.apply(lastIteration);
            toCopy = Iterators.filter((Iterator)more, (Predicate)Predicates.not((Predicate)Predicates.or((Predicate)Predicates.in(this.getExportEngine().keySet()), (Predicate)Predicates.in(this.getExportEngine().getUnmappedObjects()))));
        }
    }
}

