/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.semantic.data.information;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ExchangeMechanism implements Enumerator
{
    UNSET(0, "UNSET", "UNSET"),
    FLOW(1, "FLOW", "FLOW"),
    OPERATION(2, "OPERATION", "OPERATION"),
    EVENT(3, "EVENT", "EVENT"),
    SHARED_DATA(4, "SHARED_DATA", "SHARED_DATA");

    public static final int UNSET_VALUE = 0;
    public static final int FLOW_VALUE = 1;
    public static final int OPERATION_VALUE = 2;
    public static final int EVENT_VALUE = 3;
    public static final int SHARED_DATA_VALUE = 4;
    private static final ExchangeMechanism[] VALUES_ARRAY;
    public static final List<ExchangeMechanism> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ExchangeMechanism[]{UNSET, FLOW, OPERATION, EVENT, SHARED_DATA};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ExchangeMechanism get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ExchangeMechanism result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ExchangeMechanism getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ExchangeMechanism result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ExchangeMechanism get(int value) {
        switch (value) {
            case 0: {
                return UNSET;
            }
            case 1: {
                return FLOW;
            }
            case 2: {
                return OPERATION;
            }
            case 3: {
                return EVENT;
            }
            case 4: {
                return SHARED_DATA;
            }
        }
        return null;
    }

    private ExchangeMechanism(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

