/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.core.helpers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class EMFHelper {
    private EMFHelper() {
    }

    public static String getIdentifier(EObject eObject) {
        StringBuilder identifier;
        if (eObject == null) {
            return "<null>";
        }
        if (eObject.eClass() == null) {
            return eObject.toString();
        }
        boolean success = false;
        EList attributes = eObject.eClass().getEAllAttributes();
        success = EMFHelper.tryGetSingleAttribute(eObject, (List<EAttribute>)attributes, identifier = new StringBuilder());
        if (!success) {
            success = EMFHelper.tryGetNameAttribute(eObject, (List<EAttribute>)attributes, identifier);
        }
        if (!success) {
            success = EMFHelper.tryGetAnyAttribute(eObject, (List<EAttribute>)attributes, identifier);
        }
        if (success) {
            identifier.append(" : ");
        }
        identifier.append(eObject.eClass().getName());
        return identifier.toString();
    }

    public static boolean tryGetSingleAttribute(EObject eObject, List<EAttribute> attributes, StringBuilder name) {
        Object obj;
        boolean success = false;
        if (attributes.size() == 1 && (obj = eObject.eGet((EStructuralFeature)attributes.get(0))) != null) {
            name.append(obj.toString());
            success = true;
        }
        return success;
    }

    public static boolean tryGetNameAttribute(EObject eObject, List<EAttribute> attributes, StringBuilder name) {
        boolean success = false;
        for (EAttribute feature : attributes) {
            Object obj;
            if (!feature.getName().equals("name") || (obj = eObject.eGet((EStructuralFeature)feature)) == null) continue;
            name.append(obj.toString());
            success = true;
            break;
        }
        return success;
    }

    public static boolean tryGetAnyAttribute(EObject eObject, List<EAttribute> attributes, StringBuilder name) {
        boolean success = false;
        String nonStringName = null;
        String stringName = null;
        for (EAttribute feature : attributes) {
            Object obj = eObject.eGet((EStructuralFeature)feature);
            if (obj == null) continue;
            if (obj instanceof String) {
                stringName = (String)obj;
                break;
            }
            nonStringName = obj.toString();
        }
        if (stringName != null && !stringName.equals("null")) {
            name.append(stringName);
            success = true;
        } else if (nonStringName != null && !nonStringName.equals("null")) {
            name.append(nonStringName);
            success = true;
        }
        return success;
    }

    public static List<EObject> linearize(Object object) {
        ArrayList<EObject> elementList = new ArrayList<EObject>();
        if (object instanceof EObject) {
            EObject root = (EObject)object;
            root.eAllContents().forEachRemaining(element -> {
                boolean bl = elementList.add((EObject)element);
            });
            elementList.add(root);
        }
        return elementList;
    }

    public static String getNameAttribute(EObject eObject) {
        String name = "";
        for (EAttribute feature : eObject.eClass().getEAllAttributes()) {
            Object obj;
            if (!feature.getName().equals("name") || (obj = eObject.eGet((EStructuralFeature)feature)) == null) continue;
            name = obj.toString();
        }
        return name;
    }
}

