/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.plantuml;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.sourceforge.plantuml.eclipse.utils.DiagramTextProvider;
import net.sourceforge.plantuml.eclipse.views.PlantUmlView;
import org.eclipse.capra.core.adapters.Connection;
import org.eclipse.capra.core.adapters.TraceMetaModelAdapter;
import org.eclipse.capra.core.adapters.TracePersistenceAdapter;
import org.eclipse.capra.core.handlers.IArtifactHandler;
import org.eclipse.capra.core.handlers.IArtifactUnpacker;
import org.eclipse.capra.core.helpers.ArtifactHelper;
import org.eclipse.capra.core.helpers.EMFHelper;
import org.eclipse.capra.core.helpers.ExtensionPointHelper;
import org.eclipse.capra.ui.helpers.TraceCreationHelper;
import org.eclipse.capra.ui.plantuml.DisplayInternalLinksHandler;
import org.eclipse.capra.ui.plantuml.SelectRelationshipsHandler;
import org.eclipse.capra.ui.plantuml.ToggleDisplayGraphHandler;
import org.eclipse.capra.ui.plantuml.ToggleTransitivityHandler;
import org.eclipse.capra.ui.plantuml.TransitivityDepthHandler;
import org.eclipse.capra.ui.plantuml.VisualizationHelper;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;

public class DiagramTextProviderHandler
implements DiagramTextProvider {
    private EObject artifactModel = null;

    public String getDiagramText(IEditorPart editor, ISelection input) {
        return this.getDiagramText((IWorkbenchPart)editor, input);
    }

    public String getDiagramText(IViewPart view, ISelection input) {
        return this.getDiagramText((IWorkbenchPart)view, input);
    }

    public String getDiagramText(IWorkbenchPart part, ISelection input) {
        ArrayList<Object> selectedModels = new ArrayList<Object>();
        if (part.getSite().getSelectionProvider() != null) {
            selectedModels.addAll(TraceCreationHelper.extractSelectedElements((ISelection)part.getSite().getSelectionProvider().getSelection()));
        }
        return this.getDiagramText(selectedModels);
    }

    public String getDiagramText(List<Object> selectedModels) {
        ArtifactHelper artifactHelper;
        IArtifactHandler handler;
        ArrayList<EObject> firstModelElements = null;
        ArrayList<EObject> secondModelElements = null;
        EObject selectedObject = null;
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        EObject traceModel = null;
        ArrayList<Connection> traces = new ArrayList();
        TracePersistenceAdapter persistenceAdapter = (TracePersistenceAdapter)ExtensionPointHelper.getTracePersistenceAdapter().get();
        TraceMetaModelAdapter metamodelAdapter = (TraceMetaModelAdapter)ExtensionPointHelper.getTraceMetamodelAdapter().get();
        this.artifactModel = persistenceAdapter.getArtifactWrappers((ResourceSet)resourceSet);
        if (selectedModels.size() > 0 && (handler = (IArtifactHandler)(artifactHelper = new ArtifactHelper(this.artifactModel)).getHandler(selectedModels.get(0)).orElse(null)) != null) {
            Object firstElement_unpacked = null;
            firstElement_unpacked = handler instanceof IArtifactUnpacker ? ((IArtifactUnpacker)IArtifactUnpacker.class.cast(handler)).unpack(selectedModels.get(0)) : selectedModels.get(0);
            selectedObject = handler.createWrapper(firstElement_unpacked, this.artifactModel);
            if (selectedObject != null && selectedObject.eResource() != null) {
                resourceSet = selectedObject.eResource().getResourceSet();
                traceModel = persistenceAdapter.getTraceModel((ResourceSet)resourceSet);
                List<String> selectedRelationshipTypes = SelectRelationshipsHandler.getSelectedRelationshipTypes();
                if (selectedModels.size() == 1) {
                    if (ToggleTransitivityHandler.isTraceViewTransitive()) {
                        int transitivityDepth = Integer.parseInt(TransitivityDepthHandler.getTransitivityDepth());
                        traces = metamodelAdapter.getTransitivelyConnectedElements(selectedObject, traceModel, selectedRelationshipTypes, transitivityDepth);
                    } else {
                        traces = metamodelAdapter.getConnectedElements(selectedObject, traceModel, selectedRelationshipTypes);
                    }
                    if (DisplayInternalLinksHandler.areInternalLinksShown() && ToggleTransitivityHandler.isTraceViewTransitive()) {
                        EObject previousElement = SelectRelationshipsHandler.getPreviousElement();
                        int transitivityDepth = Integer.parseInt(TransitivityDepthHandler.getTransitivityDepth());
                        if (previousElement != null) {
                            String currentElementName;
                            String previousElementName = EMFHelper.getNameAttribute((EObject)previousElement);
                            if (!previousElementName.equals(currentElementName = EMFHelper.getNameAttribute((EObject)selectedObject))) {
                                SelectRelationshipsHandler.clearPossibleRelationsForSelection();
                                SelectRelationshipsHandler.emptySelectedRelationshipTypes();
                                SelectRelationshipsHandler.setPreviousElement(selectedObject);
                            }
                        } else {
                            SelectRelationshipsHandler.setPreviousElement(selectedObject);
                        }
                        traces.addAll(metamodelAdapter.getInternalElementsTransitive(selectedObject, traceModel, selectedRelationshipTypes, transitivityDepth, traces));
                    } else if (DisplayInternalLinksHandler.areInternalLinksShown()) {
                        EObject previousElement = SelectRelationshipsHandler.getPreviousElement();
                        if (previousElement != null) {
                            String currentElementName;
                            String previousElementName = EMFHelper.getNameAttribute((EObject)previousElement);
                            if (!previousElementName.equals(currentElementName = EMFHelper.getNameAttribute((EObject)selectedObject))) {
                                SelectRelationshipsHandler.clearPossibleRelationsForSelection();
                                SelectRelationshipsHandler.emptySelectedRelationshipTypes();
                                SelectRelationshipsHandler.setPreviousElement(selectedObject);
                            }
                        } else {
                            SelectRelationshipsHandler.setPreviousElement(selectedObject);
                        }
                        traces.addAll(metamodelAdapter.getInternalElements(selectedObject, traceModel, selectedRelationshipTypes, false, 0, traces));
                    }
                    List<EObject> links = DiagramTextProviderHandler.extractLinksFromTraces(traces);
                    SelectRelationshipsHandler.addToPossibleRelationsForSelection(links);
                    return VisualizationHelper.createNeighboursView(traces, EMFHelper.linearize((Object)handler.createWrapper(firstElement_unpacked, this.artifactModel)), this.artifactModel);
                }
                if (selectedModels.size() == 2) {
                    Object secondElement_unpacked = null;
                    secondElement_unpacked = handler instanceof IArtifactUnpacker ? ((IArtifactUnpacker)IArtifactUnpacker.class.cast(handler)).unpack(selectedModels.get(1)) : selectedModels.get(1);
                    IArtifactHandler handlerSecondElement = artifactHelper.getHandler(selectedModels.get(1)).orElse(null);
                    if (ToggleTransitivityHandler.isTraceViewTransitive()) {
                        firstModelElements = EMFHelper.linearize((Object)handler.createWrapper(firstElement_unpacked, this.artifactModel));
                        secondModelElements = EMFHelper.linearize((Object)handlerSecondElement.createWrapper(secondElement_unpacked, this.artifactModel));
                    } else {
                        ArrayList<EObject> firstObject = new ArrayList<EObject>();
                        firstObject.add(handler.createWrapper(firstElement_unpacked, this.artifactModel));
                        ArrayList<EObject> secondObject = new ArrayList<EObject>();
                        secondObject.add(handlerSecondElement.createWrapper(secondElement_unpacked, this.artifactModel));
                        firstModelElements = firstObject;
                        secondModelElements = secondObject;
                    }
                } else if (selectedModels.size() > 2) {
                    if (ToggleTransitivityHandler.isTraceViewTransitive()) {
                        secondModelElements = firstModelElements = selectedModels.stream().flatMap(r -> {
                            IArtifactHandler individualhandler = artifactHelper.getHandler(r).orElse(null);
                            Object object = null;
                            object = individualhandler instanceof IArtifactUnpacker ? ((IArtifactUnpacker)IArtifactUnpacker.class.cast(individualhandler)).unpack(r) : r;
                            return EMFHelper.linearize((Object)individualhandler.createWrapper(object, this.artifactModel)).stream();
                        }).collect(Collectors.toList());
                    } else {
                        ArrayList<EObject> wrappers = new ArrayList<EObject>();
                        selectedModels.stream().forEach(o -> {
                            IArtifactHandler individualhandler = artifactHelper.getHandler(o).orElse(null);
                            Object object = null;
                            object = individualhandler instanceof IArtifactUnpacker ? ((IArtifactUnpacker)IArtifactUnpacker.class.cast(individualhandler)).unpack(o) : o;
                            wrappers.add(individualhandler.createWrapper(object, this.artifactModel));
                        });
                        secondModelElements = firstModelElements = wrappers;
                        if (ToggleDisplayGraphHandler.isDisplayGraph()) {
                            for (EObject object : wrappers) {
                                traces.addAll(metamodelAdapter.getConnectedElements(object, traceModel));
                            }
                            ArrayList<Connection> relevantTraces = new ArrayList<Connection>();
                            for (Connection connection : traces) {
                                if (!selectedModels.contains(connection.getOrigin())) continue;
                                if (!selectedModels.stream().anyMatch(connection.getTargets()::contains)) continue;
                                Connection newConnection = new Connection(connection.getOrigin(), connection.getTargets().stream().filter(selectedModels::contains).collect(Collectors.toList()), connection.getTlink());
                                relevantTraces.add(newConnection);
                            }
                            return VisualizationHelper.createNeighboursView(relevantTraces, wrappers, this.artifactModel);
                        }
                    }
                }
            }
        }
        if (DisplayInternalLinksHandler.areInternalLinksShown()) {
            return VisualizationHelper.createMatrix(traceModel, this.artifactModel, firstModelElements, secondModelElements, true);
        }
        return VisualizationHelper.createMatrix(traceModel, this.artifactModel, firstModelElements, secondModelElements, false);
    }

    public boolean supportsEditor(IEditorPart editor) {
        return true;
    }

    public boolean supportsView(IViewPart part) {
        return !(part instanceof PlantUmlView);
    }

    public boolean supportsSelection(ISelection selection) {
        return true;
    }

    private static List<EObject> extractLinksFromTraces(List<Connection> traces) {
        ArrayList<EObject> links = new ArrayList<EObject>();
        for (Connection trace : traces) {
            if (links.contains(trace.getTlink())) continue;
            links.add(trace.getTlink());
        }
        return links;
    }
}

