/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.plantuml;

import com.google.common.base.Objects;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.eclipse.capra.core.adapters.Connection;
import org.eclipse.capra.core.adapters.TraceMetaModelAdapter;
import org.eclipse.capra.core.helpers.ArtifactHelper;
import org.eclipse.capra.core.helpers.ExtensionPointHelper;
import org.eclipse.capra.ui.plantuml.Connections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;

public class VisualizationHelper {
    public static String createMatrix(EObject traceModel, EObject artifactModel, Collection<EObject> firstElements, Collection<EObject> secondElements, Boolean internalLinks) {
        boolean _notEquals;
        String _xblockexpression = null;
        Optional _traceMetamodelAdapter = ExtensionPointHelper.getTraceMetamodelAdapter();
        TraceMetaModelAdapter traceAdapter = (TraceMetaModelAdapter)_traceMetamodelAdapter.get();
        ArtifactHelper artifactHelper = new ArtifactHelper(artifactModel);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"@startuml");
        _builder.newLine();
        _builder.append((Object)"salt");
        _builder.newLine();
        _builder.append((Object)"{#");
        _builder.newLine();
        boolean bl = _notEquals = !Objects.equal(firstElements, null);
        if (_notEquals) {
            _builder.append((Object)".");
            for (EObject e : secondElements) {
                _builder.append((Object)"|");
                String _artifactLabel = artifactHelper.getArtifactLabel(e);
                _builder.append((Object)_artifactLabel, "");
            }
            _builder.newLineIfNotEmpty();
            for (EObject first : firstElements) {
                String _artifactLabel_1 = artifactHelper.getArtifactLabel(first);
                _builder.append((Object)_artifactLabel_1, "");
                for (EObject second : secondElements) {
                    _builder.append((Object)" |");
                    if (internalLinks.booleanValue()) {
                        if (traceAdapter.isThereATraceBetween(first, second, traceModel) || traceAdapter.isThereAnInternalTraceBetween(first, second)) {
                            _builder.append((Object)"X");
                            continue;
                        }
                        _builder.append((Object)".");
                        continue;
                    }
                    boolean _isThereATraceBetween = traceAdapter.isThereATraceBetween(first, second, traceModel);
                    if (_isThereATraceBetween) {
                        _builder.append((Object)"X");
                        continue;
                    }
                    _builder.append((Object)".");
                }
                _builder.newLineIfNotEmpty();
            }
        } else {
            _builder.append((Object)"Choose two containers to show a traceability matrix of their contents.");
            _builder.newLine();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"@enduml");
        _builder.newLine();
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    public static String createNeighboursView(List<Connection> connections, List<EObject> selectedObjects, EObject artifactModel) {
        String _xblockexpression = null;
        Connections helper = new Connections(connections, selectedObjects, artifactModel);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"@startuml");
        _builder.newLine();
        _builder.append((Object)"object \"");
        String _originLabel = helper.originLabel();
        _builder.append((Object)_originLabel, "");
        boolean _originHasLocation = helper.originHasLocation();
        if (_originHasLocation) {
            _builder.append((Object)" [[");
            String _originLocation = helper.originLocation();
            _builder.append((Object)_originLocation, "");
            _builder.append((Object)" (Go to)]]");
        }
        _builder.append((Object)"\" as ");
        String _originId = helper.originId();
        _builder.append((Object)_originId, "");
        _builder.append((Object)" #pink");
        _builder.newLineIfNotEmpty();
        Collection<String> _objectIdsWithoutOrigin = helper.objectIdsWithoutOrigin();
        for (String id : _objectIdsWithoutOrigin) {
            _builder.append((Object)"object \"");
            String _label = helper.label(id);
            _builder.append((Object)_label, "");
            boolean _hasLocation = helper.hasLocation(id);
            if (_hasLocation) {
                _builder.append((Object)" [[");
                String _location = helper.location(id);
                _builder.append((Object)_location, "");
                _builder.append((Object)" (Go to)]]");
            }
            _builder.append((Object)"\" as ");
            _builder.append((Object)id, "");
            _builder.newLineIfNotEmpty();
        }
        List<String> _arrows = helper.arrows();
        for (String a : _arrows) {
            _builder.append((Object)a, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"@enduml");
        _builder.newLine();
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }
}

