/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.matrix.views;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.capra.core.adapters.Connection;
import org.eclipse.capra.core.adapters.TraceMetaModelAdapter;
import org.eclipse.capra.core.adapters.TracePersistenceAdapter;
import org.eclipse.capra.core.handlers.IArtifactHandler;
import org.eclipse.capra.core.handlers.IArtifactUnpacker;
import org.eclipse.capra.core.helpers.ArtifactHelper;
import org.eclipse.capra.core.helpers.EMFHelper;
import org.eclipse.capra.core.helpers.ExtensionPointHelper;
import org.eclipse.capra.core.helpers.TraceHelper;
import org.eclipse.capra.ui.helpers.SelectionSupportHelper;
import org.eclipse.capra.ui.matrix.TraceabilityMatrixBodyToolTip;
import org.eclipse.capra.ui.matrix.TraceabilityMatrixColumnHeaderDataProvider;
import org.eclipse.capra.ui.matrix.TraceabilityMatrixDataProvider;
import org.eclipse.capra.ui.matrix.TraceabilityMatrixHeaderToolTip;
import org.eclipse.capra.ui.matrix.TraceabilityMatrixRowHeaderDataProvider;
import org.eclipse.capra.ui.matrix.selection.TraceabilityMatrixSelectionProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.AbstractUiBindingConfiguration;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.export.command.ExportCommand;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.CornerLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.RowHeaderLayer;
import org.eclipse.nebula.widgets.nattable.hover.HoverLayer;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.resize.action.ColumnResizeCursorAction;
import org.eclipse.nebula.widgets.nattable.resize.action.RowResizeCursorAction;
import org.eclipse.nebula.widgets.nattable.resize.event.ColumnResizeEventMatcher;
import org.eclipse.nebula.widgets.nattable.resize.event.RowResizeEventMatcher;
import org.eclipse.nebula.widgets.nattable.resize.mode.ColumnResizeDragMode;
import org.eclipse.nebula.widgets.nattable.resize.mode.RowResizeDragMode;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.nebula.widgets.nattable.ui.action.IDragMode;
import org.eclipse.nebula.widgets.nattable.ui.action.IMouseAction;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.ui.matcher.IMouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.matcher.MouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ViewPart;

public class TraceabilityMatrixView
extends ViewPart {
    public static final String ID = "org.eclipse.capra.ui.matrix.views.TraceabilityMatrixView";
    private static final String SAME_LABEL = "SAME";
    private static final String LINK_LABEL = "LINKED";
    private NatTable traceMatrixTable;
    private Action refreshAction;
    private Action showAllAction;
    private Action exportExcelAction;
    private Composite parent;
    private ResourceSet resourceSet = new ResourceSetImpl();
    private final TraceMetaModelAdapter traceAdapter = (TraceMetaModelAdapter)ExtensionPointHelper.getTraceMetamodelAdapter().get();
    private TraceMetaModelAdapter metamodelAdapter = (TraceMetaModelAdapter)ExtensionPointHelper.getTraceMetamodelAdapter().get();
    private TracePersistenceAdapter persistenceAdapter = (TracePersistenceAdapter)ExtensionPointHelper.getTracePersistenceAdapter().get();
    private EObject traceModel = null;
    private EObject artifactModel = null;
    private ArtifactHelper artifactHelper;
    private TraceHelper traceHelper;
    private TraceabilityMatrixDataProvider bodyDataProvider;
    private TraceabilityMatrixSelectionProvider selectionProvider;
    private BodyLayerStack bodyLayer;
    private List<Object> selectedModels = new ArrayList<Object>();
    private boolean selectionModified = false;
    private ISelectionListener selectionListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            TraceabilityMatrixView.this.populateSelectedModels(part, selection);
            if (TraceabilityMatrixView.this.traceMatrixTable != null && TraceabilityMatrixView.this.selectionModified) {
                TraceabilityMatrixView.this.updateTraceabilityMatrix();
            }
        }
    };
    private AbstractRegistryConfiguration capraNatTableStyleConfiguration = new AbstractRegistryConfiguration(){

        public void configureRegistry(IConfigRegistry configRegistry) {
            Style cellStyle = new Style();
            cellStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)GUIHelper.COLOR_BLACK);
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, "NORMAL", TraceabilityMatrixView.SAME_LABEL);
            cellStyle = new Style();
            cellStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)GUIHelper.COLOR_GREEN);
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, "NORMAL", TraceabilityMatrixView.LINK_LABEL);
            Style style = new Style();
            style.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)GUIHelper.COLOR_YELLOW);
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)style, "HOVER");
            style = new Style();
            style.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)GUIHelper.COLOR_GREEN);
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)style, "SELECT_HOVER");
        }
    };
    private AbstractUiBindingConfiguration capraUiBindingConfiguration = new AbstractUiBindingConfiguration(){

        public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
            uiBindingRegistry.registerFirstMouseMoveBinding((IMouseEventMatcher)new ColumnResizeEventMatcher(0, "ROW_HEADER", 0), (IMouseAction)new ColumnResizeCursorAction());
            uiBindingRegistry.registerFirstMouseDragMode((IMouseEventMatcher)new ColumnResizeEventMatcher(0, "ROW_HEADER", 1), (IDragMode)new ColumnResizeDragMode());
            uiBindingRegistry.registerFirstMouseMoveBinding((IMouseEventMatcher)new RowResizeEventMatcher(0, "COLUMN_HEADER", 0), (IMouseAction)new RowResizeCursorAction());
            uiBindingRegistry.registerFirstMouseDragMode((IMouseEventMatcher)new RowResizeEventMatcher(0, "COLUMN_HEADER", 1), (IDragMode)new RowResizeDragMode());
            uiBindingRegistry.registerFirstMouseMoveBinding((IMouseEventMatcher)new ColumnResizeEventMatcher(0, "CORNER", 0), (IMouseAction)new ColumnResizeCursorAction());
            uiBindingRegistry.registerFirstMouseDragMode((IMouseEventMatcher)new ColumnResizeEventMatcher(0, "CORNER", 1), (IDragMode)new ColumnResizeDragMode());
            uiBindingRegistry.registerFirstMouseMoveBinding((IMouseEventMatcher)new RowResizeEventMatcher(0, "CORNER", 0), (IMouseAction)new RowResizeCursorAction());
            uiBindingRegistry.registerFirstMouseDragMode((IMouseEventMatcher)new RowResizeEventMatcher(0, "CORNER", 1), (IDragMode)new RowResizeDragMode());
        }
    };
    private IConfigLabelAccumulator cellLabelAccumulator = new IConfigLabelAccumulator(){

        public void accumulateConfigLabels(LabelStack configLabels, int columnPosition, int rowPosition) {
            int columnIndex = TraceabilityMatrixView.this.bodyLayer.getColumnIndexByPosition(columnPosition);
            int rowIndex = TraceabilityMatrixView.this.bodyLayer.getRowIndexByPosition(rowPosition);
            if (TraceabilityMatrixView.this.sameElement(TraceabilityMatrixView.this.bodyDataProvider.getRow(rowIndex), TraceabilityMatrixView.this.bodyDataProvider.getColumn(columnIndex))) {
                configLabels.addLabel(TraceabilityMatrixView.SAME_LABEL);
            } else {
                String cell_text = (String)TraceabilityMatrixView.this.bodyDataProvider.getDataValue(columnIndex, rowIndex);
                if (!cell_text.equals("")) {
                    configLabels.addLabel(TraceabilityMatrixView.LINK_LABEL);
                }
            }
        }
    };

    public void createPartControl(Composite parent) {
        this.parent = parent;
        this.updateTraceabilityMatrix();
        this.makeActions();
        this.contributeToActionBars();
        this.getViewSite().getPage().addSelectionListener(this.selectionListener);
    }

    public void dispose() {
        this.getViewSite().getPage().removeSelectionListener(this.selectionListener);
        this.traceMatrixTable.dispose();
        this.traceMatrixTable = null;
        super.dispose();
    }

    public void setFocus() {
        if (this.traceMatrixTable != null) {
            this.traceMatrixTable.setFocus();
        }
    }

    protected void updateTraceabilityMatrix() {
        ArrayList<Connection> traces = new ArrayList();
        this.artifactModel = this.persistenceAdapter.getArtifactWrappers(this.resourceSet);
        this.artifactHelper = new ArtifactHelper(this.artifactModel);
        this.traceModel = this.persistenceAdapter.getTraceModel(this.resourceSet);
        this.traceHelper = new TraceHelper(this.traceModel);
        if (!this.selectedModels.isEmpty()) {
            for (Object model : this.selectedModels) {
                IArtifactHandler handler = this.artifactHelper.getHandler(model).orElse(null);
                if (handler == null) continue;
                Object unpackedElement = null;
                unpackedElement = handler instanceof IArtifactUnpacker ? ((IArtifactUnpacker)IArtifactUnpacker.class.cast(handler)).unpack(model) : model;
                EObject wrappedElement = handler.createWrapper(unpackedElement, this.artifactModel);
                if (!this.traceHelper.isArtifactInTraceModel(wrappedElement)) continue;
                EObject selectedObject = wrappedElement;
                traces.addAll(this.traceAdapter.getConnectedElements(selectedObject, this.traceModel));
            }
        } else if (this.traceModel != null) {
            traces = this.metamodelAdapter.getAllTraceLinks(this.traceModel);
        }
        if (!traces.isEmpty()) {
            if (this.traceMatrixTable != null) {
                this.traceMatrixTable.dispose();
                this.traceMatrixTable = null;
            }
            this.bodyDataProvider = new TraceabilityMatrixDataProvider(traces, this.traceModel, this.traceAdapter);
            TraceabilityMatrixColumnHeaderDataProvider colHeaderDataProvider = new TraceabilityMatrixColumnHeaderDataProvider(this.bodyDataProvider.getColumns(), this.artifactHelper);
            TraceabilityMatrixRowHeaderDataProvider rowHeaderDataProvider = new TraceabilityMatrixRowHeaderDataProvider(this.bodyDataProvider.getRows(), this.artifactHelper);
            this.bodyLayer = new BodyLayerStack(this.bodyDataProvider);
            ColumnHeaderLayerStack columnHeaderLayer = new ColumnHeaderLayerStack(colHeaderDataProvider);
            RowHeaderLayerStack rowHeaderLayer = new RowHeaderLayerStack(rowHeaderDataProvider);
            DefaultCornerDataProvider cornerDataProvider = new DefaultCornerDataProvider((IDataProvider)colHeaderDataProvider, (IDataProvider)rowHeaderDataProvider);
            CornerLayer cornerLayer = new CornerLayer((IUniqueIndexLayer)new DataLayer((IDataProvider)cornerDataProvider), (ILayer)rowHeaderLayer, (ILayer)columnHeaderLayer);
            this.bodyLayer.setConfigLabelAccumulator(this.cellLabelAccumulator);
            GridLayer gridLayer = new GridLayer((ILayer)this.bodyLayer, (ILayer)columnHeaderLayer, (ILayer)rowHeaderLayer, (ILayer)cornerLayer);
            gridLayer.addConfiguration((IConfiguration)this.capraUiBindingConfiguration);
            this.traceMatrixTable = new NatTable(this.parent, (ILayer)gridLayer, false);
            this.traceMatrixTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
            this.traceMatrixTable.addConfiguration((IConfiguration)this.capraNatTableStyleConfiguration);
            this.traceMatrixTable.configure();
            if (this.selectionProvider == null) {
                this.selectionProvider = new TraceabilityMatrixSelectionProvider(this.bodyLayer.getSelectionLayer(), this.bodyDataProvider);
            } else {
                this.selectionProvider.updateProvider(this.bodyLayer.getSelectionLayer(), this.bodyDataProvider);
            }
            this.getSite().setSelectionProvider((ISelectionProvider)this.selectionProvider);
            this.attachToolTip();
            this.parent.layout();
        }
    }

    private void populateSelectedModels(IWorkbenchPart part, ISelection selection) {
        List newSelectedObjects = SelectionSupportHelper.extractSelectedElements((ISelection)selection, (IWorkbenchPart)part);
        if (!this.listEqualsIgnoreOrder(this.selectedModels, newSelectedObjects)) {
            this.selectionModified = true;
            this.selectedModels.clear();
            this.selectedModels.addAll(newSelectedObjects);
        } else {
            this.selectionModified = false;
        }
    }

    private <T> boolean listEqualsIgnoreOrder(List<T> list1, List<T> list2) {
        return new HashSet<T>(list1).equals(new HashSet<T>(list2));
    }

    private void attachToolTip() {
        new TraceabilityMatrixBodyToolTip(this.traceMatrixTable, this.bodyDataProvider, this.artifactHelper);
        new TraceabilityMatrixHeaderToolTip(this.traceMatrixTable, this.bodyDataProvider, this.artifactHelper);
    }

    private void openEditor(EObject element) throws PartInitException {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            URI uri = new URI(this.artifactHelper.getArtifactLocation(element));
            Path artifactPath = new Path(uri.getPath());
            artifactPath = artifactPath.removeFirstSegments(1);
            IFile artifactFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)artifactPath);
            IDE.openEditor((IWorkbenchPage)page, (IFile)artifactFile);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.refreshAction);
        manager.add((IAction)this.showAllAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.exportExcelAction);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.refreshAction);
        manager.add((IAction)this.showAllAction);
    }

    private void makeActions() {
        this.refreshAction = new Action(){

            public void run() {
                TraceabilityMatrixView.this.updateTraceabilityMatrix();
            }
        };
        this.refreshAction.setText("Refresh");
        this.refreshAction.setToolTipText("Refresh");
        this.showAllAction = new Action(){

            public void run() {
                TraceabilityMatrixView.this.selectedModels.clear();
                TraceabilityMatrixView.this.updateTraceabilityMatrix();
            }
        };
        this.showAllAction.setText("Show all");
        this.showAllAction.setToolTipText("Show all");
        this.exportExcelAction = new Action(){

            public void run() {
                ExportCommand cmd = new ExportCommand(TraceabilityMatrixView.this.traceMatrixTable.getConfigRegistry(), TraceabilityMatrixView.this.traceMatrixTable.getShell());
                TraceabilityMatrixView.this.traceMatrixTable.doCommand((ILayerCommand)cmd);
            }
        };
        this.exportExcelAction.setText("Export to Excel...");
        this.exportExcelAction.setToolTipText("Exports the currently shown traceability matrix as an Excel file.");
    }

    private boolean sameElement(EObject first, EObject second) {
        return EMFHelper.getIdentifier((EObject)first).equals(EMFHelper.getIdentifier((EObject)second));
    }

    private class BodyLayerStack
    extends AbstractLayerTransform {
        private SelectionLayer selectionLayer;

        public BodyLayerStack(IDataProvider dataProvider) {
            DataLayer bodyDataLayer = new DataLayer(dataProvider);
            HoverLayer bodyHoverLayer = new HoverLayer((IUniqueIndexLayer)bodyDataLayer);
            this.selectionLayer = new SelectionLayer((IUniqueIndexLayer)bodyHoverLayer);
            ViewportLayer viewportLayer = new ViewportLayer((IUniqueIndexLayer)this.selectionLayer);
            this.setUnderlyingLayer((ILayer)viewportLayer);
        }

        public SelectionLayer getSelectionLayer() {
            return this.selectionLayer;
        }
    }

    private class ColumnHeaderLayerStack
    extends AbstractLayerTransform {
        public ColumnHeaderLayerStack(IDataProvider dataProvider) {
            DataLayer dataLayer = new DataLayer(dataProvider);
            ColumnHeaderLayer colHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)dataLayer, (ILayer)TraceabilityMatrixView.this.bodyLayer, TraceabilityMatrixView.this.bodyLayer.getSelectionLayer());
            colHeaderLayer.addConfiguration((IConfiguration)new AbstractUiBindingConfiguration(){

                public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
                    uiBindingRegistry.registerDoubleClickBinding((IMouseEventMatcher)MouseEventMatcher.columnHeaderLeftClick((int)0), new IMouseAction(){

                        public void run(NatTable natTable, MouseEvent event) {
                            try {
                                int columnPosition = natTable.getColumnPositionByX(event.x);
                                int columnIndex = natTable.getColumnIndexByPosition(columnPosition);
                                EObject element = TraceabilityMatrixView.this.bodyDataProvider.getColumn(columnIndex);
                                TraceabilityMatrixView.this.openEditor(element);
                            }
                            catch (PartInitException partInitException) {
                                // empty catch block
                            }
                        }
                    });
                }
            });
            this.setUnderlyingLayer((ILayer)colHeaderLayer);
        }
    }

    private class RowHeaderLayerStack
    extends AbstractLayerTransform {
        public RowHeaderLayerStack(IDataProvider dataProvider) {
            DataLayer dataLayer = new DataLayer(dataProvider, 50, 20);
            RowHeaderLayer rowHeaderLayer = new RowHeaderLayer((IUniqueIndexLayer)dataLayer, (ILayer)TraceabilityMatrixView.this.bodyLayer, TraceabilityMatrixView.this.bodyLayer.getSelectionLayer());
            rowHeaderLayer.addConfiguration((IConfiguration)new AbstractUiBindingConfiguration(){

                public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
                    uiBindingRegistry.registerDoubleClickBinding((IMouseEventMatcher)MouseEventMatcher.rowHeaderLeftClick((int)0), new IMouseAction(){

                        public void run(NatTable natTable, MouseEvent event) {
                            try {
                                int rowPosition = natTable.getRowPositionByY(event.y);
                                int rowIndex = natTable.getRowIndexByPosition(rowPosition);
                                EObject element = TraceabilityMatrixView.this.bodyDataProvider.getRow(rowIndex);
                                TraceabilityMatrixView.this.openEditor(element);
                            }
                            catch (PartInitException partInitException) {
                                // empty catch block
                            }
                        }
                    });
                }
            });
            this.setUnderlyingLayer((ILayer)rowHeaderLayer);
        }
    }
}

