/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.office.utils;

import com.google.common.base.Strings;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.poi.hssf.OldExcelFormatException;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.xmlbeans.SchemaTypeLoaderException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class CapraOfficeUtils {
    private CapraOfficeUtils() {
    }

    public static Map<String, Boolean> getSheetsEmptinessInfo(Workbook workBook) {
        HashMap<String, Boolean> isSheetEmptyMap = new HashMap<String, Boolean>();
        int i = 0;
        while (i < workBook.getNumberOfSheets()) {
            Sheet s = workBook.getSheetAt(i);
            isSheetEmptyMap.put(s.getSheetName(), s.getLastRowNum() < 1);
            ++i;
        }
        return isSheetEmptyMap;
    }

    public static Sheet getSheet(Workbook workBook, String sheetName) throws NullPointerException {
        String actualSheetName = sheetName;
        if (Strings.isNullOrEmpty((String)sheetName)) {
            int activeSheetIndex;
            try {
                activeSheetIndex = workBook.getActiveSheetIndex();
            }
            catch (NullPointerException e1) {
                try {
                    activeSheetIndex = workBook.getFirstVisibleTab();
                }
                catch (NullPointerException e2) {
                    activeSheetIndex = 0;
                }
            }
            actualSheetName = workBook.getSheetName(activeSheetIndex);
        }
        return workBook.getSheet(actualSheetName);
    }

    public static Workbook getExcelWorkbook(File excelFile) throws OldExcelFormatException, IOException {
        String fileType = Files.getFileExtension((String)excelFile.getAbsolutePath());
        Object workBook = fileType.equals("xlsx") ? new XSSFWorkbook((InputStream)new FileInputStream(excelFile)) : new HSSFWorkbook((InputStream)new FileInputStream(excelFile));
        return workBook;
    }

    public static List<XWPFParagraph> getWordParagraphs(File wordFile) throws SchemaTypeLoaderException, IOException {
        FileInputStream fs = new FileInputStream(wordFile);
        XWPFDocument xwpfDoc = new XWPFDocument((InputStream)fs);
        return xwpfDoc.getParagraphs();
    }

    public static Document createDOMDocument(String xml) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        InputSource is = new InputSource(new StringReader(xml));
        return builder.parse(is);
    }
}

