/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.core.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.capra.core.adapters.ArtifactMetaModelAdapter;
import org.eclipse.capra.core.adapters.TraceMetaModelAdapter;
import org.eclipse.capra.core.adapters.TracePersistenceAdapter;
import org.eclipse.capra.core.handlers.IArtifactHandler;
import org.eclipse.capra.core.handlers.PriorityHandler;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class ExtensionPointHelper {
    private static final String TRACE_ID = "org.eclipse.capra.configuration.traceabilityMetaModel";
    private static final String TRACE_CONFIG = "class";
    private static final String PERSISTENCE_ID = "org.eclipse.capra.configuration.persistenceHandler";
    private static final String PERSISTENCE_CONFIG = "class";
    private static final String ARTIFACT_ID = "org.eclipse.capra.configuration.artifactMetaModel";
    private static final String ARTIFACT_CONFIG = "class";
    private static final String ARTIFACT_HANDLER_ID = "org.eclipse.capra.configuration.artifactHandlers";
    private static final String ARTIFACT_HANDLER_CONFIG = "class";
    private static final String PRIORITY_HANDLER_ID = "org.eclipse.capra.configuration.priorityHandlers";
    private static final String PRIORITY_HANDLER_CONFIG = "class";

    private ExtensionPointHelper() {
    }

    public static List<Object> getExtensions(String id, String attributeName) {
        try {
            IConfigurationElement[] configs = Platform.getExtensionRegistry().getConfigurationElementsFor(id);
            ArrayList<Object> extensions = new ArrayList<Object>();
            IConfigurationElement[] iConfigurationElementArray = configs;
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement config = iConfigurationElementArray[n2];
                extensions.add(config.createExecutableExtension(attributeName));
                ++n2;
            }
            return extensions;
        }
        catch (Exception ex) {
            return Collections.emptyList();
        }
    }

    public static Optional<IArtifactHandler<?>> getExtension(String extensionId, String extensionPointId, String propertyName) {
        try {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtension extension = registry.getExtension(extensionPointId, extensionId);
            IConfigurationElement[] elements = extension.getConfigurationElements();
            return Optional.of((IArtifactHandler)elements[0].createExecutableExtension(propertyName));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static Optional<TraceMetaModelAdapter> getTraceMetamodelAdapter() {
        try {
            Object extension = ExtensionPointHelper.getExtensions(TRACE_ID, "class").get(0);
            return Optional.of((TraceMetaModelAdapter)extension);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static Optional<TracePersistenceAdapter> getTracePersistenceAdapter() {
        try {
            Object extension = ExtensionPointHelper.getExtensions(PERSISTENCE_ID, "class").get(0);
            return Optional.of((TracePersistenceAdapter)extension);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static Optional<ArtifactMetaModelAdapter> getArtifactWrapperMetaModelAdapter() {
        try {
            Object extension = ExtensionPointHelper.getExtensions(ARTIFACT_ID, "class").get(0);
            return Optional.of((ArtifactMetaModelAdapter)extension);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static Collection<IArtifactHandler<?>> getArtifactHandlers() {
        List<Object> extensions = ExtensionPointHelper.getExtensions(ARTIFACT_HANDLER_ID, "class");
        List illegalClasses = extensions.stream().filter(c -> !(c instanceof IArtifactHandler)).collect(Collectors.toList());
        if (!illegalClasses.isEmpty()) {
            throw new IllegalStateException("Illegal classes at org.eclipse.capra.configuration.artifactHandlers: " + illegalClasses);
        }
        return extensions.stream().map(IArtifactHandler.class::cast).collect(Collectors.toList());
    }

    public static Optional<IArtifactHandler<?>> getArtifactHandler(String id) {
        return ExtensionPointHelper.getExtension(id, ARTIFACT_HANDLER_ID, "class");
    }

    public static Optional<PriorityHandler> getPriorityHandler() {
        try {
            Object extension = ExtensionPointHelper.getExtensions(PRIORITY_HANDLER_ID, "class").get(0);
            return Optional.of((PriorityHandler)extension);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }
}

