/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.generic.artifactmodel;

import java.util.List;
import org.eclipse.capra.core.adapters.AbstractArtifactMetaModelAdapter;
import org.eclipse.capra.core.helpers.EditingDomainHelper;
import org.eclipse.capra.generic.artifactmodel.ArtifactWrapper;
import org.eclipse.capra.generic.artifactmodel.ArtifactWrapperContainer;
import org.eclipse.capra.generic.artifactmodel.ArtifactmodelFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalCommandStack;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

public class GenericArtifactMetaModelAdapter
extends AbstractArtifactMetaModelAdapter {
    private ArtifactWrapperContainer getContainer(EObject artifactModel) {
        return (ArtifactWrapperContainer)artifactModel;
    }

    public EObject createModel() {
        return ArtifactmodelFactory.eINSTANCE.createArtifactWrapperContainer();
    }

    public EObject getArtifact(EObject artifactModel, String artifactHandler, String artifactUri) {
        ArtifactWrapperContainer container = this.getContainer(artifactModel);
        for (ArtifactWrapper artifact : container.getArtifacts()) {
            if (!this.getArtifactHandler(artifact).equals(artifactHandler) || !this.getArtifactUri(artifact).equals(artifactUri)) continue;
            return artifact;
        }
        return null;
    }

    public EObject createArtifact(EObject artifactModel, String artifactHandler, String artifactUri, String artifactId, String artifactName, String artifactPath) {
        final ArtifactWrapperContainer container = this.getContainer(artifactModel);
        EObject existingWrapper = this.getArtifact(artifactModel, artifactHandler, artifactUri);
        if (existingWrapper != null) {
            return existingWrapper;
        }
        final ArtifactWrapper wrapper = ArtifactmodelFactory.eINSTANCE.createArtifactWrapper();
        wrapper.setArtifactHandler(artifactHandler);
        wrapper.setUri(artifactUri);
        wrapper.setName(artifactName);
        wrapper.setPath(artifactPath);
        wrapper.setIdentifier(artifactId);
        TransactionalEditingDomain editingDomain = EditingDomainHelper.getEditingDomain();
        RecordingCommand cmd = new RecordingCommand(editingDomain, "Add trace"){

            protected void doExecute() {
                container.getArtifacts().add((Object)wrapper);
            }
        };
        try {
            ((TransactionalCommandStack)editingDomain.getCommandStack()).execute((Command)cmd, null);
        }
        catch (RollbackException e) {
            throw new IllegalStateException("Adding a trace link was rolled back.", e);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Adding a trace link was interrupted.", e);
        }
        return wrapper;
    }

    public String getArtifactHandler(EObject artifact) {
        if (artifact instanceof ArtifactWrapper) {
            ArtifactWrapper wrapper = (ArtifactWrapper)artifact;
            return wrapper.getArtifactHandler();
        }
        return null;
    }

    public String getArtifactName(EObject artifact) {
        if (artifact instanceof ArtifactWrapper) {
            ArtifactWrapper wrapper = (ArtifactWrapper)artifact;
            return wrapper.getName();
        }
        return null;
    }

    public String getArtifactUri(EObject artifact) {
        if (artifact instanceof ArtifactWrapper) {
            ArtifactWrapper wrapper = (ArtifactWrapper)artifact;
            return wrapper.getUri();
        }
        return null;
    }

    public String getArtifactIdentifier(EObject artifact) {
        if (artifact instanceof ArtifactWrapper) {
            ArtifactWrapper wrapper = (ArtifactWrapper)artifact;
            return wrapper.getIdentifier();
        }
        return null;
    }

    public IPath getArtifactPath(EObject artifact) {
        if (artifact instanceof ArtifactWrapper) {
            ArtifactWrapper wrapper = (ArtifactWrapper)artifact;
            return new Path(wrapper.getPath());
        }
        return null;
    }

    public List<EObject> getAllArtifacts(EObject artifactModel) {
        ArtifactWrapperContainer container = this.getContainer(artifactModel);
        return (List)container.getArtifacts();
    }
}

