/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.helpers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.capra.core.helpers.ExtensionPointHelper;
import org.eclipse.capra.ui.selections.ISelectionSupport;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.views.properties.PropertySheet;

public class SelectionSupportHelper {
    private static final List<ISelectionSupport> SELECTION_SUPPORTS = new ArrayList<ISelectionSupport>();

    static {
        for (Object extension : ExtensionPointHelper.getExtensions((String)"org.eclipse.capra.ui.selectionSupport", (String)"class")) {
            SELECTION_SUPPORTS.add((ISelectionSupport)extension);
        }
    }

    private SelectionSupportHelper() {
    }

    public static List<Object> extractSelectedElements(ExecutionEvent event) {
        IWorkbenchPart workbenchPart = HandlerUtil.getActivePart((ExecutionEvent)event);
        ISelection currentSelection = workbenchPart.getSite().getSelectionProvider() != null ? workbenchPart.getSite().getSelectionProvider().getSelection() : HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        return SelectionSupportHelper.extractSelectedElements(currentSelection, workbenchPart);
    }

    public static List<Object> extractSelectedElements(ISelection selection, IWorkbenchPart workbenchPart) {
        ArrayList<Object> selectedElem = new ArrayList<Object>();
        for (ISelectionSupport handler : SELECTION_SUPPORTS) {
            List<Object> extractedElements;
            if (!handler.supportsWorkbenchPart(workbenchPart) || (extractedElements = handler.extractSelectedElements(selection, workbenchPart)) == null) continue;
            selectedElem.addAll(extractedElements);
            break;
        }
        if (selectedElem.isEmpty()) {
            selectedElem = new ArrayList();
            if (selection instanceof IStructuredSelection) {
                for (ISelectionSupport selElement : ((IStructuredSelection)selection).toList()) {
                    Object adaptedElement;
                    Object element;
                    Object selectedElement = element = AdapterFactoryEditingDomain.unwrap((Object)selElement);
                    if (element instanceof IAdaptable && (adaptedElement = ((IAdaptable)element).getAdapter(Object.class)) != null) {
                        selectedElement = adaptedElement;
                    }
                    selectedElem.add(selectedElement);
                }
            }
        }
        return selectedElem;
    }

    public static ResourceSet getResourceSet(IWorkbenchPart part) {
        ResourceSet resourceSet = null;
        if (!(part instanceof PropertySheet)) {
            IEditingDomainProvider domainProvider;
            for (ISelectionSupport handler : SELECTION_SUPPORTS) {
                ResourceSet resSet;
                if (!handler.supportsWorkbenchPart(part) || (resSet = handler.getResourceSet(part)) == null) continue;
                resourceSet = resSet;
            }
            if (resourceSet == null && (domainProvider = (IEditingDomainProvider)part.getAdapter(IEditingDomainProvider.class)) != null) {
                return domainProvider.getEditingDomain().getResourceSet();
            }
        }
        return resourceSet;
    }
}

