/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cft.server.core.ICloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.ui.internal.CloudFoundryImages;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.cft.server.ui.internal.wizards.ApplicationURLWizard;
import org.eclipse.cft.server.ui.internal.wizards.MappedURLsWizard;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;

public class MappedURLsWizardPage
extends WizardPage {
    private Button addButton;
    private Button removeButton;
    private Button editButton;
    private List<String> urls = new ArrayList<String>();
    private TableViewer viewer;
    private final CloudFoundryServer cloudServer;

    public MappedURLsWizardPage(CloudFoundryServer cloudServer, List<String> existingURIs, ICloudFoundryApplicationModule appModule) {
        super(Messages.MappedURLsWizardPage_TEXT_MAPPED_URI);
        if (existingURIs != null) {
            this.urls.addAll(existingURIs);
        }
        this.cloudServer = cloudServer;
        this.setTitle(Messages.MappedURLsWizardPage_TITLE_MAPPED_URI_CONFIG);
        this.setDescription(Messages.MappedURLsWizardPage_TEST_FINISH);
        ImageDescriptor banner = CloudFoundryImages.getWizardBanner(cloudServer.getServer().getServerType().getId());
        if (banner != null) {
            this.setImageDescriptor(banner);
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).spacing(10, LayoutConstants.getSpacing().y).applyTo(composite);
        Label label = new Label(composite, 0);
        label.setText(Messages.MappedURLsWizardPage_LABEL_APP_URI);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)label);
        Table table = new Table(composite, 67586);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)table);
        this.viewer = new TableViewer(table);
        this.viewer.setContentProvider((IContentProvider)new URIsContentProvider());
        this.viewer.setInput(this.urls);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                MappedURLsWizardPage.this.removeButton.setEnabled(!selection.isEmpty());
                MappedURLsWizardPage.this.editButton.setEnabled(!selection.isEmpty() && selection instanceof IStructuredSelection && ((IStructuredSelection)selection).toArray().length == 1);
            }
        });
        Composite buttonComposite = new Composite(composite, 0);
        GridLayoutFactory.fillDefaults().margins(0, 0).applyTo(buttonComposite);
        GridDataFactory.fillDefaults().align(131072, 4).applyTo((Control)buttonComposite);
        this.addButton = new Button(buttonComposite, 8);
        this.addButton.setText(Messages.COMMONTXT_ADD);
        GridDataFactory.fillDefaults().align(4, 4).grab(false, false).applyTo((Control)this.addButton);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ApplicationURLWizard wizard = new ApplicationURLWizard(MappedURLsWizardPage.this.cloudServer, null);
                WizardDialog dialog = new WizardDialog(MappedURLsWizardPage.this.addButton.getShell(), (IWizard)wizard);
                if (dialog.open() == 0) {
                    String newURI = wizard.getUrl();
                    MappedURLsWizardPage.this.urls.add(newURI);
                    MappedURLsWizardPage.this.update();
                }
            }
        });
        this.editButton = new Button(buttonComposite, 8);
        this.editButton.setText(Messages.COMMONTXT_EDIT);
        GridDataFactory.fillDefaults().align(4, 4).grab(false, false).applyTo((Control)this.editButton);
        this.editButton.setEnabled(false);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)MappedURLsWizardPage.this.viewer.getSelection();
                String url = (String)selection.getFirstElement();
                ApplicationURLWizard wizard = new ApplicationURLWizard(MappedURLsWizardPage.this.cloudServer, url);
                WizardDialog dialog = new WizardDialog(MappedURLsWizardPage.this.addButton.getShell(), (IWizard)wizard);
                if (dialog.open() == 0) {
                    String newURI = wizard.getUrl();
                    MappedURLsWizardPage.this.urls.remove(url);
                    MappedURLsWizardPage.this.urls.add(newURI);
                    MappedURLsWizardPage.this.update();
                }
            }
        });
        this.removeButton = new Button(buttonComposite, 8);
        this.removeButton.setText(Messages.COMMONTXT_REMOVE);
        GridDataFactory.fillDefaults().align(4, 4).grab(false, false).applyTo((Control)this.addButton);
        this.removeButton.setEnabled(false);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] selectedURLs;
                IStructuredSelection selection = (IStructuredSelection)MappedURLsWizardPage.this.viewer.getSelection();
                Object[] objectArray = selectedURLs = selection.toArray();
                int n = selectedURLs.length;
                int n2 = 0;
                while (n2 < n) {
                    Object selectedURL = objectArray[n2];
                    MappedURLsWizardPage.this.urls.remove(selectedURL);
                    MappedURLsWizardPage.this.update();
                    ++n2;
                }
            }
        });
        Dialog.applyDialogFont((Control)composite);
        this.setControl((Control)composite);
    }

    private void update() {
        this.viewer.refresh(true);
        this.getWizard().getContainer().updateButtons();
    }

    public boolean isPageComplete() {
        return !((MappedURLsWizard)this.getWizard()).requiresURL() || !this.urls.isEmpty();
    }

    public List<String> getURLs() {
        return this.urls;
    }

    private class URIsContentProvider
    implements ITreeContentProvider {
        private URIsContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }

        public Object[] getElements(Object inputElement) {
            return MappedURLsWizardPage.this.urls.toArray();
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

