/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.actions;

import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.ui.IServerModule;

public abstract class AbstractCloudFoundryServerAction
implements IObjectActionDelegate {
    private IModule selectedModule;
    private IServer selectedServer;

    public void selectionChanged(IAction action, ISelection selection) {
        this.selectedServer = this.getSelectedServer(selection);
        CloudFoundryServer cloudServer = this.selectedServer != null ? (CloudFoundryServer)this.selectedServer.loadAdapter(CloudFoundryServer.class, null) : null;
        CloudFoundryApplicationModule appModule = cloudServer != null && this.selectedModule != null ? cloudServer.getExistingCloudModule(this.selectedModule) : null;
        this.serverSelectionChanged(cloudServer, appModule, action);
    }

    protected void serverSelectionChanged(CloudFoundryServer cloudServer, CloudFoundryApplicationModule appModule, IAction action) {
    }

    public void run(IAction action) {
        CloudFoundryApplicationModule appModule;
        String error = null;
        CloudFoundryServer cloudServer = this.selectedServer != null ? (CloudFoundryServer)this.selectedServer.loadAdapter(CloudFoundryServer.class, null) : null;
        CloudFoundryApplicationModule cloudFoundryApplicationModule = appModule = cloudServer != null && this.selectedModule != null ? cloudServer.getExistingCloudModule(this.selectedModule) : null;
        if (this.selectedServer == null) {
            error = "No Cloud Foundry server instance available to run the selected action.";
        }
        if (error == null) {
            this.doRun(cloudServer, appModule, action);
        } else {
            error = String.valueOf(error) + " - " + action.getText();
            CloudFoundryPlugin.logError((String)error);
        }
    }

    abstract void doRun(CloudFoundryServer var1, CloudFoundryApplicationModule var2, IAction var3);

    protected IServer getSelectedServer(ISelection selection) {
        IServer server = null;
        this.selectedModule = null;
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            Object obj = ((IStructuredSelection)selection).getFirstElement();
            if (obj instanceof IServer) {
                server = (IServer)obj;
            } else if (obj instanceof IServerModule) {
                IServerModule sm = (IServerModule)obj;
                IModule[] module = sm.getModule();
                this.selectedModule = module[module.length - 1];
                if (this.selectedModule != null) {
                    server = sm.getServer();
                }
            }
        }
        return server;
    }
}

