/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.actions;

import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.ui.internal.CloudFoundryServerUiPlugin;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.cft.server.ui.internal.actions.BaseCommandHandler;
import org.eclipse.cft.server.ui.internal.wizards.ConnectSsoServerDialog;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IServer;

public class ConnectCommand
extends BaseCommandHandler {
    private static final Object dialogLock = new Object();
    private static boolean isDialogOpen = false;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.initializeSelection(event);
        return ConnectCommand.openConnectDialogInJob(this.selectedServer);
    }

    private static Object openConnectDialogInJob(IServer selectedServer) {
        final CloudFoundryServer cloudServer = (CloudFoundryServer)selectedServer.loadAdapter(CloudFoundryServer.class, null);
        Job connectJob = new Job(Messages.ConnectCommand_JOB_CONN_SERVER){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ConnectCommand.openConnectDialog(cloudServer, monitor);
                }
                catch (OperationCanceledException operationCanceledException) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        connectJob.schedule();
        return null;
    }

    public static boolean openConnectDialog(final CloudFoundryServer cloudServer, IProgressMonitor monitor) {
        final AtomicBoolean result = new AtomicBoolean(false);
        if (!cloudServer.isSso()) {
            try {
                cloudServer.getBehaviour().connect(monitor);
                result.set(true);
            }
            catch (Exception e) {
                CloudFoundryServerUiPlugin.logError(e);
                result.set(false);
            }
        }
        if (cloudServer.isSso() && !cloudServer.isConnected()) {
            Display.getDefault().syncExec(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = dialogLock;
                    synchronized (object) {
                        if (isDialogOpen) {
                            return;
                        }
                        isDialogOpen = true;
                    }
                    try {
                        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                        ConnectSsoServerDialog dialog = new ConnectSsoServerDialog(shell, cloudServer);
                        dialog.open();
                        result.set(dialog.isConnectionSuccess());
                    }
                    catch (Throwable throwable) {
                        Object object2 = dialogLock;
                        synchronized (object2) {
                            isDialogOpen = false;
                        }
                        throw throwable;
                    }
                    Object object3 = dialogLock;
                    synchronized (object3) {
                        isDialogOpen = false;
                    }
                }
            });
        }
        return result.get();
    }
}

