/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.ssh;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.cloudfoundry.client.lib.CloudFoundryException;
import org.cloudfoundry.client.lib.CloudFoundryOperations;
import org.cloudfoundry.client.lib.CloudOperationException;
import org.cloudfoundry.client.lib.HttpProxyConfiguration;
import org.cloudfoundry.client.lib.domain.CloudApplication;
import org.eclipse.cft.server.core.ISshClientSupport;
import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.CloudServerUtil;
import org.eclipse.cft.server.core.internal.Messages;
import org.eclipse.cft.server.core.internal.client.CFClientV1Support;
import org.eclipse.cft.server.core.internal.client.CFInfo;
import org.eclipse.cft.server.core.internal.ssh.SshHost;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IServer;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public class SshClientSupport
extends CFClientV1Support
implements ISshClientSupport {
    private String sshClientId;

    public SshClientSupport(CloudFoundryOperations cfClient, CFInfo cloudInfo, HttpProxyConfiguration httpProxyConfiguration, CloudFoundryServer server, boolean trustSelfSigned) {
        super(cfClient, null, cloudInfo, httpProxyConfiguration, server, trustSelfSigned);
        this.sshClientId = cloudInfo.getSshClientId();
    }

    @Override
    public String getSshCode() {
        try {
            URIBuilder builder = new URIBuilder(String.valueOf(this.tokenUrl) + "/oauth/authorize");
            builder.addParameter("response_type", "code");
            builder.addParameter("grant_type", "authorization_code");
            builder.addParameter("client_id", this.sshClientId);
            URI url = new URI(builder.toString());
            ResponseEntity response = this.restTemplate.getForEntity(url, String.class);
            HttpStatus statusCode = response.getStatusCode();
            if (statusCode != HttpStatus.FOUND) {
                throw new CloudFoundryException(statusCode);
            }
            String loc = response.getHeaders().getFirst("Location");
            if (loc == null) {
                throw new CloudOperationException("No 'Location' header in redirect response");
            }
            List qparams = URLEncodedUtils.parse((URI)new URI(loc), (String)"utf8");
            for (NameValuePair pair : qparams) {
                String name = pair.getName();
                if (!name.equals("code")) continue;
                return pair.getValue();
            }
            throw new CloudOperationException("No 'code' param in redirect Location: " + loc);
        }
        catch (URISyntaxException e) {
            throw new CloudOperationException((Throwable)e);
        }
    }

    public SshHost getSshHost() {
        return this.getCloudInfo().getSshHost();
    }

    public static ISshClientSupport create(CloudFoundryOperations client, CFInfo cloudInfo, HttpProxyConfiguration proxyConf, CloudFoundryServer cfServer, boolean selfSigned) {
        return new SshClientSupport(client, cloudInfo, proxyConf, cfServer, selfSigned);
    }

    @Override
    public Session connect(String appName, int appInstance, IServer server, IProgressMonitor monitor) throws CoreException {
        CloudFoundryServer cloudServer = CloudServerUtil.getCloudServer(server);
        CloudApplication app = cloudServer.getBehaviour().getCloudApplication(appName, monitor);
        if (app == null) {
            throw CloudErrorUtil.toCoreException(NLS.bind((String)Messages.SshClientSupport_NO_CLOUD_APP, (Object)appName));
        }
        JSch jsch = new JSch();
        String user = "cf:" + app.getMeta().getGuid().toString() + "/" + appInstance;
        String oneTimeCode = null;
        try {
            Session session = jsch.getSession(user, this.getSshHost().getHost(), this.getSshHost().getPort());
            oneTimeCode = this.getSshCode();
            session.setPassword(oneTimeCode);
            session.setUserInfo(this.getUserInfo(oneTimeCode));
            session.setServerAliveInterval(15000);
            session.connect();
            return session;
        }
        catch (JSchException e) {
            throw CloudErrorUtil.asCoreException("SSH connection error " + e.getMessage(), e, false);
        }
    }

    protected UserInfo getUserInfo(final String accessToken) {
        return new UserInfo(){

            public void showMessage(String arg0) {
            }

            public boolean promptYesNo(String arg0) {
                return true;
            }

            public boolean promptPassword(String arg0) {
                return true;
            }

            public boolean promptPassphrase(String arg0) {
                return false;
            }

            public String getPassword() {
                return accessToken;
            }

            public String getPassphrase() {
                return null;
            }
        };
    }
}

