/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.standalone.core.internal.application;

import java.util.Set;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryProjectUtil;
import org.eclipse.cft.server.standalone.core.internal.application.JavaLauncherModuleDelegate;
import org.eclipse.cft.server.standalone.core.internal.application.StandaloneFacetHandler;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.model.ModuleDelegate;
import org.eclipse.wst.server.core.util.ProjectModuleFactoryDelegate;
import org.osgi.framework.Bundle;

public class StandAloneModuleFactory
extends ProjectModuleFactoryDelegate {
    public ModuleDelegate getModuleDelegate(IModule module) {
        return new JavaLauncherModuleDelegate(module.getProject());
    }

    public IModule[] createModules(IProject project) {
        IModule module;
        if (this.canCreateModule(project) && (module = this.createModule(project.getName(), project.getName(), "cloudfoundry.standalone.app", "1.0", project)) != null) {
            return new IModule[]{module};
        }
        return null;
    }

    protected boolean canCreateModule(IProject project) {
        return StandAloneModuleFactory.canHandle(project);
    }

    public static boolean canHandle(IProject project) {
        if (!CloudFoundryProjectUtil.hasNature((IResource)project, (String)"org.eclipse.jdt.core.javanature")) {
            return false;
        }
        StandaloneFacetHandler handler = new StandaloneFacetHandler(project);
        if (StandAloneModuleFactory.isSpringIDEInstalled() && StandAloneModuleFactory.hasNoFacets(project) && CloudFoundryProjectUtil.isSpringBoot((IProject)project)) {
            handler.addFacet((IProgressMonitor)new NullProgressMonitor());
        }
        return handler.hasFacet();
    }

    private static boolean hasNoFacets(IProject project) {
        boolean hasNoFacets = false;
        try {
            Set facets;
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
            hasNoFacets = facetedProject != null ? (facets = facetedProject.getProjectFacets()) == null || facets.isEmpty() : true;
        }
        catch (CoreException e) {
            CloudFoundryPlugin.logError((Throwable)e);
        }
        return hasNoFacets;
    }

    private static boolean isSpringIDEInstalled() {
        Bundle bundle = null;
        try {
            bundle = Platform.getBundle((String)"org.springframework.ide.eclipse.core");
        }
        catch (Throwable throwable) {}
        return bundle != null;
    }
}

