/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.wizards;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.cloudfoundry.client.lib.domain.CloudSpace;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.CloudServerUtil;
import org.eclipse.cft.server.ui.internal.CloudSpacesDelegate;
import org.eclipse.cft.server.ui.internal.CloudSpacesSelectionPart;
import org.eclipse.cft.server.ui.internal.EventSource;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.cft.server.ui.internal.PartChangeEvent;
import org.eclipse.cft.server.ui.internal.ValidationEventHandler;
import org.eclipse.cft.server.ui.internal.wizards.CloneServerWizardValidator;
import org.eclipse.cft.server.ui.internal.wizards.CloudFoundryCloudSpaceWizardpage;
import org.eclipse.cft.server.ui.internal.wizards.WizardPageStatusHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.progress.UIJob;

class CloneServerPage
extends CloudFoundryCloudSpaceWizardpage {
    private String serverName;
    private Text serverNameText;
    private CloudSpace selectedSpace;
    private ValidationEventHandler serverEventHandler = new ValidationEventHandler();
    private Set<String> existingServerNames = null;

    CloneServerPage(CloudFoundryServer server) {
        super(server, null);
        this.cloudServerSpaceDelegate = new CloudSpacesDelegate(this.cloudServer){

            @Override
            public void setSelectedSpace(CloudSpace selectedCloudSpace) {
                CloneServerPage.this.selectedSpace = selectedCloudSpace;
                CloneServerPage.this.setServerNameInUI(CloneServerPage.this.getSuggestedServerName(selectedCloudSpace));
            }

            @Override
            protected CloudSpace getCurrentCloudSpace() {
                return CloneServerPage.this.selectedSpace;
            }
        };
    }

    protected String getSuggestedServerName(CloudSpace selectedCloudSpace) {
        if (selectedCloudSpace == null) {
            return null;
        }
        String suggestedName = selectedCloudSpace.getName();
        int i = 1;
        while (this.nameExists(suggestedName)) {
            int openParIndex = suggestedName.indexOf(40);
            int closeParIndex = suggestedName.indexOf(41);
            if (openParIndex > 0 && closeParIndex > openParIndex) {
                suggestedName = suggestedName.substring(0, openParIndex).trim();
            }
            suggestedName = String.valueOf(suggestedName) + " (" + i++ + ")";
        }
        return suggestedName;
    }

    protected boolean nameExists(String name) {
        if (name == null) {
            return false;
        }
        if (this.existingServerNames == null) {
            this.existingServerNames = new HashSet<String>();
            List cloudServers = CloudServerUtil.getCloudServers();
            if (cloudServers != null) {
                for (CloudFoundryServer server : cloudServers) {
                    this.existingServerNames.add(server.getServer().getName());
                }
            }
        }
        return this.existingServerNames.contains(name);
    }

    public String getServerName() {
        return this.serverName;
    }

    @Override
    public boolean isPageComplete() {
        boolean isComplete = super.isPageComplete();
        if (isComplete) {
            isComplete = this.serverEventHandler.isOK();
        }
        return isComplete;
    }

    @Override
    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(5, 5).applyTo(mainComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)mainComposite);
        Composite serverNameComp = new Composite(mainComposite, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(serverNameComp);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)serverNameComp);
        Label label = new Label(serverNameComp, 0);
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)label);
        label.setText(Messages.CloneServerPage_LABEL_SERVER_NAME);
        this.serverNameText = new Text(serverNameComp, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.serverNameText);
        this.serverNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                CloneServerPage.this.serverName = CloneServerPage.this.serverNameText.getText();
                CloneServerPage.this.refresh();
            }
        });
        WizardPageStatusHandler listener = new WizardPageStatusHandler(this);
        this.serverEventHandler.updateValidator(new CloneServerWizardValidator(this.cloudServer, this.cloudServerSpaceDelegate));
        this.serverEventHandler.addStatusHandler(listener);
        this.spacesPart = new CloudSpacesSelectionPart(this.cloudServerSpaceDelegate, this.cloudServer, this){

            @Override
            public void setInitialSelectionInViewer() {
                if (CloneServerPage.this.cloudServerSpaceDelegate == null) {
                    return;
                }
                CloudSpace selectedSpace = this.cloudSpaceServerDelegate.getSpaceWithNoServerInstance();
                this.setSpaceSelection(selectedSpace);
                if (selectedSpace != null) {
                    this.setSelectionInViewer(selectedSpace);
                }
            }
        };
        this.spacesPart.addPartChangeListener(this.serverEventHandler);
        this.spacesPart.createPart(mainComposite);
        this.setDescription(Messages.CLONE_SERVER_WIZARD_OK_MESSAGE);
        this.setControl((Control)mainComposite);
    }

    public CloudSpace getSelectedCloudSpace() {
        return this.selectedSpace;
    }

    protected void refresh() {
        IStatus status = Status.OK_STATUS;
        if (this.serverName == null || this.serverName.trim().length() == 0) {
            status = CloudFoundryPlugin.getErrorStatus((String)Messages.ERROR_VALID_SERVER_NAME);
        } else if (this.nameExists(this.serverName)) {
            status = CloudFoundryPlugin.getErrorStatus((String)Messages.ERROR_SERVER_NAME_ALREADY_EXISTS);
        }
        this.serverEventHandler.handleChange(new PartChangeEvent(null, status, new EventSource<CloneServerPage>(this), 1003));
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            UIJob job = new UIJob(Messages.CloneServerPage_JOB_REFRESH_ORG_SPACE){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    CloneServerPage.this.updateSpacesDescriptor();
                    CloneServerPage.this.refreshListOfSpaces();
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
    }

    protected void setServerNameInUI(String name) {
        if (this.serverNameText != null && name != null) {
            this.serverName = name;
            this.serverNameText.setText(name);
        }
    }

    protected void updateSpacesDescriptor() {
        this.serverEventHandler.validate((IRunnableContext)this.getWizard().getContainer());
    }
}

